/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.usersurvey_portlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import it.eng.edison.usersurvey_portlet.client.GreetingService;
import it.eng.edison.usersurvey_portlet.client.UserDTO;
import it.eng.edison.usersurvey_portlet.client.model.SurveyModel;
import it.eng.edison.usersurvey_portlet.client.model.SurveyQuestionModel;
import it.eng.edison.usersurvey_portlet.client.model.SurveyUserAnswerModel;
import it.eng.edison.usersurvey_portlet.server.dao.ChoiceanswerJpaController;
import it.eng.edison.usersurvey_portlet.server.dao.ChoicequestionJpaController;
import it.eng.edison.usersurvey_portlet.server.dao.GridanswerJpaController;
import it.eng.edison.usersurvey_portlet.server.dao.GridquestionJpaController;
import it.eng.edison.usersurvey_portlet.server.dao.InvitationtokenJpaController;
import it.eng.edison.usersurvey_portlet.server.dao.SurveyJpaController;
import it.eng.edison.usersurvey_portlet.server.dao.SurveyquestionJpaController;
import it.eng.edison.usersurvey_portlet.server.dao.SurveyuseranswerJpaController;
import it.eng.edison.usersurvey_portlet.server.dao.exceptions.IllegalOrphanException;
import it.eng.edison.usersurvey_portlet.server.dao.exceptions.NonexistentEntityException;
import it.eng.edison.usersurvey_portlet.server.entity.Survey;
import it.eng.edison.usersurvey_portlet.server.entity.Surveyquestion;
import it.eng.edison.usersurvey_portlet.server.entity.Surveyuseranswer;
import it.eng.edison.usersurvey_portlet.server.util.CSVUtils;
import it.eng.edison.usersurvey_portlet.server.util.CreateDB;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.Key;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.custom.communitymanager.impl.GCubeSiteManagerImpl;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;

public class GreetingServiceImpl
extends RemoteServiceServlet
implements GreetingService {
    private static final String HOST_PROPERTY = "host";
    public static final Integer MIN_NUM_RANDOM = 1000;
    public static final Integer MAX_NUM_RANDOM = 10000;
    public static final String VRE_MANAGER_LABEL = "VRE-Manager";
    public static final String VRE_DESIGNER_LABEL = "VRE-Designer";
    public static final String VO_ADMIN_LABEL = "VRE-Designer";
    public static final String INFRA_MANAGER_LABEL = "Infrastructure-Manager";
    public static final String DATA_MANAGER_LABEL = "Data-Manager";
    private static String RUNTIME_RESOURCE_NAME = "SurveyDB";
    private static String CATEGORY_NAME = "Database";
    private static String ROW_LABEL = "Row";
    private static String COLUMN_LABEL = "Column";
    private long folderID = 0L;
    private Folder dlFolder = null;
    private String pathImage;
    private String jdbcURL = null;
    private Date localDate = null;
    private User userLiferay = null;
    private SurveyModel surveyModel = null;
    private List<SurveyModel> surveyModelList = null;
    private SurveyQuestionModel surveyQuestionModel = null;
    private SurveyQuestionModel surveyQuestionModelTemp = null;
    private List<SurveyQuestionModel> surveyQuestionModelList = null;
    List<String> choiceQuestionList = null;
    List<String> rowGridList = null;
    List<String> columnGridList = null;
    List<String> choiceAnswerList = null;
    List<String> gridAnswerList = null;
    private GroupManager gm = null;
    private ServiceContext serviceContext = null;
    private HttpSession httpSession = null;
    private String username = null;
    private ASLSession aslSession = null;
    private String scope = null;
    private int companyId = 0;
    private long groupId = 0L;
    private Map<String, String> persistenceMap = null;
    private EntityManagerFactory managerFactory = null;
    private String DBURL = null;
    private String DBName = null;
    private String uName = null;
    private String pwd = null;

    public void init() {
        this.setDBPropertyConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllSurvey(long idUser, SurveyModel surveyModel, long idTempFolder, List<SurveyQuestionModel> surveyQuestionModelList) {
        LiferayGroupManager gm = new LiferayGroupManager();
        String currentUsername = this.getThreadLocalRequest().getSession().getAttribute("username").toString();
        String scope = SessionManager.getInstance().getASLSession(this.getThreadLocalRequest().getSession().getId(), currentUsername).getScope();
        long currGroupId = 0L;
        try {
            currGroupId = gm.getGroupIdFromInfrastructureScope(scope);
        }
        catch (IllegalArgumentException | GroupRetrievalFault | UserManagementSystemException e1) {
            e1.printStackTrace();
        }
        Survey survey = new Survey();
        survey.setTitlesurvey(surveyModel.getTitlesurvey());
        survey.setIdusercreator((int)idUser);
        survey.setDatesurvay(surveyModel.getDateSurvay());
        survey.setExpiredDatesurvay(surveyModel.getExpiredDateSurvay());
        survey.setIsanonymous(surveyModel.getIsAnonymous());
        survey.setGroupid(currGroupId);
        if (surveyModel.getExpiredDateSurvay() != null) {
            this.localDate = this.setDate2LocalTimezone(surveyModel.getExpiredDateSurvay());
            survey.setExpiredDatesurvay(this.localDate);
        }
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyJpaController con = new SurveyJpaController(emf);
        try {
            con.create(survey);
        }
        catch (Exception e) {
            e.printStackTrace();
            emf.close();
        }
        finally {
            con.getEntityManager().close();
            con = null;
        }
        SurveyquestionJpaController SurveyquestionJpaController2 = new SurveyquestionJpaController(emf);
        ChoicequestionJpaController conChoice = new ChoicequestionJpaController(emf);
        GridquestionJpaController gridquestionJpaController = new GridquestionJpaController(emf);
        Surveyquestion surveyQuestion = null;
        try {
            for (int i = 0; i < surveyQuestionModelList.size(); ++i) {
                surveyQuestion = new Surveyquestion();
                surveyQuestion.setIdSurvey(survey);
                surveyQuestion.setNumberquestion(surveyQuestionModelList.get(i).getNumberquestion());
                surveyQuestion.setIsmandatory(surveyQuestionModelList.get(i).getIsmandatory());
                surveyQuestion.setQuestiontype(surveyQuestionModelList.get(i).getQuestiontype());
                surveyQuestion.setQuestion(surveyQuestionModelList.get(i).getQuestion());
                surveyQuestion.setImagefilename(surveyQuestionModelList.get(i).getImageFileName());
                surveyQuestion.setAnswer1(surveyQuestionModelList.get(i).getAnswer1());
                surveyQuestion.setAnswer2(surveyQuestionModelList.get(i).getAnswer2());
                surveyQuestion.setAnswer3(surveyQuestionModelList.get(i).getAnswer3());
                surveyQuestion.setAnswer4(surveyQuestionModelList.get(i).getAnswer4());
                surveyQuestion.setAnswer5(surveyQuestionModelList.get(i).getAnswer5());
                surveyQuestion.setAnswer6(surveyQuestionModelList.get(i).getAnswer6());
                surveyQuestion.setAnswer7(surveyQuestionModelList.get(i).getAnswer7());
                surveyQuestion.setAnswer8(surveyQuestionModelList.get(i).getAnswer8());
                surveyQuestion.setAnswer9(surveyQuestionModelList.get(i).getAnswer9());
                surveyQuestion.setAnswer10(surveyQuestionModelList.get(i).getAnswer10());
                surveyQuestion.setFolderidimage(surveyQuestionModelList.get(i).getFolderIdImage());
                surveyQuestion.setSectiontitle(surveyQuestionModelList.get(i).getSectionTitle());
                surveyQuestion.setSectiondescription(surveyQuestionModelList.get(i).getSectionDescription());
                if (surveyQuestionModelList.get(i).getDateAnswer() != null) {
                    this.localDate = this.setDate2LocalTimezone(surveyQuestionModelList.get(i).getDateAnswer());
                    surveyQuestion.setDateanswer(this.localDate);
                }
                SurveyquestionJpaController2.create(surveyQuestion);
                if (surveyQuestionModelList.get(i).getQuestiontype().contains("Multiple Choice") || surveyQuestionModelList.get(i).getQuestiontype().contains("CheckBoxes") || surveyQuestionModelList.get(i).getQuestiontype().contains("Drop-Down")) {
                    conChoice.insertMultipleChoice(survey, surveyQuestionModelList.get(i));
                }
                if (!surveyQuestionModelList.get(i).getQuestiontype().contains("Grid")) continue;
                gridquestionJpaController.insertRowColumn(survey, surveyQuestionModelList.get(i));
            }
            long surveyId = 0L;
            SurveyJpaController surveyJpaController = new SurveyJpaController(emf);
            try {
                surveyId = surveyJpaController.findSurveyIdByTitle(surveyModel.getTitlesurvey());
            }
            catch (Exception e) {
                e.printStackTrace();
                emf.close();
            }
            finally {
                surveyJpaController.getEntityManager().close();
                surveyJpaController = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SurveyquestionJpaController2.getEntityManager().close();
            conChoice.getEntityManager().close();
            gridquestionJpaController.getEntityManager().close();
            emf.close();
            SurveyquestionJpaController2 = null;
            conChoice = null;
            gridquestionJpaController = null;
            emf = null;
        }
    }

    public Long createFolder() {
        ServiceContext serviceContext = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Random random = new Random();
        int randomNum = random.nextInt(MAX_NUM_RANDOM - MIN_NUM_RANDOM + 1) + MIN_NUM_RANDOM;
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)this.getThreadLocalRequest());
            HttpSession httpSession = this.getThreadLocalRequest().getSession();
            String username = httpSession.getAttribute("username").toString();
            ASLSession aslSession = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
            String scope = aslSession.getScope();
            this.companyId = (int)GCubeSiteManagerImpl.getCompany().getCompanyId();
            long groupId = gm.getGroupIdFromInfrastructureScope(scope);
            this.userLiferay = UserLocalServiceUtil.getUserByScreenName((long)this.companyId, (String)username);
            long userID = this.userLiferay.getUserId();
            this.dlFolder = DLAppLocalServiceUtil.addFolder((long)userID, (long)groupId, (long)0L, (String)("surveyImages_" + String.valueOf(randomNum)), (String)"survey folder", (ServiceContext)serviceContext);
            this.dlFolder.getParentFolderId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.dlFolder.getFolderId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOldImage(int idSurvey, long idTmpFolder, String image2Delete) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyquestionJpaController con = new SurveyquestionJpaController(emf);
        if (image2Delete != null && !image2Delete.equals("")) {
            try {
                con.deleteImageFilenameFromDB(idSurvey);
                FileEntry fileEntry = null;
                LiferayGroupManager gm = new LiferayGroupManager();
                ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)this.getThreadLocalRequest());
                HttpSession httpSession = this.getThreadLocalRequest().getSession();
                String username = httpSession.getAttribute("username").toString();
                ASLSession aslSession = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
                String scope = aslSession.getScope();
                this.companyId = (int)GCubeSiteManagerImpl.getCompany().getCompanyId();
                long groupId = gm.getGroupIdFromInfrastructureScope(scope);
                fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)idTmpFolder, (String)image2Delete.substring(0, image2Delete.lastIndexOf(".")));
                DLAppLocalServiceUtil.deleteFileEntry((long)fileEntry.getFileEntryId());
            }
            catch (PortalException | SystemException | IllegalArgumentException | GroupRetrievalFault | UserManagementSystemException e) {
                e.printStackTrace();
            }
            finally {
                con.getEntityManager().close();
                emf.close();
                con = null;
                emf = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSurveyQuestion(SurveyQuestionModel surveyQuestionModel, int idSurvey) {
        Surveyquestion surveyQuestion = new Surveyquestion();
        Survey survey = new Survey();
        survey.setId(Integer.valueOf(idSurvey));
        surveyQuestion.setIdSurvey(survey);
        surveyQuestion.setNumberquestion(surveyQuestionModel.getNumberquestion());
        surveyQuestion.setIsmandatory(surveyQuestionModel.getIsmandatory());
        surveyQuestion.setQuestiontype(surveyQuestionModel.getQuestiontype());
        surveyQuestion.setQuestion(surveyQuestionModel.getQuestion());
        surveyQuestion.setAnswer1(surveyQuestionModel.getAnswer1());
        surveyQuestion.setAnswer2(surveyQuestionModel.getAnswer2());
        surveyQuestion.setAnswer3(surveyQuestionModel.getAnswer3());
        surveyQuestion.setAnswer4(surveyQuestionModel.getAnswer4());
        surveyQuestion.setAnswer5(surveyQuestionModel.getAnswer5());
        surveyQuestion.setAnswer6(surveyQuestionModel.getAnswer6());
        surveyQuestion.setAnswer7(surveyQuestionModel.getAnswer7());
        surveyQuestion.setAnswer8(surveyQuestionModel.getAnswer8());
        surveyQuestion.setAnswer9(surveyQuestionModel.getAnswer9());
        surveyQuestion.setAnswer10(surveyQuestionModel.getAnswer10());
        surveyQuestion.setDateanswer(surveyQuestionModel.getDateAnswer());
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyquestionJpaController con = new SurveyquestionJpaController(emf);
        try {
            con.create(surveyQuestion);
            con.getEntityManager().getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con.getEntityManager().close();
            emf.close();
            con = null;
            emf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSurvey(SurveyModel surveyModel) {
        Survey survey = new Survey();
        survey.setTitlesurvey(surveyModel.getTitlesurvey());
        survey.setIdusercreator(surveyModel.getIdUserCreator().intValue());
        survey.setDatesurvay(surveyModel.getDateSurvay());
        survey.setExpiredDatesurvay(surveyModel.getExpiredDateSurvay());
        survey.setIsanonymous(surveyModel.getIsAnonymous());
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyJpaController con = new SurveyJpaController(emf);
        try {
            con.create(survey);
            con.getEntityManager().getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con.getEntityManager().close();
            emf.close();
            con = null;
            emf = null;
        }
    }

    public List<UserDTO> getUserAnsweredSurvey(int idSurveySelected) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyJpaController surveyJpaController = new SurveyJpaController(emf);
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        LiferayGroupManager gm = new LiferayGroupManager();
        String currentUsername = this.getThreadLocalRequest().getSession().getAttribute("username").toString();
        String scope = SessionManager.getInstance().getASLSession(this.getThreadLocalRequest().getSession().getId(), currentUsername).getScope();
        long currGroupId = 0L;
        boolean isAnonymousSurvey = false;
        isAnonymousSurvey = surveyJpaController.checkSurveyIsAnonymous(idSurveySelected);
        InvitationtokenJpaController con = new InvitationtokenJpaController(emf);
        List idUserAnsweredList = new ArrayList();
        idUserAnsweredList = con.getListUserAnsweredSurvey(idSurveySelected);
        User currentUser = null;
        UserDTO userDTO = null;
        ArrayList<UserDTO> userDTOList = new ArrayList<UserDTO>();
        for (int i = 0; i < idUserAnsweredList.size(); ++i) {
            try {
                currGroupId = gm.getGroupIdFromInfrastructureScope(scope);
                userDTO = new UserDTO();
                if (isAnonymousSurvey) {
                    userDTO.setUserId((long)((Integer)idUserAnsweredList.get(i)).intValue());
                    userDTO.setFullName("Guest");
                } else {
                    currentUser = UserLocalServiceUtil.getUserById((long)((Integer)idUserAnsweredList.get(i)).intValue());
                    userDTO.setUserId(currentUser.getUserId());
                    userDTO.setFullName(currentUser.getFullName());
                }
                userDTO.setContactId((long)((int)this.userLiferay.getContactId()));
                userDTO.setGroupId(currGroupId);
                userDTO.setEmailAddress(this.userLiferay.getEmailAddress());
                userDTO.setScreenName(this.userLiferay.getScreenName());
                userDTO.setRolesId(this.userLiferay.getRoleIds());
                userDTOList.add(userDTO);
                continue;
            }
            catch (PortalException | SystemException | IllegalArgumentException | GroupRetrievalFault | UserManagementSystemException e) {
                e.printStackTrace();
                con.getEntityManager().close();
                emf.close();
                con = null;
                emf = null;
            }
        }
        con.getEntityManager().close();
        emf.close();
        con = null;
        emf = null;
        return userDTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> usersAnsweredSurvey() {
        InvitationtokenJpaController con = null;
        ArrayList<Integer> idUserAnsweredList = null;
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        try {
            con = new InvitationtokenJpaController(emf);
            idUserAnsweredList = new ArrayList();
            idUserAnsweredList = con.getUserAnsweredSurveyCount();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con.getEntityManager().close();
            emf.close();
            con = null;
            emf = null;
        }
        return idUserAnsweredList;
    }

    public UserDTO getUser() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UserDTO userDTO = new UserDTO();
        LiferayGroupManager gm = new LiferayGroupManager();
        String currentUsername = this.getThreadLocalRequest().getSession().getAttribute("username").toString();
        String scope = SessionManager.getInstance().getASLSession(this.getThreadLocalRequest().getSession().getId(), currentUsername).getScope();
        long currGroupId = 0L;
        try {
            int i;
            currGroupId = gm.getGroupIdFromInfrastructureScope(scope);
            String username = null;
            this.companyId = (int)GCubeSiteManagerImpl.getCompany().getCompanyId();
            if (httpSession != null && httpSession.getAttribute("username") == null) {
                userDTO.setUserId(0L);
                userDTO.setContactId(0L);
                userDTO.setGroupId(currGroupId);
                userDTO.setEmailAddress(null);
                userDTO.setFullName("Anonymous");
                userDTO.setScreenName("Anonymous");
            } else {
                username = httpSession.getAttribute("username").toString();
                this.userLiferay = UserLocalServiceUtil.getUserByScreenName((long)this.companyId, (String)username);
                userDTO.setUserId((long)((int)this.userLiferay.getUserId()));
                userDTO.setContactId((long)((int)this.userLiferay.getContactId()));
                userDTO.setGroupId(currGroupId);
                userDTO.setEmailAddress(this.userLiferay.getEmailAddress());
                userDTO.setFullName(this.userLiferay.getFullName());
                userDTO.setScreenName(this.userLiferay.getScreenName());
                userDTO.setRolesId(this.userLiferay.getRoleIds());
            }
            LiferayRoleManager roleManager = new LiferayRoleManager();
            ArrayList<GCubeRole> roles = new ArrayList<GCubeRole>();
            for (i = 0; i < this.userLiferay.getRoleIds().length; ++i) {
                try {
                    roles.add(roleManager.getRole(this.userLiferay.getRoleIds()[i]));
                    continue;
                }
                catch (RoleRetrievalFault | UserManagementSystemException e) {
                    e.printStackTrace();
                }
            }
            if (roleManager.isAdmin(userDTO.getUserId())) {
                userDTO.setAdminUser(Boolean.TRUE.booleanValue());
            }
            if (this.isCurrentUserVREManager()) {
                userDTO.setVreManager(Boolean.TRUE.booleanValue());
            }
            for (i = 0; i < roles.size(); ++i) {
                if (((GCubeRole)roles.get(i)).getRoleName() != VRE_MANAGER_LABEL && ((GCubeRole)roles.get(i)).getRoleName() != INFRA_MANAGER_LABEL && ((GCubeRole)roles.get(i)).getRoleName() != DATA_MANAGER_LABEL && ((GCubeRole)roles.get(i)).getRoleName() != "VRE-Designer" && ((GCubeRole)roles.get(i)).getRoleName() != "VRE-Designer") continue;
                userDTO.setManageSurveyUser(Boolean.TRUE.booleanValue());
            }
        }
        catch (PortalException | SystemException | IllegalArgumentException | GroupRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
            e.printStackTrace();
        }
        return userDTO;
    }

    private boolean isCurrentUserVREManager() {
        LiferayGroupManager gm = new LiferayGroupManager();
        String currentUsername = this.getThreadLocalRequest().getSession().getAttribute("username").toString();
        String scope = SessionManager.getInstance().getASLSession(this.getThreadLocalRequest().getSession().getId(), currentUsername).getScope();
        long currGroupId = 0L;
        try {
            currGroupId = gm.getGroupIdFromInfrastructureScope(scope);
        }
        catch (IllegalArgumentException | GroupRetrievalFault | UserManagementSystemException e) {
            e.printStackTrace();
        }
        try {
            Map usersAndRolesInVRE = new LiferayUserManager().listUsersAndRolesByGroup(currGroupId);
            for (GCubeUser gCubeUser : usersAndRolesInVRE.keySet()) {
                if (gCubeUser.getUsername().compareTo(currentUsername) != 0) continue;
                for (GCubeRole gCubeRole : (List)usersAndRolesInVRE.get(gCubeUser)) {
                    if (gCubeRole.getRoleName().compareTo(GatewayRolesNames.VRE_MANAGER.getRoleName()) != 0) continue;
                    return true;
                }
            }
        }
        catch (GroupRetrievalFault | UserManagementSystemException | UserRetrievalFault e1) {
            e1.printStackTrace();
        }
        return false;
    }

    public SurveyModel getSurvey(int idSurvey) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyJpaController surveyJpaController = new SurveyJpaController(emf);
        Survey survey = surveyJpaController.findSurvey(Integer.valueOf(idSurvey));
        this.surveyModel = new SurveyModel();
        this.surveyModel.setIdsurvey(survey.getId());
        this.surveyModel.setTitlesurvey(survey.getTitlesurvey());
        this.surveyModel.setIdUserCreator(Integer.valueOf(survey.getIdusercreator()));
        this.surveyModel.setGroupId(Long.valueOf(survey.getGroupid()));
        this.surveyModel.setDateSurvay(survey.getDatesurvay());
        this.surveyModel.setExpiredDateSurvay(survey.getExpireddatesurvay());
        this.surveyModel.setIsAnonymous(survey.getIsanonymous());
        surveyJpaController.getEntityManager().close();
        emf.close();
        surveyJpaController = null;
        emf = null;
        return this.surveyModel;
    }

    public List<SurveyModel> getSurveyList(UserDTO userDTO) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyJpaController surveyJpaController = new SurveyJpaController(emf);
        List surveyList = new ArrayList();
        surveyList = userDTO.isAdminUser() || userDTO.isVreManager() ? surveyJpaController.findAllSurveys(userDTO.getGroupId()) : surveyJpaController.findSurveysByUser((int)userDTO.getUserId(), userDTO.getGroupId());
        this.surveyModel = new SurveyModel();
        this.surveyModelList = new ArrayList();
        for (int i = 0; i < surveyList.size(); ++i) {
            this.surveyModel.setIdsurvey(((Survey)surveyList.get(i)).getId());
            this.surveyModel.setTitlesurvey(((Survey)surveyList.get(i)).getTitlesurvey());
            this.surveyModel.setIdUserCreator(Integer.valueOf(((Survey)surveyList.get(i)).getIdusercreator()));
            this.surveyModel.setGroupId(Long.valueOf(((Survey)surveyList.get(i)).getGroupid()));
            this.surveyModel.setDateSurvay(((Survey)surveyList.get(i)).getDatesurvay());
            this.surveyModel.setExpiredDateSurvay(((Survey)surveyList.get(i)).getExpireddatesurvay());
            this.surveyModel.setIsAnonymous(((Survey)surveyList.get(i)).getIsanonymous());
            this.surveyModel.setCreatorFullname(this.getCreatorSurveyName(((Survey)surveyList.get(i)).getIdusercreator()));
            this.surveyModelList.add(this.surveyModel);
            this.surveyModel = new SurveyModel();
        }
        surveyJpaController.getEntityManager().close();
        emf.close();
        surveyJpaController = null;
        emf = null;
        return this.surveyModelList;
    }

    private String getCreatorSurveyName(int idusercreator) {
        String fullnameSurveyCreator = null;
        try {
            this.userLiferay = UserLocalServiceUtil.getUserById((long)idusercreator);
            fullnameSurveyCreator = this.userLiferay.getFullName();
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
        }
        return fullnameSurveyCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSurvey(SurveyModel surveyModel) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyquestionJpaController surveyquestionJpaController = new SurveyquestionJpaController(emf);
        SurveyuseranswerJpaController surveyuseranswerJpaController = new SurveyuseranswerJpaController(emf);
        ChoicequestionJpaController choicequestionJpaController = new ChoicequestionJpaController(emf);
        ChoiceanswerJpaController choiceanswerJpaController = new ChoiceanswerJpaController(emf);
        SurveyJpaController surveyJpaController = new SurveyJpaController(emf);
        InvitationtokenJpaController invitationtokenJpaController = new InvitationtokenJpaController(emf);
        GridquestionJpaController gridquestionJpaController = new GridquestionJpaController(emf);
        GridanswerJpaController gridanswerJpaController = new GridanswerJpaController(emf);
        long folderId = surveyquestionJpaController.findFolderIdByIdSurvey(surveyModel.getIdsurvey().intValue());
        try {
            DLAppLocalServiceUtil.deleteFolder((long)folderId);
            choicequestionJpaController.deleteQuestions(surveyModel.getIdsurvey().intValue());
            surveyquestionJpaController.deleteQuestions(surveyModel.getIdsurvey().intValue());
            choiceanswerJpaController.deleteQuestions(surveyModel.getIdsurvey().intValue());
            surveyuseranswerJpaController.deleteQuestions(surveyModel.getIdsurvey().intValue());
            surveyJpaController.destroy(surveyModel.getIdsurvey());
            invitationtokenJpaController.destroy(surveyModel.getIdsurvey());
            gridquestionJpaController.deleteQuestions(surveyModel.getIdsurvey().intValue());
            gridanswerJpaController.deleteQuestions(surveyModel.getIdsurvey().intValue());
        }
        catch (PortalException | SystemException | IllegalOrphanException | NonexistentEntityException e) {
            e.printStackTrace();
        }
        finally {
            choicequestionJpaController.getEntityManager().close();
            surveyquestionJpaController.getEntityManager().close();
            choiceanswerJpaController.getEntityManager().close();
            surveyuseranswerJpaController.getEntityManager().close();
            surveyJpaController.getEntityManager().close();
            invitationtokenJpaController.getEntityManager().close();
            gridquestionJpaController.getEntityManager().close();
            gridanswerJpaController.getEntityManager().close();
            emf.close();
            choicequestionJpaController = null;
            surveyquestionJpaController = null;
            choiceanswerJpaController = null;
            surveyuseranswerJpaController = null;
            surveyJpaController = null;
            invitationtokenJpaController = null;
            gridquestionJpaController = null;
            gridanswerJpaController = null;
            emf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSurvey(long idUser, SurveyModel surveyModel, List<SurveyQuestionModel> surveyQuestionModelList) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        try {
            SurveyquestionJpaController surveyquestionJpaController = new SurveyquestionJpaController(emf);
            surveyquestionJpaController.deleteQuestions(surveyModel.getIdsurvey().intValue());
            surveyquestionJpaController.getEntityManager().close();
            if (surveyModel.getExpiredDateSurvay() != null) {
                this.localDate = this.setDate2LocalTimezone(surveyModel.getExpiredDateSurvay());
                surveyModel.setExpiredDateSurvay(this.localDate);
            }
            SurveyJpaController surveyJpaController = new SurveyJpaController(emf);
            try {
                surveyJpaController.updateSurvey(surveyModel);
            }
            catch (Exception e) {
                e.printStackTrace();
                emf.close();
            }
            finally {
                surveyJpaController.getEntityManager().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SurveyquestionJpaController con1 = new SurveyquestionJpaController(emf);
        ChoicequestionJpaController conChoice = new ChoicequestionJpaController(emf);
        conChoice.deleteQuestions(surveyModel.getIdsurvey().intValue());
        GridquestionJpaController gridquestionJpaController = new GridquestionJpaController(emf);
        gridquestionJpaController.deleteQuestions(surveyModel.getIdsurvey().intValue());
        Surveyquestion surveyQuestion = null;
        Survey survey = new Survey(surveyModel.getIdsurvey());
        try {
            for (int i = 0; i < surveyQuestionModelList.size(); ++i) {
                surveyQuestion = new Surveyquestion();
                surveyQuestion.setIdSurvey(survey);
                surveyQuestion.setNumberquestion(surveyQuestionModelList.get(i).getNumberquestion());
                surveyQuestion.setIsmandatory(surveyQuestionModelList.get(i).getIsmandatory());
                surveyQuestion.setQuestiontype(surveyQuestionModelList.get(i).getQuestiontype());
                surveyQuestion.setQuestion(surveyQuestionModelList.get(i).getQuestion());
                surveyQuestion.setImagefilename(surveyQuestionModelList.get(i).getImageFileName());
                surveyQuestion.setFolderidimage(surveyQuestionModelList.get(i).getFolderIdImage());
                surveyQuestion.setAnswer1(surveyQuestionModelList.get(i).getAnswer1());
                surveyQuestion.setAnswer2(surveyQuestionModelList.get(i).getAnswer2());
                surveyQuestion.setAnswer3(surveyQuestionModelList.get(i).getAnswer3());
                surveyQuestion.setAnswer4(surveyQuestionModelList.get(i).getAnswer4());
                surveyQuestion.setAnswer5(surveyQuestionModelList.get(i).getAnswer5());
                surveyQuestion.setAnswer6(surveyQuestionModelList.get(i).getAnswer6());
                surveyQuestion.setAnswer7(surveyQuestionModelList.get(i).getAnswer7());
                surveyQuestion.setAnswer8(surveyQuestionModelList.get(i).getAnswer8());
                surveyQuestion.setAnswer9(surveyQuestionModelList.get(i).getAnswer9());
                surveyQuestion.setAnswer10(surveyQuestionModelList.get(i).getAnswer10());
                surveyQuestion.setSectiontitle(surveyQuestionModelList.get(i).getSectionTitle());
                surveyQuestion.setSectiondescription(surveyQuestionModelList.get(i).getSectionDescription());
                if (surveyQuestionModelList.get(i).getDateAnswer() != null) {
                    this.localDate = this.setDate2LocalTimezone(surveyQuestionModelList.get(i).getDateAnswer());
                    surveyQuestion.setDateanswer(this.localDate);
                }
                con1.create(surveyQuestion);
                if (surveyQuestionModelList.get(i).getQuestiontype().contains("Multiple Choice") || surveyQuestionModelList.get(i).getQuestiontype().contains("CheckBoxes") || surveyQuestionModelList.get(i).getQuestiontype().contains("Drop-Down")) {
                    conChoice.insertMultipleChoice(survey, surveyQuestionModelList.get(i));
                }
                if (!surveyQuestionModelList.get(i).getQuestiontype().contains("Grid")) continue;
                gridquestionJpaController.insertRowColumn(survey, surveyQuestionModelList.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con1.getEntityManager().close();
            conChoice.getEntityManager().close();
            gridquestionJpaController.getEntityManager().close();
            emf.close();
            con1 = null;
            conChoice = null;
            gridquestionJpaController = null;
            emf = null;
        }
    }

    public List<SurveyQuestionModel> getQuestionsSurvey(int idSurvey) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyquestionJpaController surveyQuestionJpaController = new SurveyquestionJpaController(emf);
        List surveyQuestionList = surveyQuestionJpaController.findSurveyQuestionByIdSurvey(idSurvey);
        ChoicequestionJpaController choicequestionJpaController = new ChoicequestionJpaController(emf);
        GridquestionJpaController gridquestionJpaController = new GridquestionJpaController(emf);
        this.surveyQuestionModelList = new ArrayList();
        for (int i = 0; i < surveyQuestionList.size(); ++i) {
            this.surveyQuestionModel = new SurveyQuestionModel();
            this.surveyQuestionModel.setIdsurvey(Integer.valueOf(idSurvey));
            this.surveyQuestionModel.setNumberquestion(((Surveyquestion)surveyQuestionList.get(i)).getNumberquestion());
            this.surveyQuestionModel.setIsmandatory(((Surveyquestion)surveyQuestionList.get(i)).getIsmandatory());
            this.surveyQuestionModel.setQuestiontype(((Surveyquestion)surveyQuestionList.get(i)).getQuestiontype());
            this.surveyQuestionModel.setQuestion(((Surveyquestion)surveyQuestionList.get(i)).getQuestion());
            this.surveyQuestionModel.setImageFileName(((Surveyquestion)surveyQuestionList.get(i)).getImagefilename());
            this.surveyQuestionModel.setFolderIdImage(((Surveyquestion)surveyQuestionList.get(i)).getFolderidimage());
            this.surveyQuestionModel.setAnswer1(((Surveyquestion)surveyQuestionList.get(i)).getAnswer1());
            this.surveyQuestionModel.setAnswer2(((Surveyquestion)surveyQuestionList.get(i)).getAnswer2());
            this.surveyQuestionModel.setAnswer3(((Surveyquestion)surveyQuestionList.get(i)).getAnswer3());
            this.surveyQuestionModel.setAnswer4(((Surveyquestion)surveyQuestionList.get(i)).getAnswer4());
            this.surveyQuestionModel.setAnswer5(((Surveyquestion)surveyQuestionList.get(i)).getAnswer5());
            this.surveyQuestionModel.setAnswer6(((Surveyquestion)surveyQuestionList.get(i)).getAnswer6());
            this.surveyQuestionModel.setAnswer7(((Surveyquestion)surveyQuestionList.get(i)).getAnswer7());
            this.surveyQuestionModel.setAnswer8(((Surveyquestion)surveyQuestionList.get(i)).getAnswer8());
            this.surveyQuestionModel.setAnswer9(((Surveyquestion)surveyQuestionList.get(i)).getAnswer9());
            this.surveyQuestionModel.setAnswer10(((Surveyquestion)surveyQuestionList.get(i)).getAnswer10());
            this.surveyQuestionModel.setDateAnswer(((Surveyquestion)surveyQuestionList.get(i)).getDateanswer());
            this.surveyQuestionModel.setSectionTitle(((Surveyquestion)surveyQuestionList.get(i)).getSectiontitle());
            this.surveyQuestionModel.setSectionDescription(((Surveyquestion)surveyQuestionList.get(i)).getSectiondescription());
            if (((Surveyquestion)surveyQuestionList.get(i)).getQuestiontype().contains("Multiple Choice") || ((Surveyquestion)surveyQuestionList.get(i)).getQuestiontype().contains("CheckBoxes") || ((Surveyquestion)surveyQuestionList.get(i)).getQuestiontype().contains("Drop-Down")) {
                this.choiceQuestionList = choicequestionJpaController.findSurveyQuestionChoiceByIdSurveyAndNumberQuestion(idSurvey, ((Surveyquestion)surveyQuestionList.get(i)).getNumberquestion());
                this.surveyQuestionModel.setMultipleChoiceList(this.choiceQuestionList);
            }
            if (((Surveyquestion)surveyQuestionList.get(i)).getQuestiontype().contains("Grid")) {
                this.rowGridList = gridquestionJpaController.findSurveyQuestionRowColumnGridByIdSurveyAndNumberQuestion(idSurvey, ((Surveyquestion)surveyQuestionList.get(i)).getNumberquestion(), ROW_LABEL);
                this.columnGridList = gridquestionJpaController.findSurveyQuestionRowColumnGridByIdSurveyAndNumberQuestion(idSurvey, ((Surveyquestion)surveyQuestionList.get(i)).getNumberquestion(), COLUMN_LABEL);
                if (this.rowGridList != null && !this.rowGridList.isEmpty() && this.columnGridList != null && !this.columnGridList.isEmpty()) {
                    this.surveyQuestionModel.setRowGridList(this.rowGridList);
                    this.surveyQuestionModel.setColumnGridList(this.columnGridList);
                }
            }
            this.surveyQuestionModelList.add(this.surveyQuestionModel);
        }
        surveyQuestionJpaController.getEntityManager().close();
        choicequestionJpaController.getEntityManager().close();
        gridquestionJpaController.getEntityManager().close();
        emf.close();
        surveyQuestionJpaController = null;
        choicequestionJpaController = null;
        gridquestionJpaController = null;
        emf = null;
        return this.surveyQuestionModelList;
    }

    public List<SurveyUserAnswerModel> getAnswersSurvey(int idSurvey) {
        Survey survey = new Survey();
        survey.setId(Integer.valueOf(idSurvey));
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"SurveyLibManager", (Map)this.persistenceMap);
        SurveyuseranswerJpaController surveyUserAnswerJpaController = new SurveyuseranswerJpaController(emf);
        List surveyUserAnswerList = surveyUserAnswerJpaController.findAnswersSurveyById(idSurvey);
        SurveyquestionJpaController surveyQuestionJpaController = new SurveyquestionJpaController(emf);
        ChoiceanswerJpaController conChoiceAns = new ChoiceanswerJpaController(emf);
        GridanswerJpaController gridanswerJpaController = new GridanswerJpaController(emf);
        List surveyQuestionList = surveyQuestionJpaController.findSurveyQuestionByIdSurvey(idSurvey);
        SurveyUserAnswerModel surveyUserAnswerModel = new SurveyUserAnswerModel();
        ArrayList<SurveyUserAnswerModel> surveyUserAnswerModelList = new ArrayList<SurveyUserAnswerModel>();
        for (int i = 0; i < surveyUserAnswerList.size(); ++i) {
            surveyUserAnswerModel.setIduseranswer(Integer.valueOf(((Surveyuseranswer)surveyUserAnswerList.get(i)).getIduseranswer()));
            surveyUserAnswerModel.setIdsurvey(Integer.valueOf(idSurvey));
            surveyUserAnswerModel.setQuestiontype(((Surveyuseranswer)surveyUserAnswerList.get(i)).getQuestiontype());
            surveyUserAnswerModel.setNumberquestion(((Surveyuseranswer)surveyUserAnswerList.get(i)).getNumberquestion().intValue());
            surveyUserAnswerModel.setAnswer1(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer1());
            surveyUserAnswerModel.setAnswer2(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer2());
            surveyUserAnswerModel.setAnswer3(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer3());
            surveyUserAnswerModel.setAnswer4(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer4());
            surveyUserAnswerModel.setAnswer5(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer5());
            surveyUserAnswerModel.setAnswer6(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer6());
            surveyUserAnswerModel.setAnswer7(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer7());
            surveyUserAnswerModel.setAnswer8(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer8());
            surveyUserAnswerModel.setAnswer9(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer9());
            surveyUserAnswerModel.setAnswer10(((Surveyuseranswer)surveyUserAnswerList.get(i)).getAnswer10());
            surveyUserAnswerModel.setDateAnswer(((Surveyuseranswer)surveyUserAnswerList.get(i)).getDateanswer());
            for (int j = 0; j < surveyQuestionList.size(); ++j) {
                if (((Surveyuseranswer)surveyUserAnswerList.get(i)).getNumberquestion().intValue() != ((Surveyquestion)surveyQuestionList.get(j)).getNumberquestion()) continue;
                surveyUserAnswerModel.setQuestion(((Surveyquestion)surveyQuestionList.get(j)).getQuestion());
            }
            if (((Surveyuseranswer)surveyUserAnswerList.get(i)).getQuestiontype() != null) {
                if (((Surveyuseranswer)surveyUserAnswerList.get(i)).getQuestiontype().contains("CheckBoxes")) {
                    this.choiceAnswerList = conChoiceAns.findSurveyChoiceAnswerByIdSurveyAndNumberQuestion(idSurvey, ((Surveyuseranswer)surveyUserAnswerList.get(i)).getIduseranswer(), ((Surveyuseranswer)surveyUserAnswerList.get(i)).getNumberquestion().intValue());
                    surveyUserAnswerModel.setMultipleChoiceList(this.choiceAnswerList);
                }
                if (((Surveyuseranswer)surveyUserAnswerList.get(i)).getQuestiontype().contains("Grid")) {
                    this.gridAnswerList = gridanswerJpaController.findGridAnswersByIdSurveyAndNumberQuestion(idSurvey, ((Surveyuseranswer)surveyUserAnswerList.get(i)).getIduseranswer(), ((Surveyuseranswer)surveyUserAnswerList.get(i)).getNumberquestion().intValue());
                    surveyUserAnswerModel.setGridAnswerList(this.gridAnswerList);
                }
            }
            surveyUserAnswerModelList.add(surveyUserAnswerModel);
            surveyUserAnswerModel = new SurveyUserAnswerModel();
        }
        conChoiceAns.getEntityManager().close();
        gridanswerJpaController.getEntityManager().close();
        surveyQuestionJpaController.getEntityManager().close();
        surveyUserAnswerJpaController.getEntityManager().close();
        emf.close();
        conChoiceAns = null;
        gridanswerJpaController = null;
        surveyQuestionJpaController = null;
        surveyUserAnswerJpaController = null;
        emf = null;
        return surveyUserAnswerModelList;
    }

    public void checkDBisCreated() {
    }

    private Date StringToDate(String answer10) {
        Date dateConverted = null;
        if (answer10 != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                dateConverted = dateFormat.parse(answer10);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return dateConverted;
    }

    private String dateToString(Date surveyDate) {
        String dateConverted = null;
        if (surveyDate != null) {
            surveyDate = this.setDate2LocalTimezone(surveyDate);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            dateConverted = dateFormat.format(surveyDate);
        }
        return dateConverted;
    }

    private Date setDate2LocalTimezone(Date surveyDate) {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"));
        now.setTime(surveyDate);
        now.set(11, 6);
        return now.getTime();
    }

    public void exportToCSVFile(String titleSurvey, boolean isAnonymous, List<UserDTO> userDTOList, List<SurveyUserAnswerModel> surveyUserAnswerModelList, List<SurveyQuestionModel> surveyQuestionModelList) {
        String realPath = this.getThreadLocalRequest().getSession().getServletContext().getRealPath("/");
        File theDir = new File(realPath + "/SurveyStatistics");
        if (!theDir.exists()) {
            boolean result = false;
            try {
                theDir.mkdir();
                result = true;
            }
            catch (SecurityException se) {
                se.printStackTrace();
            }
        }
        String csvFileName = "/SurveyStatistics.csv";
        String csvFile = theDir.getPath() + csvFileName;
        String user = null;
        try {
            File csvFileToExport = new File(csvFile);
            csvFileToExport.createNewFile();
            FileWriter writer = new FileWriter(csvFileToExport);
            CSVUtils.writeLine((Writer)writer, Arrays.asList("Title", "User", "Question", "Answers"));
            int gridrowIndex = 0;
            for (int i = 0; i < surveyUserAnswerModelList.size(); ++i) {
                int j;
                for (int j2 = 0; j2 < userDTOList.size(); ++j2) {
                    if (userDTOList.get(j2).getUserId() != (long)surveyUserAnswerModelList.get(i).getIduseranswer().intValue()) continue;
                    user = isAnonymous ? "Guest" : userDTOList.get(j2).getFullName();
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(titleSurvey);
                list.add(user);
                if (surveyUserAnswerModelList.get(i).getQuestion() == null) {
                    return;
                }
                list.add(surveyUserAnswerModelList.get(i).getQuestion());
                if (surveyUserAnswerModelList.get(i).getQuestiontype().equalsIgnoreCase("Time")) {
                    list.add(surveyUserAnswerModelList.get(i).getAnswer1() + ":" + surveyUserAnswerModelList.get(i).getAnswer2());
                } else if (surveyUserAnswerModelList.get(i).getQuestiontype().equalsIgnoreCase("Date")) {
                    list.add(this.dateToString(surveyUserAnswerModelList.get(i).getDateAnswer()));
                } else if (surveyUserAnswerModelList.get(i).getQuestiontype().equalsIgnoreCase("Multiple Choice")) {
                    if (surveyUserAnswerModelList.get(i).getAnswer1() != null && surveyUserAnswerModelList.get(i).getAnswer1().contains("Other...")) {
                        list.add(surveyUserAnswerModelList.get(i).getAnswer1() + ": " + surveyUserAnswerModelList.get(i).getAnswer2());
                    } else if (surveyUserAnswerModelList.get(i).getAnswer1() != null) {
                        list.add(surveyUserAnswerModelList.get(i).getAnswer1());
                    }
                } else if (surveyUserAnswerModelList.get(i).getQuestiontype().equalsIgnoreCase("CheckBoxes")) {
                    for (j = 0; j < surveyUserAnswerModelList.get(i).getMultipleChoiceList().size(); ++j) {
                        if (((String)surveyUserAnswerModelList.get(i).getMultipleChoiceList().get(j)).equalsIgnoreCase("Other...")) {
                            list.add((String)surveyUserAnswerModelList.get(i).getMultipleChoiceList().get(j) + ": " + surveyUserAnswerModelList.get(i).getAnswer1());
                            continue;
                        }
                        if (surveyUserAnswerModelList.get(i).getMultipleChoiceList().get(j) == null) continue;
                        list.add((String)surveyUserAnswerModelList.get(i).getMultipleChoiceList().get(j));
                    }
                } else if (surveyUserAnswerModelList.get(i).getQuestiontype().equalsIgnoreCase("Grid")) {
                    for (j = 0; j < surveyQuestionModelList.size(); ++j) {
                        if (surveyQuestionModelList.get(j).getRowGridList() == null || surveyUserAnswerModelList.get(i).getGridAnswerList() == null || surveyQuestionModelList.get(j).getNumberquestion() != surveyUserAnswerModelList.get(i).getNumberquestion()) continue;
                        for (int k = 0; k < surveyQuestionModelList.get(j).getRowGridList().size(); ++k) {
                            list.clear();
                            list.add(titleSurvey);
                            list.add(user);
                            list.add(surveyUserAnswerModelList.get(i).getQuestion());
                            list.add((String)surveyQuestionModelList.get(j).getRowGridList().get(k));
                            list.add((String)surveyUserAnswerModelList.get(i).getGridAnswerList().get(k));
                            CSVUtils.writeLine((Writer)writer, list);
                            list.clear();
                        }
                        ++gridrowIndex;
                    }
                } else if (surveyUserAnswerModelList.get(i).getAnswer1() != null) {
                    list.add(surveyUserAnswerModelList.get(i).getAnswer1());
                }
                if (list == null || list.isEmpty()) continue;
                CSVUtils.writeLine((Writer)writer, list);
            }
            writer.flush();
            writer.close();
            writer = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDBPropertyConnection() {
        try {
            String pwd;
            String dbUser;
            String dbName;
            String dbAddress;
            ServiceEndpoint.AccessPoint ac = this.getSurveyDBAccessPoint();
            System.out.println("Got AccessPoint:" + ac.toString());
            this.DBURL = dbAddress = ac.address();
            System.out.println("DB address: " + dbAddress);
            this.DBName = dbName = ac.name();
            System.out.println("DB name: " + dbName);
            this.uName = dbUser = ac.username();
            System.out.println("DB user: " + dbUser);
            this.jdbcURL = new StringBuffer("jdbc:postgresql://").append(dbAddress).append("/").append(dbName).toString();
            System.out.println("jdbc.url: " + this.jdbcURL);
            String currContext = ScopeProvider.instance.get();
            ScopeProvider.instance.set("/" + PortalContext.getConfiguration().getInfrastructureName());
            this.pwd = pwd = StringEncrypter.getEncrypter().decrypt(ac.password(), new Key[0]);
            System.out.println("Decrypted Password: *******");
            ScopeProvider.instance.set(currContext);
            this.persistenceMap = new HashMap();
            this.persistenceMap.put("javax.persistence.jdbc.url", this.jdbcURL);
            this.persistenceMap.put("javax.persistence.jdbc.user", dbUser);
            this.persistenceMap.put("javax.persistence.jdbc.password", pwd);
            this.persistenceMap.put("javax.persistence.jdbc.driver", "org.postgresql.Driver");
            this.persistenceMap.put("hibernate.show_sql", "false");
            this.persistenceMap.put("hibernate.format_sql", "true");
            this.persistenceMap.put("hibernate.dialect", "org.hibernate.dialect.PostgreSQLDialect");
            this.persistenceMap.put("hibernate.hbm2ddl.auto", "validate");
            CreateDB createDB = null;
            try {
                createDB = new CreateDB(this.jdbcURL, this.DBName, this.uName, pwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ServiceEndpoint.AccessPoint getSurveyDBAccessPoint() {
        String currContext = ScopeProvider.instance.get();
        ScopeProvider.instance.set("/" + PortalContext.getConfiguration().getInfrastructureName());
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + RUNTIME_RESOURCE_NAME + "'");
        query.addCondition("$resource/Profile/Category/text() eq '" + CATEGORY_NAME + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List conf = client.submit((Query)query);
        ServiceEndpoint res = (ServiceEndpoint)conf.get(0);
        ScopeProvider.instance.set(currContext);
        return (ServiceEndpoint.AccessPoint)res.profile().accessPoints().iterator().next();
    }

    public SurveyQuestionModel getSurveyQuestionModelTemp() {
        return this.surveyQuestionModelTemp;
    }

    public void setSurveyQuestionModelTemp(SurveyQuestionModel surveyQuestionModelTemp) {
        this.surveyQuestionModelTemp = surveyQuestionModelTemp;
    }

    public long getFolderID() {
        return this.folderID;
    }

    public void setFolderID(long folderID) {
        this.folderID = folderID;
    }

    public Folder getDlFolder() {
        return this.dlFolder;
    }

    public void setDlFolder(Folder dlFolder) {
        this.dlFolder = dlFolder;
    }

    public GroupManager getGm() {
        return this.gm;
    }

    public void setGm(GroupManager gm) {
        this.gm = gm;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ASLSession getAslSession() {
        return this.aslSession;
    }

    public void setAslSession(ASLSession aslSession) {
        this.aslSession = aslSession;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(int companyId) {
        this.companyId = companyId;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public Map<String, String> getPersistenceMap() {
        return this.persistenceMap;
    }

    public void setPersistenceMap(Map<String, String> persistenceMap) {
        this.persistenceMap = persistenceMap;
    }

    public EntityManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    public void setManagerFactory(EntityManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public String getDBURL() {
        return this.DBURL;
    }

    public void setDBURL(String dBURL) {
        this.DBURL = dBURL;
    }

    public String getDBName() {
        return this.DBName;
    }

    public void setDBName(String dBName) {
        this.DBName = dBName;
    }

    public String getuName() {
        return this.uName;
    }

    public void setuName(String uName) {
        this.uName = uName;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public static String getCATEGORY_NAME() {
        return CATEGORY_NAME;
    }

    public static void setCATEGORY_NAME(String cATEGORY_NAME) {
        CATEGORY_NAME = cATEGORY_NAME;
    }
}

