package it.eng.edison.messages.client;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import it.eng.edison.messages.server.model.ChatMessages;
import it.eng.edison.messages.server.model.UsersChat;

import java.util.List;


@RemoteServiceRelativePath("message")
public interface MessagesService extends RemoteService {


    int addUserToList(UsersChat user)  throws IllegalArgumentException;

    void removeUserFromList(int index)  throws IllegalArgumentException ;

    List<UsersChat>  getUsersFromList() throws IllegalArgumentException ;

    List<UsersChat> userList() throws IllegalArgumentException ;

    long createRoom(   ) throws IllegalArgumentException;

    List getRoomFromOwner(long idUser) throws IllegalArgumentException;

    List getRoomsFromGuest(long idUser) throws IllegalArgumentException;

    UsersChat getUser() throws IllegalArgumentException ;

    List<ChatMessages> getMessagesFromRoom(long idRoom) throws IllegalArgumentException;

    String sendMsg( long idRoom, String message, String uplodaFileName  ,String contentType ) throws IllegalArgumentException;

    ChatMessages getMessage(long idMessage, long idRoom) throws IllegalArgumentException;

    void deleteUserFromList(long idRoom) throws IllegalArgumentException;

    void addUserToConversation(List<UsersChat> userList, long idRoom ) throws IllegalArgumentException;

    List<ChatMessages> searchMessage ( long idRoom , String string ) throws IllegalArgumentException;



}
