package it.eng.edison.messages.client;


import com.github.gwtbootstrap.client.ui.AccordionGroup;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;
import it.eng.edison.messages.server.model.UsersChat;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by pino on 10/07/2016.
 */
public class AddUsersBox  extends DialogBox {


    private List<UsersChat> usersChatList;
    private MessagesServiceAsync messagesService;
    private HorizontalPanel horizontalPanel = new HorizontalPanel();



    public AddUsersBox(List<UsersChat> _usersChatList, MessagesServiceAsync _messagesService, final MessagesUI messagesUI ) {

        setText("Add User");
        setModal(true);
        setAnimationEnabled(true);
        setGlassEnabled(true);
        setWidth("400px");
        setHeight("300px");
        center();


        usersChatList = _usersChatList;
        messagesService = _messagesService;
        final ScrollPanel customScrollPanel = new ScrollPanel();
        customScrollPanel.setWidth("300px");
        customScrollPanel.setHeight("250px");
        customScrollPanel.setVisible(true);

        HorizontalPanel buttonPanel = new HorizontalPanel();
        final VerticalPanel suggestPanel = new VerticalPanel();
        suggestPanel.setSpacing(2);
        VerticalPanel dialogVPanel = new VerticalPanel();
        dialogVPanel.setSpacing(2);
        Button save = new Button("Save");
        save.setIcon(IconType.SAVE);

        save.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                messagesUI.addHeaderWidget();
                AddUsersBox.this.hide();
            }
        });
        Button close = new Button("Close");
        close.setIcon(IconType.REMOVE);
        close.setTitle("Close");
        close.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                AddUsersBox.this.hide();
            }
        });
        final Button add = new Button("Add User");
        add.setTitle("Press to add user ");
        add.setIcon(IconType.PLUS_SIGN);
        add.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                MessagesSuggestBox messagesSuggestBox = new MessagesSuggestBox(usersChatList, messagesService);
                suggestPanel.add(messagesSuggestBox);
                customScrollPanel.scrollToBottom();
                customScrollPanel.add(suggestPanel);
            }
        });
        MessagesSuggestBox messagesSuggestBox = new MessagesSuggestBox( usersChatList,  messagesService);
        suggestPanel.add(messagesSuggestBox);
        customScrollPanel.add(suggestPanel);
        dialogVPanel.setHorizontalAlignment(VerticalPanel.ALIGN_RIGHT);

        buttonPanel.add(save);
        buttonPanel.add(close);
        buttonPanel.add(add);

        dialogVPanel.add(buttonPanel);
        dialogVPanel.add(customScrollPanel);

        setWidget(dialogVPanel);
    }




    public AddUsersBox(List<UsersChat> _usersChatList, MessagesServiceAsync _messagesService, final MessagesUI messagesUI, long chatRoom, final AccordionGroup listConversation){
        setText("Add User");
        setModal(true);
        setAnimationEnabled(true);
        setGlassEnabled(true);
        setWidth("400px");
        setHeight("300px");

        center();

        usersChatList = _usersChatList;
        messagesService = _messagesService;

        final ScrollPanel customScrollPanel = new ScrollPanel();
        customScrollPanel.setWidth("300px");
        customScrollPanel.setHeight("250px");
        customScrollPanel.setVisible(true);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        final VerticalPanel suggestPanel = new VerticalPanel();
        suggestPanel.setSpacing(2);
        VerticalPanel dialogVPanel = new VerticalPanel();
        dialogVPanel.setSpacing(2);


        Button save = new Button("Save");
        save.setIcon(IconType.SAVE);
        save.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                messagesUI.addUserToConversation(listConversation);
                AddUsersBox.this.hide();
            }
        });


        Button close = new Button("Close");
        close.setIcon(IconType.REMOVE);
        close.setTitle("Close");
        close.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                AddUsersBox.this.hide();
            }
        });


        final Button add = new Button("Add User");

        add.setIcon(IconType.PLUS_SIGN);
        add.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                horizontalPanel = new HorizontalPanel();
                MessagesSuggestBox messagesSuggestBox = new MessagesSuggestBox(usersChatList,  messagesService );
                suggestPanel.add(messagesSuggestBox);
                customScrollPanel.scrollToBottom();
                customScrollPanel.add(suggestPanel);

            }
        });


        MessagesSuggestBox messagesSuggestBox = new MessagesSuggestBox(usersChatList,  messagesService );

        suggestPanel.add(messagesSuggestBox);
        customScrollPanel.add(suggestPanel);
        dialogVPanel.setHorizontalAlignment(VerticalPanel.ALIGN_RIGHT);


        buttonPanel.add(save);
        buttonPanel.add(close);
        buttonPanel.add(add);

        dialogVPanel.add(buttonPanel);
        dialogVPanel.add(customScrollPanel);

        setWidget(dialogVPanel);

    }

}
