/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.messages.server;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.model.User;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.service.RemoteEventServiceServlet;
import it.eng.edison.messages.client.MessagesService;
import it.eng.edison.messages.client.event.ServerGeneratedMessageEvent;
import it.eng.edison.messages.server.dao.ChatMessagesDao;
import it.eng.edison.messages.server.dao.RegistredUsersDao;
import it.eng.edison.messages.server.model.ChatMessages;
import it.eng.edison.messages.server.model.ChatRoom;
import it.eng.edison.messages.server.model.GuestRoom;
import it.eng.edison.messages.server.model.UsersChat;
import it.eng.edison.messages.server.util.ConnectCassandra;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesServiceImpl
extends RemoteEventServiceServlet
implements MessagesService {
    private static Logger _log = LoggerFactory.getLogger(MessagesServiceImpl.class);
    public static final String TEST_USER = "test.user";
    private String filter = "";
    private static List<UsersChat> listOfRegistredUsers = new ArrayList();
    private List<UsersChat> listOfSelectedUsers = new ArrayList();
    private UsersChat user;
    private User userLiferay;
    private static Connection connection;
    private static String pathImage;
    private static String strSqlGetUsers;
    private AstyanaxContext<Keyspace> context;
    private Keyspace keyspace;
    private ConnectCassandra cassandra;

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = TEST_USER;
        return user;
    }

    public UsersChat getUser() throws IllegalArgumentException {
        String username = null;
        GCubeUser gCubeUser = null;
        HttpSession httpSession = null;
        try {
            httpSession = this.getThreadLocalRequest().getSession();
            username = httpSession.getAttribute("username").toString();
            gCubeUser = new LiferayUserManager().getUserByUsername(username);
            this.cassandra = new ConnectCassandra();
            this.keyspace = this.cassandra.getKeyspace();
        }
        catch (Exception e) {
            System.out.println("ERROR  UsersChat getUser() " + e.getMessage());
            e.printStackTrace();
        }
        this.user = new UsersChat();
        this.user.setId(gCubeUser.getUserId());
        this.user.setUrlAvatar(gCubeUser.getUserAvatarURL());
        this.user.setFullName(gCubeUser.getFullname());
        this.user.setUserName(gCubeUser.getUsername());
        this.user.setFirstName(gCubeUser.getFirstName());
        this.user.setLastName(gCubeUser.getLastName());
        this.user.setEmail(gCubeUser.getEmail());
        httpSession.setAttribute("user", (Object)this.user);
        System.out.println("user name " + this.user.getUserName());
        return this.user;
    }

    public int addUserToList(UsersChat user) throws IllegalArgumentException {
        this.listOfSelectedUsers.add(user);
        return this.listOfSelectedUsers.size() - 1;
    }

    public void removeUserFromList(int index) throws IllegalArgumentException {
        UsersChat u = (UsersChat)this.listOfSelectedUsers.get(index);
        this.listOfSelectedUsers.remove(index);
    }

    public List<UsersChat> getUsersFromList() throws IllegalArgumentException {
        ArrayList<UsersChat> tmpList = new ArrayList<UsersChat>();
        for (UsersChat listOfSelectedUser : this.listOfSelectedUsers) {
            tmpList.add(listOfSelectedUser);
        }
        this.listOfSelectedUsers.removeAll(this.listOfSelectedUsers);
        return tmpList;
    }

    public List<UsersChat> userList() throws IllegalArgumentException {
        try {
            connection = DataAccess.getConnection();
            HttpSession httpSession = this.getThreadLocalRequest().getSession();
            UsersChat user = (UsersChat)httpSession.getAttribute("user");
            RegistredUsersDao registredUsersDao = new RegistredUsersDao(connection);
            listOfRegistredUsers = registredUsersDao.getRegisteredUsers(user, strSqlGetUsers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listOfRegistredUsers;
    }

    public long createRoom() throws IllegalArgumentException {
        ArrayList tmpList = new ArrayList();
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        String names = "";
        int index = 0;
        int listUsersLength = this.listOfSelectedUsers.size();
        for (int i = 0; i < this.listOfSelectedUsers.size(); ++i) {
            if (((UsersChat)this.listOfSelectedUsers.get(i)).getLastName().isEmpty()) continue;
            names = names + ((UsersChat)this.listOfSelectedUsers.get(i)).getLastName() + ",";
            if (++index > 3) break;
        }
        if (listUsersLength > 3) {
            names = names + "  plus " + (listUsersLength - 4);
        }
        if (names.length() > 0) {
            names = names.substring(0, names.length() - 1);
        }
        try {
            connection = DataAccess.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.cassandra = new ConnectCassandra();
        this.keyspace = this.cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
        ChatRoom chatRoom = new ChatRoom();
        GuestRoom guestRoom = null;
        chatRoom.setRoomOwnerId(user.getId());
        chatRoom.setRoomOwner(user.getUserName());
        chatRoom.setRoomOwnerFullName(user.getFullName());
        chatRoom.setNameRoom(names);
        ArrayList<GuestRoom> guestRooms = new ArrayList<GuestRoom>();
        for (UsersChat listOfSelectedUser : this.listOfSelectedUsers) {
            guestRoom = new GuestRoom();
            guestRoom.setGuestId(listOfSelectedUser.getId());
            guestRoom.setGuestName(listOfSelectedUser.getUserName());
            guestRoom.setGuestFullName(listOfSelectedUser.getFullName());
            if (guestRoom.getGuestId() <= 0L) continue;
            guestRooms.add(guestRoom);
        }
        chatRoom.setGuestList(guestRooms);
        long idRoom = 0L;
        if (guestRooms.size() > 0) {
            try {
                idRoom = chatMessagesDao.createRoom(user.getId(), chatRoom);
            }
            catch (ConnectionException e) {
                e.printStackTrace();
            }
        }
        return idRoom;
    }

    public List<ChatRoom> getRoomFromOwner(long idUser) throws IllegalArgumentException {
        ArrayList<ChatRoom> rooms = new ArrayList();
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        try {
            connection = DataAccess.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.cassandra = new ConnectCassandra();
        this.keyspace = this.cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
        try {
            rooms = chatMessagesDao.getRoomFromOwner(user.getId());
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        return rooms;
    }

    public List<ChatRoom> getRoomsFromGuest(long idUser) throws IllegalArgumentException {
        ArrayList<ChatRoom> rooms = new ArrayList();
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        try {
            connection = DataAccess.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.cassandra = new ConnectCassandra();
        this.keyspace = this.cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
        try {
            rooms = chatMessagesDao.getRoomsFromGuest(user.getId());
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        return rooms;
    }

    public List<ChatMessages> getMessagesFromRoom(long idRoom) throws IllegalArgumentException {
        ArrayList<ChatMessages> messagesList = new ArrayList();
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        this.cassandra = new ConnectCassandra();
        this.keyspace = this.cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
        try {
            messagesList = chatMessagesDao.getMessagesFromRoom(idRoom);
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        return messagesList;
    }

    public String sendMsg(long idRoom, String message, String uplodaFileName, String contentType) throws IllegalArgumentException {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        this.cassandra = new ConnectCassandra();
        this.keyspace = this.cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
        if (contentType.contains("IMAGE")) {
            // empty if block
        }
        if ((contentType = "image").contains("APPLICATION")) {
            contentType = contentType.replace("application/", "");
        }
        System.out.println("contentType " + contentType);
        long[] arrId = new long[2];
        List usersChats = new ArrayList();
        try {
            arrId = chatMessagesDao.insertMessage(idRoom, user.getId(), user.getFullName(), message, uplodaFileName, contentType);
            usersChats = chatMessagesDao.getUserFromRoom(idRoom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ASLSession aslSession = this.getASLSession();
        ArrayList<GenericItemBean> recipients = new ArrayList<GenericItemBean>();
        for (UsersChat usersChat : usersChats) {
            GenericItemBean genericItemBean = new GenericItemBean();
            genericItemBean.setId("" + usersChat.getId());
            genericItemBean.setName(usersChat.getUserName());
            genericItemBean.setThumbnailURL("");
            recipients.add(genericItemBean);
        }
        String messageId = "" + arrId;
        SocialNetworkingUser socialNetworkingUser = new SocialNetworkingUser();
        socialNetworkingUser.setEmail(user.getEmail());
        socialNetworkingUser.setUsername(user.getUserName());
        socialNetworkingUser.setFullname(user.getFullName());
        SocialNetworkingSite socialNetworkingSite = new SocialNetworkingSite(this.getThreadLocalRequest());
        SocialNetworkingUser userSender = new SocialNetworkingUser(aslSession.getUsername(), aslSession.getUserEmailAddress(), aslSession.getUserFullName(), aslSession.getUserAvatarId());
        ApplicationNotificationsManager nm = new ApplicationNotificationsManager(socialNetworkingSite, aslSession.getScope(), userSender);
        Thread thread = new Thread((Runnable)new MessageNotificationsThread(recipients, messageId, "chat", "invio chat", (NotificationsManager)nm));
        thread.start();
        ServerGeneratedMessageEvent theEvent = new ServerGeneratedMessageEvent("" + arrId[0] + "," + arrId[1]);
        this.addEvent(ServerGeneratedMessageEvent.SERVER_MESSAGE_DOMAIN, (Event)theEvent);
        return "OK";
    }

    public ChatMessages getMessage(long idMessage, long idRoomSelected) throws IllegalArgumentException {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        this.cassandra = new ConnectCassandra();
        this.keyspace = this.cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
        ChatMessages chatMessage = null;
        try {
            chatMessage = chatMessagesDao.getMessage(idMessage, user.getId(), idRoomSelected);
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        return chatMessage;
    }

    public void deleteUserFromList(long idRoom) throws IllegalArgumentException {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        this.cassandra = new ConnectCassandra();
        this.keyspace = this.cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
        try {
            chatMessagesDao.deleteUserFromList(idRoom, user.getId());
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
    }

    public void addUserToConversation(List<UsersChat> userList, long idRoom) throws IllegalArgumentException {
        ArrayList<GuestRoom> guestRooms = new ArrayList<GuestRoom>();
        for (UsersChat listOfSelectedUser : userList) {
            GuestRoom guestRoom = new GuestRoom();
            guestRoom.setGuestId(listOfSelectedUser.getId());
            guestRoom.setGuestName(listOfSelectedUser.getUserName());
            guestRoom.setGuestFullName(listOfSelectedUser.getFullName());
            if (guestRoom.getGuestId() <= 0L) continue;
            guestRooms.add(guestRoom);
        }
        if (guestRooms.size() > 0) {
            this.cassandra = new ConnectCassandra();
            this.keyspace = this.cassandra.getKeyspace();
            ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
            try {
                chatMessagesDao.addUserToList(idRoom, guestRooms);
            }
            catch (ConnectionException e) {
                e.printStackTrace();
            }
        }
    }

    public List<ChatMessages> searchMessage(long idRoom, String string) throws IllegalArgumentException {
        ArrayList<ChatMessages> messagesList = new ArrayList();
        System.out.println("searchMessage room " + idRoom + " string  " + string);
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(this.keyspace);
        try {
            messagesList = chatMessagesDao.searchMessages(string, idRoom);
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        return messagesList;
    }
}

