package it.eng.edison.messages.client;

import com.github.gwtbootstrap.client.ui.*;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.TextArea;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.event.HideEvent;
import com.github.gwtbootstrap.client.ui.event.HideHandler;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;
import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.RemoteEventService;
import de.novanic.eventservice.client.event.RemoteEventServiceFactory;
import de.novanic.eventservice.client.event.listener.RemoteEventListener;
import it.eng.edison.messages.client.bundle.MessagesCss;
import it.eng.edison.messages.client.event.ServerGeneratedMessageEvent;
import it.eng.edison.messages.server.model.ChatMessages;
import it.eng.edison.messages.server.model.UsersChat;
import it.eng.edison.messages.server.model.ChatRoom;
import it.eng.edison.messages.server.model.GuestRoom;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.widgets.imagepreviewerwidget.client.ui.Carousel;



import org.gcube.portlets.widgets.imagepreviewerwidget.client.EnhancedImage;
//import org.gcube.portlets.widgets.wsexplorer.client.notification.WorkspaceExplorerSaveNotification;
//import org.gcube.portlets.widgets.wsexplorer.client.notification.WorkspaceExplorerSelectNotification;
//import org.gcube.portlets.widgets.wsexplorer.client.save.WorkspaceExplorerSaveDialog;
//import org.gcube.portlets.widgets.wsexplorer.client.select.WorkspaceExplorerSelectDialog;
//import org.gcube.portlets.widgets.wsexplorer.client.select.WorkspaceExplorerSelectPanel;
//import org.gcube.portlets.widgets.wsexplorer.shared.Item;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 12/07/2016.
 */
public class MessagesUI extends Composite {



//    @UiField
//    CustomScrollPanel scrollPanelconversationList;

    @UiField
    CustomScrollPanel scrollPanel;

    @UiField
    VerticalPanel chatContainer;
    @UiField
    Paragraph messagesParagraph;
    @UiField
    Button attachButton;
    @UiField
    TextArea messageToSend;
    @UiField
    Button sendButton;
    @UiField
    Accordion conversationList;
    @UiField
    Button addConversationButton;

    @UiField
    Paragraph panelButton;


//    private CustomScrollPanel scrollPanelconversationList;

    // private AccordionGroup listConversation;
    private List<UsersChat> list;
    private MessagesServiceAsync messagesService;

    private DateTimeFormat simpleDateFormat;
    private DateTimeFormat simpleTimeFormat;
    private List<UsersChat> usersList = new ArrayList<UsersChat>();
    private String uplodaFileName;
    private String contentType;
    private MessagesUI messagesUI;
    private UsersChat user;
    private List<UsersChat> selectedUser = new ArrayList<UsersChat>();

    private String listOfUsersStr;
    private long idRoomSelected;
    private Button buttonSearchMessages;

    private String servletPath;

    private String searchString;



    static {
        MessagesCss.INSTANCE.css().ensureInjected();
    }


    public interface MessageTemlate extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template("<div >  <div class = 'msgTitleReceived'> {0}</div> <br/><p class='msgDescriptionReceived'>{1}</p><div class='timeDateReceived'>{2}</div></div>")
        SafeHtml getFormattedMessageReceived(String name, SafeHtml message, String time);

        @SafeHtmlTemplates.Template("<div > <div class = 'msgTitlePosted'> {0}</div> <br/><p class='msgDescriptionPosted'>{1}</p><div class='timeDatePosted'>{2}</div></div>")
        SafeHtml getFormattedMessagePosted(String name, SafeHtml message, String time);

        @SafeHtmlTemplates.Template("<div > <div class = 'msgTitlePosted'> {0}</div> <br/><p class='imageCursor'>{1}</p><div class='timeDatePosted'>{2}</div></div>")
        SafeHtml getFormattedAttach(String name, Image image, String time);

    }

    private static final MessageTemlate TEMPLATES = GWT.create(MessageTemlate.class);

    private static MessagesUIUiBinder ourUiBinder = GWT.create(MessagesUIUiBinder.class);

    interface MessagesUIUiBinder extends UiBinder<Widget, MessagesUI> {
    }


    public MessagesUI(List<UsersChat> _list, MessagesServiceAsync _messagesService, UsersChat _user) {

        initWidget(ourUiBinder.createAndBindUi(this));
        messagesUI = this;

        searchString = "";



        final RemoteEventService theRemoteEventService = RemoteEventServiceFactory.getInstance().getRemoteEventService();
        theRemoteEventService.addListener(ServerGeneratedMessageEvent.SERVER_MESSAGE_DOMAIN, new RemoteEventListener() {

            @Override
            public void apply(Event event) {
                //   Window.alert("theServerGeneratedMessageEvent ==> ");
                if (event instanceof ServerGeneratedMessageEvent) {
                    ServerGeneratedMessageEvent theServerGeneratedMessageEvent = (ServerGeneratedMessageEvent) event;
                    loadMessage(((ServerGeneratedMessageEvent) event).getServerGeneratedMessage());
                }
            }
        });

        user = _user;

        panelButton.setStyleName("positionPanelButton");
        simpleDateFormat = DateTimeFormat.getFormat("dd/MM/yyyy HH.mm.ss");
        simpleTimeFormat = DateTimeFormat.getFormat("HH.mm.ss");

        servletPath = GWT.getModuleBaseURL();

        servletPath = servletPath.replace("messages/", "");
        chatContainer.setStyleName("chatContainer");
        scrollPanel.setStyleName("scrollpanel");
        scrollPanel.removeHorizontalScrollbar();

//        scrollPanelconversationList = new CustomScrollPanel();
//        scrollPanelconversationList.setStyleName("scrollpanel");
//        scrollPanelconversationList.removeHorizontalScrollbar();

        list = _list;
        messagesService = _messagesService;

        messagesService.getRoomFromOwner(user.getId(), new AsyncCallback<List>() {
            @Override
            public void onFailure(Throwable caught) {
            }

            @Override
            public void onSuccess(List result) {
                loadConversations(result,true);
            }
        });

        messagesService.getRoomsFromGuest(user.getId(), new AsyncCallback<List>() {
            @Override
            public void onFailure(Throwable caught) {

            }

            @Override
            public void onSuccess(List result) {
                loadConversations(result,false);
            }
        });

        addConversationButton.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
            @Override
            public String get() {
                return "attachButton";
            }
        });

        addConversationButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                addConversation();
            }
        });


        sendButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if(idRoomSelected == 0){
                    new ChatDialogBox("You have to specify the chat room!", "WARNING").show();
                    return;
                }


                if (messageToSend.getText().isEmpty()) {
                    new ChatDialogBox("You need to write something!", "WARNING").show();
                    return;
                }
                if (uplodaFileName == null) {
                    uplodaFileName = "-";
                    contentType = "-";
                }
                messagesService.sendMsg(idRoomSelected, messageToSend.getText(), uplodaFileName, contentType, new AsyncCallback<String>() {
                    @Override
                    public void onFailure(Throwable caught) {
                        Window.alert("ERRORE " + caught.getMessage());
                        messageToSend.setText("");
                        uplodaFileName = null;
                        contentType = " ";

                    }

                    @Override
                    public void onSuccess(String result) {
                        messageToSend.setText("");
                        uplodaFileName = null;
                        contentType = " ";
                    }
                });
                messageToSend.setText("");
                uplodaFileName = null;
                contentType = " ";
            }
        });

        attachButton.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
            @Override
            public String get() {
                return "attachButton";
            }
        });

        attachButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                new UploadDialogBox(messagesUI).show();

            }
/*
                final WorkspaceExplorerSelectDialog navigator = new WorkspaceExplorerSelectDialog("WorkpspaceExplorer", false);

                WorkspaceExplorerSelectNotification.WorskpaceExplorerSelectNotificationListener listener = new WorkspaceExplorerSelectNotification.WorskpaceExplorerSelectNotificationListener() {
                    @Override
                    public void onSelectedItem(Item item) {
                       // GWT.log("onSelectedItem: "+item);
                        Window.alert( "Name " + item.getName() + " : Type " + item.getType().toString()   );  // System.out.println("item.getName() " + item.getName() );
                        setUplodaFileName(  item.getName(),  item.getType().toString() );
                        navigator.hide();
                    }

                    @Override
                    public void onFailed(Throwable throwable) {
                        Window.alert("onFailed..");

                    }

                    @Override
                    public void onAborted() {
                        Window.alert("onAborted..");

                    }

                    @Override
                    public void onNotValidSelection() {
                        Window.alert("onNotValidSelection..");

                    }
                };

                navigator.addWorkspaceExplorerSelectNotificationListener(listener);
                navigator.show();

            }
        */
        });




    }// fine costruttore

    //inizio metodi conversazioni

    private void loadConversations(List<ChatRoom> chatRooms, boolean owner) {
        UsersChat usersChat;
        for (ChatRoom chatRoom : chatRooms) {
            final AccordionGroup listConversation = new AccordionGroup();
            List<UsersChat> usersChats = new ArrayList<UsersChat>();

            List<GuestRoom> guestRooms = chatRoom.getGuestList();
            for (GuestRoom guestRoom : guestRooms) {
                if (chatRoom.getIdRoom() == guestRoom.getIdRoom()) {
                    usersChat = new UsersChat();
                    usersChat.setUserName(guestRoom.getGuestName());
                    usersChat.setFullName(guestRoom.getGuestFullName());
                    usersChat.setUrlAvatar(guestRoom.getUrlAvatar());
                    usersChats.add(usersChat);
                }
            }
            if( !owner ) {
                usersChat = new UsersChat();
                usersChat.setUserName(chatRoom.getRoomOwner());
                usersChat.setFullName(chatRoom.getRoomOwnerFullName());
                usersChat.setUrlAvatar(chatRoom.getOwnerUrlAvatar());
                usersChats.add(usersChat);
            }

            Button buttonRemove = new Button();
            buttonRemove.setIcon(IconType.REMOVE_CIRCLE);
            buttonRemove.setName("buttonRemove");
            buttonRemove.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                @Override
                public String get() {
                    return "buttonVisible";
                }
            });
            buttonRemove.setWidth("25px");
            buttonRemove.setTitle("Leave the chat room");

            buttonRemove.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    String warning = "warning: this action removes you from the conversation ";
                    ConfirmDialogBox confirmDialogBox = new ConfirmDialogBox("Are you sure?", warning, new ConfirmDialogBox.ConfirmDialogCallback() {
                        @Override
                        public boolean yesPressed() {
                            messagesService.deleteUserFromList(idRoomSelected, new AsyncCallback<Void>() {
                                @Override
                                public void onFailure(Throwable caught) {
                                }
                                @Override
                                public void onSuccess(Void result) {

                                }
                            });
                            return false;
                        }
                        @Override
                        public boolean noPressed() {
                            return false;
                        }
                    });

                }
            });




            Button buttonAddUser = new Button();
            buttonAddUser.setIcon(IconType.PLUS_SIGN);
            buttonAddUser.setName("buttonAddUser");
            buttonAddUser.setWidth("25px");
            buttonAddUser.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                @Override
                public String get() {
                    return "buttonVisible";
                }
            });
            buttonAddUser.setTitle("Add user to conversation");
            buttonAddUser.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    AddUsersBox addUsersBox = new AddUsersBox(list, messagesService, messagesUI, idRoomSelected, listConversation);
                    addUsersBox.show();
                }
            });

            buttonSearchMessages = new Button();
            buttonRemove.setName("buttonSearchMessages");
            buttonSearchMessages.setIcon(IconType.SEARCH);
            buttonSearchMessages.setTitle("Search messagge and conversation ");
            buttonSearchMessages.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                @Override
                public String get() {
                    return "buttonVisible";
                }
            });

            buttonSearchMessages.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {

                    openSearchBox(idRoomSelected  );

                }
            });



            Button notification = new Button();
            notification.setIcon(IconType.BELL);
            notification.setWidth("25px");
            notification.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                @Override
                public String get() {
                    return "buttonHidden";
                }
            });
            notification.setTitle("Notification");
            notification.setVisible(true);

            listConversation.addShowHandler(new ShowHandler() {
                @Override
                public void onShow(ShowEvent showEvent) {
                    listConversation.setIcon(IconType.ANGLE_UP);
                    Node node =  listConversation.getHeading().getWidget(0).getElement().getLastChild();
                    Element notificationButton = (Element)node;
                    notificationButton.replaceClassName("notificationVisible" , "buttonHidden");
                }
            });


            listConversation.addHideHandler(new HideHandler() {
                @Override
                public void onHide(HideEvent hideEvent) {
                    listConversation.setIcon(IconType.ANGLE_DOWN);
                }
            });

            listConversation.setIcon(IconType.ANGLE_DOWN);
            listConversation.addDomHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    long idRoom = Long.parseLong(((AccordionGroup) event.getSource()).getTitle());
                    idRoomSelected = idRoom;
                    messagesService.getMessagesFromRoom(idRoom, new AsyncCallback<List<ChatMessages>>() {
                        @Override
                        public void onFailure(Throwable caught) {
                        }

                        @Override
                        public void onSuccess(List<ChatMessages> result) {

                            displayMessage(result);
                        }
                    });
                }
            }, ClickEvent.getType());

            listConversation.addCustomTrigger(notification);
            listConversation.addCustomTrigger(buttonAddUser);
            listConversation.addCustomTrigger(buttonSearchMessages);
            listConversation.addCustomTrigger(buttonRemove);
            listConversation.setHeading(chatRoom.getNameRoom());
            listConversation.setTitle("" + chatRoom.getIdRoom());
            listConversation.setId("" + chatRoom.getIdRoom());
            conversationList.add(listConversation);
            listConversation.add(createContactsItem(usersChats));

        }

    }


    /* ///////////////////////////////
    addUserToConversation
    */
    public void addUserToConversation( final AccordionGroup  listConversation){
        messagesService.getUsersFromList(new AsyncCallback<List<UsersChat>>() {
            @Override
            public void onFailure(Throwable caught) {

            }

            @Override
            public void onSuccess(List<UsersChat> result) {
                final List<UsersChat> listUserAdded = result;
                messagesService.addUserToConversation(result, idRoomSelected, new AsyncCallback<Void>() {
                    @Override
                    public void onFailure(Throwable caught) {

                    }

                    @Override
                    public void onSuccess(Void result) {
                        listConversation.add(createContactsItem(listUserAdded));
                    }
                });
            }
        });
    }





    /////////////////////////////
    public void addHeaderWidget() {
        messagesService.createRoom(new AsyncCallback<Long>() {
            @Override
            public void onFailure(Throwable caught) {
            }

            @Override
            public void onSuccess(Long result) {
                final long idRoom = result;
                messagesService.getUsersFromList(new AsyncCallback<List<UsersChat>>() {
                    @Override
                    public void onFailure(Throwable caught) {
                    }

                    @Override
                    public void onSuccess(List<UsersChat> result) {
                        int resultLength = result.size();
                        final AccordionGroup listConversation = new AccordionGroup();
                        if (resultLength > 0) {
                            String names = "";
                            for (int i = 0; i < resultLength; i++) {
                                names = names + result.get(i).getLastName() + ",";
                            }
                            if (resultLength > 2) {
                                names = names + "  plus " + (resultLength - 3);
                            }
                            names = names.substring(0, names.length() - 1);
                            Button buttonRemove = new Button();
                            buttonRemove.setName("buttonRemove");
                            buttonRemove.setIcon(IconType.REMOVE_CIRCLE);
                            buttonRemove.setWidth("25px");
                            buttonRemove.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                                @Override
                                public String get() {
                                    return "buttonVisible";
                                }
                            });
                            buttonRemove.setTitle("Leave the chat room");
                            buttonRemove.addClickHandler(new ClickHandler() {
                                @Override
                                public void onClick(ClickEvent event) {
                                    String warning = "warning: this action removes you from the conversation ";
                                    ConfirmDialogBox confirmDialogBox = new ConfirmDialogBox("Are you sure?", warning, new ConfirmDialogBox.ConfirmDialogCallback() {
                                        @Override
                                        public boolean yesPressed() {
                                            messagesService.deleteUserFromList(idRoomSelected, new AsyncCallback<Void>() {
                                                @Override
                                                public void onFailure(Throwable caught) {
                                                }

                                                @Override
                                                public void onSuccess(Void result) {
                                                }
                                            });
                                            return false;
                                        }

                                        @Override
                                        public boolean noPressed() {
                                            return false;
                                        }
                                    });
                                }
                            });



                            Button buttonAddUser = new Button();
                            buttonAddUser.setIcon(IconType.PLUS_SIGN);
                            buttonAddUser.setName("buttonAddUser");
                            buttonAddUser.setWidth("25px");
                            buttonAddUser.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                                @Override
                                public String get() {
                                    return "buttonVisible";
                                }
                            });
                            buttonAddUser.setTitle("Add user to conversation");
                            buttonAddUser.addClickHandler(new ClickHandler() {
                                @Override
                                public void onClick(ClickEvent event) {
                                    AddUsersBox addUsersBox = new AddUsersBox(list, messagesService, messagesUI, idRoomSelected, listConversation);
                                    addUsersBox.show();
                                }
                            });




                            buttonSearchMessages = new Button();
                            buttonSearchMessages.setIcon(IconType.SEARCH);
                            buttonSearchMessages.setName("buttonSearchMessages");
                            buttonSearchMessages.setTitle("Search messagge and conversation ");
                            buttonSearchMessages.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                                @Override
                                public String get() {
                                    return "buttonVisible";
                                }
                            });

                            buttonSearchMessages.addClickHandler(new ClickHandler() {
                                @Override
                                public void onClick(ClickEvent event) {
                                    openSearchBox(idRoomSelected);

                                }
                            });

                            Button notification = new Button();

                            notification.setIcon(IconType.BELL);

                            notification.setWidth("25px");
                            notification.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                                @Override
                                public String get() {
                                    return "buttonHidden";
                                }
                            });
                            notification.setTitle("Notification");
                            notification.setVisible(true);
                            notification.setName("Notification");

                            listConversation.addShowHandler(new ShowHandler() {
                                @Override
                                public void onShow(ShowEvent showEvent) {
                                    listConversation.setIcon(IconType.ANGLE_UP);
                                    Node node =  listConversation.getHeading().getWidget(0).getElement().getLastChild();
                                    Element notificationButton = (Element)node;
                                    notificationButton.replaceClassName("notificationVisible" , "buttonHidden");
                                }
                            });


                            listConversation.addHideHandler(new HideHandler() {
                                @Override
                                public void onHide(HideEvent hideEvent) {
                                    listConversation.setIcon(IconType.ANGLE_DOWN);
                                }
                            });

                            listConversation.setIcon(IconType.ANGLE_DOWN);
                            listConversation.addDomHandler(new ClickHandler() {
                                @Override
                                public void onClick(ClickEvent event) {
                                    long idRoom = Long.parseLong(((AccordionGroup) event.getSource()).getTitle());
                                    idRoomSelected = idRoom;
                                    messagesService.getMessagesFromRoom(idRoom, new AsyncCallback<List<ChatMessages>>() {
                                        @Override
                                        public void onFailure(Throwable caught) {
                                        }

                                        @Override
                                        public void onSuccess(List<ChatMessages> result) {

                                            displayMessage(result);
                                        }
                                    });
                                }
                            }, ClickEvent.getType());

                            // add button
                            listConversation.addCustomTrigger(notification);
                            listConversation.addCustomTrigger(buttonAddUser);
                            listConversation.addCustomTrigger(buttonSearchMessages);
                            listConversation.addCustomTrigger(buttonRemove);

                            //listConversation.add(notification);

                            listConversation.setHeading(names);
                            listConversation.setTitle("" + idRoom);
                            conversationList.add(listConversation);
                            listConversation.add(createContactsItem(result));
                            //     scrollPanelconversationList.add(listConversation);
                        }
                    }
                });
            }
        });
    }

    /////////////////////////////////
    private Widget createContactsItem(List<UsersChat> list) {
        VerticalPanel contactsPanel = new VerticalPanel();
        HorizontalPanel horizontalPanel;
        contactsPanel.setSpacing(4);
        for (UsersChat usersChat : list) {
            Image avatar = new Image(usersChat.getUrlAvatar());
            avatar.setStyle(new com.github.gwtbootstrap.client.ui.base.Style() {
                @Override
                public String get() {
                    return "boxImage img";
                }
            });
            Label nameLbl = new Label(usersChat.getFullName());
            horizontalPanel = new HorizontalPanel();
            horizontalPanel.setSpacing(10);
            horizontalPanel.add(avatar);
            horizontalPanel.add(nameLbl);

            contactsPanel.add(horizontalPanel);
        }
        return new SimplePanel(contactsPanel);
    }

    //////////////
    private void addConversation() {
        AddUsersBox addUsersBox = new AddUsersBox(list, messagesService, this);
        addUsersBox.show();

    }

    //fine metodi conversazioni

    //inizio metodi messaggi


    private void displayMessage(List<ChatMessages> messageList) {
        messagesParagraph.removeFromParent();
        //   messagesParagraph = new Paragraph();
        scrollPanel.remove(chatContainer);
        chatContainer = new VerticalPanel();
        //    chatContainer.add(messagesParagraph);
        scrollPanel.add(chatContainer);
        servletPath = GWT.getModuleBaseURL();
        servletPath = servletPath.replace("messages/", "");
        for (ChatMessages chatMessages : messageList) {
            String today = simpleDateFormat.format(new Date());
            String dateOfMessage = simpleDateFormat.format(new Date(chatMessages.getDateTime()));

            if (chatMessages.getSenderId() != user.getId()) {
                messagesParagraph = new Paragraph();
                messagesParagraph.setStyleName("messagesParagraphReceveid");
                SafeHtml message = SafeHtmlUtils.fromTrustedString( chatMessages.getMessage());

                if (today.startsWith(dateOfMessage))
                    messagesParagraph.add(new HTML(TEMPLATES.getFormattedMessageReceived(chatMessages.getSender(), message, simpleTimeFormat.format(new Date(chatMessages.getDateTime())))));
                else
                    messagesParagraph.add(new HTML(TEMPLATES.getFormattedMessageReceived(chatMessages.getSender(), message, simpleDateFormat.format(new Date(chatMessages.getDateTime())))));
                chatContainer.add(messagesParagraph);
                scrollPanel.scrollToBottom();
            } else {
                messagesParagraph = new Paragraph();
                messagesParagraph.setStyleName("messagesParagraphPosted");

                SafeHtml message = SafeHtmlUtils.fromTrustedString(chatMessages.getMessage());
                if (today.startsWith(dateOfMessage))
                    messagesParagraph.add(new HTML(TEMPLATES.getFormattedMessagePosted(chatMessages.getSender(), message, simpleTimeFormat.format(new Date(chatMessages.getDateTime())))));
                else
                    messagesParagraph.add(new HTML(TEMPLATES.getFormattedMessagePosted(chatMessages.getSender(), message, simpleDateFormat.format(new Date(chatMessages.getDateTime())))));
                chatContainer.add(messagesParagraph);
                scrollPanel.scrollToBottom();
            }
            if (!chatMessages.getAttached().equals("-")) {
                final String imageFileName = chatMessages.getAttached();
                String fileType = chatMessages.getAttachedType();
                // Window.alert("imageFileName " + imageFileName);
                if (fileType.equals("image")) {
                    final Image imageReceived = new Image(servletPath + "getImage?imgId=" + imageFileName);
                    imageReceived.setTitle(imageFileName);
                    imageReceived.setStyleName("imageCursor");
                    imageReceived.addClickHandler(new ClickHandler() {
                        @Override
                        public void onClick(ClickEvent ev) {
                            viewImage(imageReceived);
                        }
                    });
                    imageReceived.setHeight("80px");
                    imageReceived.setWidth("80x");
                    messagesParagraph.add(imageReceived);
                } else {
                    if (fileType.equals("pdf")) {

                        final Image imageReceived = new Image(servletPath + "/pdf.png");
                        imageReceived.setTitle(imageFileName);
                        imageReceived.setStyleName("imageCursor");
                        imageReceived.addClickHandler(new ClickHandler() {
                            @Override
                            public void onClick(ClickEvent ev) {
                                openNewWindow(servletPath + "getImage?imgId=" + imageFileName);
                            }
                        });
                        imageReceived.setHeight("50px");
                        imageReceived.setWidth("50px");
                        messagesParagraph.add(imageReceived);

                    } else {
                        final Image imageReceived = new Image(servletPath + "/document.png");
                        imageReceived.setTitle(imageFileName);
                        imageReceived.setStyleName("imageCursor");
                        imageReceived.addClickHandler(new ClickHandler() {
                            @Override
                            public void onClick(ClickEvent ev) {
                                openNewWindow(servletPath + "getImage?imgId=" + imageFileName);
                            }
                        });
                        imageReceived.setHeight("50px");
                        imageReceived.setWidth("50px");
                        messagesParagraph.add(imageReceived);
                    }
                }
            }


        }
    }


    private void viewImage(final Image image) {
        Carousel carousel = new Carousel();
        EnhancedImage enhancedImage = new EnhancedImage(image, image.getTitle(), "22222");
        List<EnhancedImage> list = new ArrayList<EnhancedImage>();
        list.add(enhancedImage);
        carousel.updateImages(list);
        carousel.show();
    }

    private void openNewWindow(String fileURL) {
        com.google.gwt.user.client.Window.open(fileURL, "_blank", "");
    }


    private void loadMessage(String _idMessage) {
        String[] arrTmp = _idMessage.split(",");
        long idMessage = Long.parseLong(arrTmp[0]);
        long roomId = Long.parseLong(arrTmp[1]);
        String idRoom = arrTmp[1];


        if(idRoomSelected != roomId) {

            for (Widget widget : conversationList) {
                if (widget.getTitle().equals(idRoom)) {
                    AccordionGroup aGroup = (AccordionGroup) widget;
                    Node node = aGroup.getHeading().getWidget(0).getElement().getLastChild();
                    Element elementButton = (Element) node;
                    elementButton.replaceClassName("buttonHidden", "notificationVisible");
                }
            }
            return;
        }




        messagesService.getMessage(idMessage, roomId, new AsyncCallback<ChatMessages>() {
            @Override
            public void onFailure(Throwable caught) {

            }

            @Override
            public void onSuccess(ChatMessages result) {
                displayMessage(result);
            }
        });

    }


    private void displayMessage(ChatMessages chatMessage) {
        messagesParagraph = new Paragraph();
        chatContainer.add(messagesParagraph);
        servletPath = GWT.getModuleBaseURL();
        servletPath = servletPath.replace("messages/", "");
        String today = simpleDateFormat.format(new Date());
        String dateOfMessage = simpleDateFormat.format(new Date(chatMessage.getDateTime()));

        if (chatMessage.getSenderId() != user.getId()) {
            //receveid
            SafeHtml message = SafeHtmlUtils.fromTrustedString( chatMessage.getMessage());
            messagesParagraph.setStyleName("messagesParagraphReceveid");
            if (today.startsWith(dateOfMessage))
                messagesParagraph.add(new HTML(TEMPLATES.getFormattedMessageReceived(chatMessage.getSender(), message, simpleTimeFormat.format(new Date(chatMessage.getDateTime())))));
            else
                messagesParagraph.add(new HTML(TEMPLATES.getFormattedMessageReceived(chatMessage.getSender(), message, simpleDateFormat.format(new Date(chatMessage.getDateTime())))));
            chatContainer.add(messagesParagraph);
            scrollPanel.scrollToBottom();
        } else {
            //posted
            SafeHtml message = SafeHtmlUtils.fromTrustedString(chatMessage.getMessage());
            messagesParagraph.setStyleName("messagesParagraphPosted");
            if (today.startsWith(dateOfMessage))
                messagesParagraph.add(new HTML(TEMPLATES.getFormattedMessagePosted(chatMessage.getSender(), message, simpleTimeFormat.format(new Date(chatMessage.getDateTime())))));
            else
                messagesParagraph.add(new HTML(TEMPLATES.getFormattedMessagePosted(chatMessage.getSender(), message, simpleDateFormat.format(new Date(chatMessage.getDateTime())))));
            chatContainer.add(messagesParagraph);
            scrollPanel.scrollToBottom();
        }
        if (!chatMessage.getAttached().equals("-")) {
            final String imageFileName = chatMessage.getAttached();
            // Window.alert("imageFileName " + imageFileName);
            String fileType = chatMessage.getAttachedType();
            if (fileType.equals("image")) {
                final Image imageReceived = new Image(servletPath + "getImage?imgId=" + imageFileName);
                imageReceived.setTitle(imageFileName);
                imageReceived.setStyleName("imageCursor");
                imageReceived.addClickHandler(new ClickHandler() {
                    @Override
                    public void onClick(ClickEvent ev) {
                        viewImage(imageReceived);
                    }
                });
                imageReceived.setHeight("80px");
                imageReceived.setWidth("80px");
                messagesParagraph.add(imageReceived);
            } else {
                if (fileType.equals("pdf")) {
                    final Image imageReceived = new Image(servletPath + "/pdf.png");
                    imageReceived.setTitle(imageFileName);
                    imageReceived.setStyleName("imageCursor");
                    imageReceived.addClickHandler(new ClickHandler() {
                        @Override
                        public void onClick(ClickEvent ev) {
                            openNewWindow(servletPath + "getImage?imgId=" + imageFileName);
                        }
                    });
                    imageReceived.setHeight("50px");
                    imageReceived.setWidth("50px");
                    messagesParagraph.add(imageReceived);

                } else {
                    final Image imageReceived = new Image(servletPath + "/document.png");
                    imageReceived.setTitle(imageFileName);
                    imageReceived.setStyleName("imageCursor");
                    imageReceived.addClickHandler(new ClickHandler() {
                        @Override
                        public void onClick(ClickEvent ev) {
                            openNewWindow(servletPath + "getImage?imgId=" + imageFileName);
                        }
                    });
                    imageReceived.setHeight("50px");
                    imageReceived.setWidth("50px");
                    messagesParagraph.add(imageReceived);
                }

            }
        }

    }


    //fine metodi messaggi
/*
    public void setUplodaFileName(String _uplodaFileName, String _contentType){
        uplodaFileName = _uplodaFileName;
        contentType = _contentType;


        org.gcube.common.homelibrary.home.workspace.Workspace

    }
*/

    public void setUplodaFileName(String _uplodaFileName) {
        String[] strTmp = _uplodaFileName.split("@");
        uplodaFileName = strTmp[0];
        String _contentType = strTmp[1];
        _contentType = _contentType.replace("</pre>", "");
        _contentType = _contentType.substring(_contentType.indexOf(">") + 1);
        contentType = _contentType;

    }



    public void openSearchBox(long idRoomSelected){

        SearchMessaggesBox  searchMessaggesBox = new SearchMessaggesBox(this);

        searchMessaggesBox.show();




    }

    public void setSearchString(String _searchString){

        searchString = _searchString;


        messagesService.searchMessage(idRoomSelected, searchString, new AsyncCallback<List<ChatMessages>>() {
            @Override
            public void onFailure(Throwable caught) {
                //  searchString = "";
            }

            @Override
            public void onSuccess(List<ChatMessages> result) {
                displayMessage(result);
            }
        });

    }


}