package it.eng.edison.messages.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import it.eng.edison.messages.server.model.ChatMessages;
import it.eng.edison.messages.server.model.UsersChat;

import java.util.List;


public interface MessagesServiceAsync {

    void userList(AsyncCallback<List<UsersChat>> async);

    void getUsersFromList(AsyncCallback<List<UsersChat>> async);

    void addUserToList(UsersChat user, AsyncCallback<Integer> async);

    void removeUserFromList(int index, AsyncCallback<Void> async);

    void getRoomFromOwner(long idUser, AsyncCallback<List> async) ;

    void createRoom(AsyncCallback<Long> async) ;

    void getUser(AsyncCallback<UsersChat> async);

    void getRoomsFromGuest(long idUser, AsyncCallback<List> async) ;

    void getMessagesFromRoom(long idRoom, AsyncCallback<List<ChatMessages> > async) ;

    void sendMsg(long idRoom, String message, String uplodaFileName, String contentType, AsyncCallback<String> async) ;

    void getMessage(long idMessage, long idRoom, AsyncCallback<ChatMessages> async) ;

    void deleteUserFromList(long idRoom, AsyncCallback<Void> async) ;

    void addUserToConversation(List<UsersChat> userList, long idRoom, AsyncCallback<Void> async) ;


    void searchMessage(long idRoom, String string, AsyncCallback<List<ChatMessages>> async);

}
