/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.messages.server.dao;

import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlStatementResult;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import it.eng.edison.messages.server.dao.IncrementIndexMessage;
import it.eng.edison.messages.server.model.ChatMessages;
import it.eng.edison.messages.server.model.ChatRoom;
import it.eng.edison.messages.server.model.GuestRoom;
import it.eng.edison.messages.server.model.UsersChat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;

public class ChatMessagesDao {
    private Keyspace keyspace;

    public ChatMessagesDao(Keyspace _keyspace) {
        this.keyspace = _keyspace;
    }

    public void addUserToList(long idRoom, List<GuestRoom> listUser) throws ConnectionException {
        for (GuestRoom guest : listUser) {
            String strSqlGuest = "INSERT INTO guestRoom (idRoom, guestId, guestName, guestFullName ) VALUES ";
            strSqlGuest = strSqlGuest + "( ";
            strSqlGuest = strSqlGuest + idRoom + ",";
            strSqlGuest = strSqlGuest + guest.getGuestId() + ",";
            strSqlGuest = strSqlGuest + "'" + guest.getGuestName() + "',";
            strSqlGuest = strSqlGuest + "'" + guest.getGuestFullName() + "')";
            this.keyspace.prepareCqlStatement().withCql(strSqlGuest).execute();
        }
    }

    public void deleteUserFromList(long idRoom, long idUser) throws ConnectionException {
        System.out.println("Delete User From room:" + idRoom + " user:" + idUser);
        String strDelete = "DELETE FROM guestroom WHERE idroom = " + idRoom + " AND guestid = " + idUser;
        String strUpdate = "UPDATE chatroom SET active = false WHERE idroom = " + idRoom + " AND roomOwnerId = " + idUser;
        String strControl = "SELECT  roomownerid FROM chatroom WHERE roomownerid=" + idUser + " AND idroom=" + idRoom;
        this.keyspace.prepareCqlStatement().withCql(strDelete).execute();
        long ownerId = 0L;
        CqlStatementResult result = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(strControl).execute().getResult();
        Rows row = result.getRows(ColumnFamily.newColumnFamily((String)"chatroom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : row) {
            ColumnList columns = longStringRow.getColumns();
            ownerId = columns.getLongValue((Object)"roomownerid", null);
            if (ownerId <= 0L) continue;
            this.keyspace.prepareCqlStatement().withCql(strUpdate).execute();
        }
    }

    public ChatMessages getMessage(long idMessage, long user, long _idRoom) throws ConnectionException {
        ChatMessages chatMessage = null;
        long guestId = 0L;
        long roomownerid = 0L;
        long senderid = 0L;
        String strMessage = "SELECT * FROM chatmessage WHERE idmessage = " + idMessage;
        String strGuestRoom = "SELECT * FROM guestroom WHERE idroom=" + _idRoom + " AND guestid=" + user;
        String strRoomOwner = " SELECT *  from chatroom WHERE idroom=" + _idRoom + " and roomownerid=" + user;
        CqlStatementResult result = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(strMessage).execute().getResult();
        Rows riga = result.getRows(ColumnFamily.newColumnFamily((String)"chatmessage", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : riga) {
            ColumnList columns = longStringRow.getColumns();
            senderid = columns.getLongValue((Object)"senderid", null);
            chatMessage = new ChatMessages();
            chatMessage.setMessage(columns.getStringValue((Object)"message", null));
            chatMessage.setSenderId(senderid);
            chatMessage.setIdChatRoom(columns.getLongValue((Object)"idchatroom", null).longValue());
            chatMessage.setDateTime(columns.getLongValue((Object)"datetime", null).longValue());
            chatMessage.setAttached(columns.getStringValue((Object)"attached", null));
            chatMessage.setAttachedType(columns.getStringValue((Object)"attachedtype", null));
            chatMessage.setIdMessage(columns.getLongValue((Object)"idmessage", null).longValue());
            chatMessage.setReadMessage(columns.getBooleanValue((Object)"readmessage", null).booleanValue());
            chatMessage.setSender(columns.getStringValue((Object)"sender", null));
        }
        CqlStatementResult resultGuest = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(strGuestRoom).execute().getResult();
        Rows rowGuest = resultGuest.getRows(ColumnFamily.newColumnFamily((String)"guestroom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : rowGuest) {
            ColumnList columns = longStringRow.getColumns();
            guestId = columns.getLongValue((Object)"guestid", null);
        }
        CqlStatementResult resultOwner = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(strRoomOwner).execute().getResult();
        Rows rowOwner = resultOwner.getRows(ColumnFamily.newColumnFamily((String)"chatroomroom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : rowOwner) {
            ColumnList columns = longStringRow.getColumns();
            roomownerid = columns.getLongValue((Object)"roomownerid", null);
        }
        if (senderid == user || guestId != 0L || roomownerid != 0L) {
            return chatMessage;
        }
        return null;
    }

    public List<ChatMessages> getMessagesFromRoom(long idChatRoom) throws ConnectionException {
        ArrayList<ChatMessages> listOfMessages = new ArrayList<ChatMessages>();
        String sqlStrMessage = "SELECT * FROM chatmessage where idChatRoom = " + idChatRoom + "  ORDER BY  DateTime ASC ";
        CqlStatementResult result = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(sqlStrMessage).execute().getResult();
        Rows riga = result.getRows(ColumnFamily.newColumnFamily((String)"chatmessage", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : riga) {
            ColumnList columns = longStringRow.getColumns();
            ChatMessages chatMessage = new ChatMessages();
            chatMessage.setMessage(columns.getStringValue((Object)"message", null));
            chatMessage.setSenderId(columns.getLongValue((Object)"senderid", null).longValue());
            chatMessage.setIdChatRoom(columns.getLongValue((Object)"idchatroom", null).longValue());
            chatMessage.setDateTime(columns.getLongValue((Object)"datetime", null).longValue());
            chatMessage.setAttached(columns.getStringValue((Object)"attached", null));
            chatMessage.setAttachedType(columns.getStringValue((Object)"attachedtype", null));
            chatMessage.setIdMessage(columns.getLongValue((Object)"idmessage", null).longValue());
            chatMessage.setReadMessage(columns.getBooleanValue((Object)"readmessage", null).booleanValue());
            chatMessage.setSender(columns.getStringValue((Object)"sender", null));
            listOfMessages.add(chatMessage);
        }
        return listOfMessages;
    }

    public long[] insertMessage(long idRoom, long senderId, String sender, String message, String attached, String attachedType) throws ConnectionException {
        long[] arrLong = new long[2];
        String strtTmp = "";
        IncrementIndexMessage incrementIndexMessage = new IncrementIndexMessage(this.keyspace);
        long idChatMessage = incrementIndexMessage.incrementId();
        strtTmp = " ( " + idChatMessage + ", ";
        strtTmp = strtTmp + senderId + ", ";
        strtTmp = strtTmp + new Date().getTime();
        strtTmp = strtTmp + ",'" + sender + "',";
        strtTmp = strtTmp + "'" + message + "',";
        strtTmp = strtTmp + "'" + attached + "',  '" + attachedType + "', false ," + idRoom + ")";
        String strInsert = " INSERT INTO chatmessage ( idMessage,  SenderId, DateTime, Sender,  Message, Attached, attachedType,  readMessage, idChatRoom) VALUES  ";
        strInsert = strInsert + strtTmp;
        this.keyspace.prepareCqlStatement().withCql(strInsert).execute();
        arrLong[0] = idChatMessage;
        arrLong[1] = idRoom;
        return arrLong;
    }

    public List getRoomFromOwner(long idUser) throws ConnectionException {
        ArrayList<ChatRoom> chatRooms = new ArrayList<ChatRoom>();
        ArrayList<GuestRoom> guestRooms = new ArrayList<GuestRoom>();
        ChatRoom chatRoom = null;
        GuestRoom guestRoom = null;
        String sqlStr = "SELECT * FROM chatroom WHERE roomOwnerId = " + idUser + " AND active=true ALLOW FILTERING";
        String sqlStrGuest = "SELECT * FROM guestRoom WHERE idRoom = ";
        ArrayList guestIdRooms = new ArrayList();
        CqlStatementResult result = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(sqlStr).execute().getResult();
        Rows riga = result.getRows(ColumnFamily.newColumnFamily((String)"chatroom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        ColumnFamily guest_room = ColumnFamily.newColumnFamily((String)"guestRoom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get());
        LiferayUserManager userManager = new LiferayUserManager();
        GCubeUser gCubeUser = null;
        for (Row longStringRow : riga) {
            chatRoom = new ChatRoom();
            ColumnList columns = longStringRow.getColumns();
            chatRoom.setIdRoom(columns.getLongValue((Object)"idroom", null).longValue());
            chatRoom.setRoomOwnerId(columns.getLongValue((Object)"roomownerid", null).longValue());
            chatRoom.setRoomOwner(columns.getStringValue((Object)"roomowner", null));
            chatRoom.setRoomOwnerFullName(columns.getStringValue((Object)"roomownerfullname", null));
            chatRoom.setNameRoom(columns.getStringValue((Object)"nameroom", null));
            OperationResult resultGuest = this.keyspace.prepareQuery(guest_room).withCql(sqlStrGuest + chatRoom.getIdRoom()).execute();
            for (Row rowGuest : ((CqlResult)resultGuest.getResult()).getRows()) {
                ColumnList columnsGuest = rowGuest.getColumns();
                guestRoom = new GuestRoom();
                guestRoom.setGuestId(columnsGuest.getLongValue((Object)"guestid", null).longValue());
                guestRoom.setIdRoom(columnsGuest.getLongValue((Object)"idroom", null).longValue());
                guestRoom.setGuestName(columnsGuest.getStringValue((Object)"guestname", null));
                guestRoom.setGuestFullName(columnsGuest.getStringValue((Object)"guestfullname", null));
                try {
                    gCubeUser = userManager.getUserById(guestRoom.getGuestId());
                }
                catch (UserManagementSystemException e) {
                    e.printStackTrace();
                }
                catch (UserRetrievalFault userRetrievalFault) {
                    userRetrievalFault.printStackTrace();
                }
                if (gCubeUser != null) {
                    guestRoom.setUrlAvatar(gCubeUser.getUserAvatarURL());
                } else {
                    guestRoom.setUrlAvatar("/image/user_male_portrait");
                }
                guestRooms.add(guestRoom);
                chatRoom.setGuestList(guestRooms);
            }
            chatRooms.add(chatRoom);
        }
        return chatRooms;
    }

    public List<ChatRoom> getRoomsFromGuest(long idUser) throws ConnectionException {
        ArrayList<ChatRoom> chatRooms = new ArrayList<ChatRoom>();
        ArrayList<GuestRoom> guestRooms = new ArrayList<GuestRoom>();
        ArrayList<Long> guestIdRooms = new ArrayList<Long>();
        GuestRoom guestRoom = null;
        String sqlIdRoom = "SELECT idRoom FROM guestroom WHERE guestId = " + idUser;
        String sqlStr = "SELECT * FROM chatroom WHERE idRoom = ";
        String sqlStrGuest = "SELECT * FROM guestRoom WHERE idRoom = ";
        CqlStatementResult result = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(sqlIdRoom).execute().getResult();
        Rows riga = result.getRows(ColumnFamily.newColumnFamily((String)"guestroom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : riga) {
            ColumnList columns = longStringRow.getColumns();
            guestIdRooms.add(columns.getLongValue((Object)"idroom", null));
        }
        ColumnFamily chat_room = ColumnFamily.newColumnFamily((String)"chatroom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get());
        ColumnFamily guest_room = ColumnFamily.newColumnFamily((String)"guestRoom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get());
        LiferayUserManager userManager = new LiferayUserManager();
        GCubeUser gCubeUser = null;
        for (Long guestIdRoom : guestIdRooms) {
            OperationResult result1 = this.keyspace.prepareQuery(chat_room).withCql(sqlStr + guestIdRoom).execute();
            ChatRoom chatRoom1 = new ChatRoom();
            for (Row row : ((CqlResult)result1.getResult()).getRows()) {
                ColumnList columns = row.getColumns();
                chatRoom1.setIdRoom(columns.getLongValue((Object)"idroom", null).longValue());
                chatRoom1.setRoomOwnerId(columns.getLongValue((Object)"roomownerid", null).longValue());
                chatRoom1.setRoomOwner(columns.getStringValue((Object)"roomowner", null));
                chatRoom1.setRoomOwnerFullName(columns.getStringValue((Object)"roomownerfullname", null));
                chatRoom1.setNameRoom(columns.getStringValue((Object)"nameroom", null));
                try {
                    gCubeUser = userManager.getUserById(chatRoom1.getRoomOwnerId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                chatRoom1.setOwnerUrlAvatar(gCubeUser.getUserAvatarURL());
                OperationResult resultGuest = this.keyspace.prepareQuery(guest_room).withCql(sqlStrGuest + guestIdRoom).execute();
                for (Row rowGuest : ((CqlResult)resultGuest.getResult()).getRows()) {
                    ColumnList columnsGuest = rowGuest.getColumns();
                    guestRoom = new GuestRoom();
                    guestRoom.setGuestId(columnsGuest.getLongValue((Object)"guestid", null).longValue());
                    guestRoom.setIdRoom(columnsGuest.getLongValue((Object)"idroom", null).longValue());
                    guestRoom.setGuestName(columnsGuest.getStringValue((Object)"guestname", null));
                    guestRoom.setGuestFullName(columnsGuest.getStringValue((Object)"guestfullname", null));
                    try {
                        gCubeUser = userManager.getUserById(guestRoom.getGuestId());
                    }
                    catch (UserManagementSystemException e) {
                        e.printStackTrace();
                    }
                    catch (UserRetrievalFault userRetrievalFault) {
                        userRetrievalFault.printStackTrace();
                    }
                    if (gCubeUser != null) {
                        guestRoom.setUrlAvatar(gCubeUser.getUserAvatarURL());
                    } else {
                        guestRoom.setUrlAvatar("/image/user_male_portrait");
                    }
                    guestRooms.add(guestRoom);
                    chatRoom1.setGuestList(guestRooms);
                }
                chatRooms.add(chatRoom1);
            }
        }
        return chatRooms;
    }

    public long createRoom(long idUser, ChatRoom chatRoom) throws ConnectionException {
        long ownerId = chatRoom.getRoomOwnerId();
        String ownerName = chatRoom.getRoomOwner();
        String ownerFullName = chatRoom.getRoomOwnerFullName();
        String roomName = chatRoom.getNameRoom();
        IncrementIndexMessage incrementIndexMessage = new IncrementIndexMessage(this.keyspace);
        long idRoom = incrementIndexMessage.incrementRoom();
        this.keyspace.prepareCqlStatement().withCql("INSERT INTO chatroom  (idRoom, roomOwner, roomOwnerFullName, roomOwnerId, nameRoom, active )  VALUES (" + idRoom + " , " + "'" + ownerName + "'," + "'" + ownerFullName + "'," + ownerId + "," + "'" + roomName + "'," + " true " + ");").execute();
        List guestList = chatRoom.getGuestList();
        for (GuestRoom guestRoom : guestList) {
            this.keyspace.prepareCqlStatement().withCql("INSERT INTO guestRoom (idRoom, guestId, guestName, guestFullName ) VALUES  (" + idRoom + " , " + "" + guestRoom.getGuestId() + "," + "'" + guestRoom.getGuestName() + "'," + "'" + guestRoom.getGuestFullName() + "'" + ");").execute();
        }
        return idRoom;
    }

    public List<ChatMessages> searchMessages(String string, long idChatroom) throws ConnectionException {
        ArrayList<ChatMessages> listOfMessages = new ArrayList<ChatMessages>();
        char ch = '\"';
        String sqlStrMessage = "";
        string = string.trim();
        String tmpString = ch + string + ch;
        sqlStrMessage = string.contains(" ") ? " SELECT * FROM chatmessage WHERE lucene='{query :{type:\"phrase\",field:\"message\",value:" + tmpString + ",slop:1 } }' AND idchatroom = " + idChatroom : " SELECT * FROM chatmessage WHERE lucene='{query :{type:\"prefix\",field:\"message\",value:" + tmpString + ",slop:1 } }' AND idchatroom = " + idChatroom;
        System.out.println("sqlStrMessage " + sqlStrMessage);
        CqlStatementResult result = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(sqlStrMessage).execute().getResult();
        Rows riga = result.getRows(ColumnFamily.newColumnFamily((String)"chatmessage", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : riga) {
            ColumnList columns = longStringRow.getColumns();
            ChatMessages chatMessage = new ChatMessages();
            chatMessage.setMessage(columns.getStringValue((Object)"message", null));
            chatMessage.setSenderId(columns.getLongValue((Object)"senderid", null).longValue());
            chatMessage.setIdChatRoom(columns.getLongValue((Object)"idchatroom", null).longValue());
            chatMessage.setDateTime(columns.getLongValue((Object)"datetime", null).longValue());
            chatMessage.setAttached(columns.getStringValue((Object)"attached", null));
            chatMessage.setAttachedType(columns.getStringValue((Object)"attachedtype", null));
            chatMessage.setIdMessage(columns.getLongValue((Object)"idmessage", null).longValue());
            chatMessage.setReadMessage(columns.getBooleanValue((Object)"readmessage", null).booleanValue());
            chatMessage.setSender(columns.getStringValue((Object)"sender", null));
            listOfMessages.add(chatMessage);
        }
        return listOfMessages;
    }

    public List<UsersChat> getUserFromRoom(long idRoom) throws ConnectionException {
        UsersChat user;
        ArrayList<UsersChat> usersChats = new ArrayList<UsersChat>();
        String strChatRoom = "SELECT  * FROM chatroom WHERE idroom=" + idRoom;
        String sqlStrGuest = "SELECT * FROM guestRoom WHERE idRoom = " + idRoom;
        CqlStatementResult result = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(strChatRoom).execute().getResult();
        Rows riga = result.getRows(ColumnFamily.newColumnFamily((String)"chatroom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : riga) {
            ColumnList columns = longStringRow.getColumns();
            user = new UsersChat();
            user.setId(columns.getLongValue((Object)"roomownerid", null).longValue());
            user.setUserName(columns.getStringValue((Object)"roomowner", null));
            user.setFullName(columns.getStringValue((Object)"roomownerfullname", null));
            user.setUrlAvatar("");
            usersChats.add(user);
        }
        CqlStatementResult result1 = (CqlStatementResult)this.keyspace.prepareCqlStatement().withCql(sqlStrGuest).execute().getResult();
        Rows riga1 = result1.getRows(ColumnFamily.newColumnFamily((String)"guestRoom", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get()));
        for (Row longStringRow : riga1) {
            ColumnList columns1 = longStringRow.getColumns();
            user = new UsersChat();
            user.setId(columns1.getLongValue((Object)"guestid", null).longValue());
            user.setUserName(columns1.getStringValue((Object)"guestname", null));
            user.setFullName(columns1.getStringValue((Object)"guestfullname", null));
            user.setUrlAvatar("");
            usersChats.add(user);
        }
        return usersChats;
    }
}

