-- LONG <- BIGINT

-- TABLES

create table BroodstockQuality (
	id BIGINT not null primary key,
	aa INTEGER,
	designation VARCHAR(75) null
);

create table CurrentRating (
	id BIGINT not null primary key,
	aa INTEGER,
	designation VARCHAR(75) null
);

create table FeedQuality (
	id BIGINT not null primary key,
	aa INTEGER,
	designation VARCHAR(75) null
);

create table OxygenRating (
	id BIGINT not null primary key,
	aa INTEGER,
	designation VARCHAR(75) null
);

create table Region (
	id BIGINT not null primary key,
	designation VARCHAR(75) null
);

create table Fcr (
	id BIGINT not null primary key,
	userId VARCHAR(30),
	simulModelId BIGINT,
	temperature INTEGER,
	fromWeight DOUBLE PRECISION,
	value DOUBLE PRECISION,
	index INTEGER
);

create table Mortality (
	id BIGINT not null primary key,
	userId VARCHAR(30),
	simulModelId BIGINT,
	temperature INTEGER,
	fromWeight DOUBLE PRECISION,
	value DOUBLE PRECISION,
	index INTEGER
);

create table Scenario (
	id BIGINT not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	comments TEXT null,
	simulModelId BIGINT,
	startDate DATE null,
	fishNo INTEGER,
	weight DOUBLE PRECISION,
	targetDate DATE null,
	resultsWeight DOUBLE PRECISION,
	resultsGrowth DOUBLE PRECISION,
	resultsEconFCR DOUBLE PRECISION,
	resultsBiolFCR DOUBLE PRECISION,
	resultsSGR DOUBLE PRECISION,
	resultsMortality DOUBLE PRECISION,
	resultsGraphData TEXT null
);


create table Sfr (
	id BIGINT not null primary key,
	userId VARCHAR(30),
	simulModelId BIGINT,
	temperature INTEGER,
	fromWeight DOUBLE PRECISION,
	value DOUBLE PRECISION,
	index INTEGER
);

create table Sgr (
	id BIGINT not null primary key,
	userId VARCHAR(30),
	simulModelId BIGINT,
	temperature INTEGER,
	fromWeight DOUBLE PRECISION,
	value DOUBLE PRECISION,
	index INTEGER
);

create table SimulModel (
	id BIGINT not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	comments TEXT null,
	speciesId BIGINT,
	siteId BIGINT,
	broodstockQualityId BIGINT,
	broodstockGeneticImprovement BOOLEAN,
	feedQualityId BIGINT,
	uploadFilename1 VARCHAR(100),
	uploadFilename2 VARCHAR(100),
	uploadFilename3 VARCHAR(100),
	uploadFilename4 VARCHAR(100)
);


create table Site (
	id BIGINT not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null,
	periodJanA INTEGER,
	periodJanB INTEGER,
	periodFebA INTEGER,
	periodFebB INTEGER,
	periodMarA INTEGER,
	periodMarB INTEGER,
	periodAprA INTEGER,
	periodAprB INTEGER,
	periodMayA INTEGER,
	periodMayB INTEGER,
	periodJunA INTEGER,
	periodJunB INTEGER,
	periodJulA INTEGER,
	periodJulB INTEGER,
	periodAugA INTEGER,
	periodAugB INTEGER,
	periodSepA INTEGER,
	periodSepB INTEGER,
	periodOctA INTEGER,
	periodOctB INTEGER,
	periodNovA INTEGER,
	periodNovB INTEGER,
	periodDecA INTEGER,
	periodDecB INTEGER,
	oxygenRatingId BIGINT,
	currentRatingId BIGINT,
	regionId BIGINT
);

create table Species (
	id BIGINT not null primary key,
	userId VARCHAR(30),
	designation VARCHAR(75) null
);

-- VIEWS

drop view SimulModelFullView;
create view SimulModelFullView as (
select 
	sm.*,
	sp.designation as speciesDesignation,
	si.designation as siteDesignation,
	bq.designation as broodstockQualityDesignation,
	fq.designation as feedQualityDesignation
from 
	SimulModel sm
	join Species sp on (sm.speciesId=sp.id)
	join Site si on (sm.siteId=si.id)
	join BroodstockQuality bq on (sm.broodstockQualityId=bq.id)
	join FeedQuality fq on (sm.feedQualityId=fq.id)
);

drop view ScenarioFullView;
create view ScenarioFullView as (
select 
	sn.*,
	sm.designation as simulModelDesignation
from 
	Scenario sn
	join SimulModel sm on (sn.simulModelId=sm.id)
);

drop view SiteFullView;
create view SiteFullView as (
select 
	si.*,
	rg.designation as regionDesignation,
	oxr.designation as oxygenRatingDesignation,
	cr.designation as currentRatingDesignation
from 
	Site si
	join Region rg on (si.regionId=rg.id)
	join OxygenRating oxr on (si.oxygenRatingId=oxr.id)
	join CurrentRating cr on (si.currentRatingId=cr.id)
);

