package gr.i2s.bluebridge.simul.model.util;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.model.Site;
import gr.i2s.bluebridge.simul.util2.HibernateUtil;

public class SiteUtil {
	public static void add(Site site) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.save(site);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void update(Site site) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.update(site);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void delete(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Site site = (Site) session.get(Site.class, Long.valueOf(id));

			if (site != null) {
				session.delete(site);

				session.flush();
			}

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static Site getSite(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Site site = (Site) session.get(Site.class, Long.valueOf(id));

			session.getTransaction().commit();

			return site;
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getSites(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getSiteFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return SiteFulls %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	private static final String _GET_ALL_ON_USERID = "FROM gr.i2s.bluebridge.simul.model.Site s WHERE s.userId = :userid ORDER BY s.designation ASC";
	private static Log logger = LogFactoryUtil.getLog(SiteUtil.class);
}
