package gr.i2s.bluebridge.simul.model.util;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.model.Modeler;
import gr.i2s.bluebridge.simul.util2.HibernateUtil;

public class ModelerUtil {
	public static void add(Modeler modeler) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.save(modeler);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void update(Modeler modeler) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.update(modeler);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void delete(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Modeler modeler = (Modeler) session.get(Modeler.class, Long.valueOf(id));

			if (modeler != null) {
				session.delete(modeler);

				session.flush();
			}

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static Modeler getModeler(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			Modeler modeler = (Modeler) session.get(Modeler.class, Long.valueOf(id));

			session.getTransaction().commit();

			return modeler;
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getModelers(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getModelers"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return Modelers %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void cleanKPIs(long id, int idx) {
		if (logger.isTraceEnabled()) {
			logger.trace(String.format("clearing KPIs for model %s at ndex %s", id, idx));
		}
		// TODO denispyr restore functionality
		logger.error("Bypassing as I dont hwant to miss the data");
		if (false) {
			SfrUtil.deleteAll(id, idx);
			FcrUtil.deleteAll(id, idx);
			MortalityUtil.deleteAll(id, idx);
		}

	}

	private static final String _GET_ALL_ON_USERID = "FROM gr.i2s.bluebridge.simul.model.Modeler s WHERE s.userId = :userid ORDER BY s.designation ASC";
	private static Log logger = LogFactoryUtil.getLog(ModelerUtil.class);
}
