<%@ include file="/html/commons/inc.jsp"%>
<%@page import="com.liferay.portal.kernel.log.LogFactoryUtil"%>
<%@page import="com.liferay.portal.kernel.log.Log"%>
<%@page import="com.liferay.portal.kernel.util.ParamUtil"%>
<%@page import="gr.i2s.bluebridge.simul.model.util.ModelerFullUtil"%>
<%@page import="gr.i2s.bluebridge.simul.model.Modeler"%>
<%@page import="gr.i2s.bluebridge.simul.model.Species"%>
<%@page import="gr.i2s.bluebridge.simul.model.Site"%>
<%@page import="gr.i2s.bluebridge.simul.model.BroodstockQuality"%>
<%@page import="gr.i2s.bluebridge.simul.model.FeedQuality"%>
<%@page import="java.io.File"%>
<%@page import="com.google.common.io.Files"%>
<%@page import="com.google.common.base.Strings"%>

<%
	Log logger = LogFactoryUtil
			.getLog("gr.i2s.bluebridge.simul.portlet.jsp." + this.getClass().getSimpleName());
%>

<jsp:useBean id="specieList" type="java.util.ArrayList<Species>"
	scope="request" />
<jsp:useBean id="siteList" type="java.util.ArrayList<Site>"
	scope="request" />
<jsp:useBean id="broodstockQualityList"
	type="java.util.ArrayList<BroodstockQuality>" scope="request" />
<jsp:useBean id="feedQualityList"
	type="java.util.ArrayList<FeedQuality>" scope="request" />

<portlet:renderURL var="cancel">
	<portlet:param name="mvcPath" value="/html/modeler/view.jsp"></portlet:param>
</portlet:renderURL>
<portlet:actionURL name="save" var="addUrl"></portlet:actionURL>
<%
	Modeler entity = null;
	long id = ParamUtil.getLong(request, "id");
	logger.debug(String.format("trying to load [%s]", id));
	if (id > 0) {
		try {
			entity = ModelerFullUtil.getModelerFull(id);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	logger.debug(String.format("Edit-add [%s]", entity));
	final int maxDisplayFileLength = 20;
%>
<aui:form action="<%=addUrl%>" name="<porlet:namespace />fm"
	enctype="multipart/form-data" method="post">
	<aui:model-context bean="<%=entity%>" model="<%=Modeler.class%>" />
	<aui:fieldset>
		<aui:input name="id" type="hidden" />
		<aui:input label="Name" name="designation" type="text" first="true"></aui:input>
		<aui:input label="Comments" name="comments" type="textarea" rows="3"
			cols="30"></aui:input>
		<aui:select label="Species" name="speciesId" id="speciesId">
			<%
				for (Species item : specieList) {
			%>
			<aui:option
				selected="<%=item.getId() == (entity == null ? 0L : entity.getSpeciesId())%>"
				value="<%=item.getId()%>"><%=item.getDesignation()%></aui:option>
			<%
				}
			%>
		</aui:select>
		<aui:select label="Site" name="siteId" id="siteId">
			<%
				for (Site item : siteList) {
			%>
			<aui:option
				selected="<%=item.getId() == (entity == null ? 0L : entity.getSiteId())%>"
				value="<%=item.getId()%>"><%=item.getDesignation()%></aui:option>
			<%
				}
			%>
		</aui:select>
		<aui:select label="Broodstock Quality" name="broodstockQualityId"
			id="broodstockQualityId">
			<%
				for (BroodstockQuality item : broodstockQualityList) {
			%>
			<aui:option
				selected="<%=item.getId() == (entity == null ? 0L : entity.getBroodstockQualityId())%>"
				value="<%=item.getId()%>"><%=item.getDesignation()%></aui:option>
			<%
				}
			%>
		</aui:select>
		<aui:input type="checkbox" label="Broodstock Genetic Improvement"
			name="broodstockGeneticImprovement" id="broodstockGeneticImprovement"
			checked="<%=(entity == null ? false : entity.isBroodstockGeneticImprovement())%>">
		</aui:input>
		<aui:select label="Feed Quality" name="feedQualityId"
			id="feedQualityId">
			<%
				for (FeedQuality item : feedQualityList) {
			%>
			<aui:option
				selected="<%=item.getId() == (entity == null ? 0L : entity.getFeedQualityId())%>"
				value="<%=item.getId()%>"><%=item.getDesignation()%></aui:option>
			<%
				}
			%>
		</aui:select>

		<aui:fieldset label="Upload datasets">
				Please note that the modeler will remove the KPIs that it produce based on the the files that you replace by other files or delete entirely.
				<hr />
			<aui:fieldset>
				<aui:column>
					<aui:select label="" name="fileUploadAction1">
						<%
							if (Strings.isNullOrEmpty(entity.getUploadFilename1())) {
						%>
						<aui:option value="keep" label="do not upload a file" />
						<aui:option value="replace" label="upload new file:"
							selected="true" />
						<%
							} else {
														String compactFilename = entity.getUploadFilename1();
														int length = compactFilename.length();
														if (length > maxDisplayFileLength) {
															length = maxDisplayFileLength; //truncate
															String ext = Files.getFileExtension(compactFilename);
															String name = Files.getNameWithoutExtension(compactFilename);
															if (!Strings.isNullOrEmpty(ext)) {
																length = length - ext.length(); //mind the dot
																length--; //the dot
															}
															length--; // the ellipsis
															compactFilename = name.substring(0, length) + "&hellip;";
															if (!Strings.isNullOrEmpty(ext)) {
																compactFilename = compactFilename + "." + ext;
															}
														}
						%>
						<aui:option value="keep"
							label="<%=String.format(\"keep `%s`\", compactFilename)%>"
							selected="true" />
						<aui:option value="replace"
							label="<%=String.format(\"replace `%s with`\", compactFilename)%>" />
						<aui:option value="delete"
							label="<%=String.format(\"delete `%s`\", compactFilename)%>" />
						<%
							}
						%>
					</aui:select>
					<aui:select label="" name="fileUploadAction2">
						<%
							if (Strings.isNullOrEmpty(entity.getUploadFilename2())) {
						%>
						<aui:option value="keep" label="do not upload a file" />
						<aui:option value="replace" label="upload new file:"
							selected="true" />
						<%
							} else {
														String compactFilename = entity.getUploadFilename2();
														int length = compactFilename.length();
														if (length > maxDisplayFileLength) {
															length = maxDisplayFileLength; //truncate
															String ext = Files.getFileExtension(compactFilename);
															String name = Files.getNameWithoutExtension(compactFilename);
															if (!Strings.isNullOrEmpty(ext)) {
																length = length - ext.length(); //mind the dot
																length--; //the dot
															}
															length--; // the ellipsis
															compactFilename = name.substring(0, length) + "&hellip;";
															if (!Strings.isNullOrEmpty(ext)) {
																compactFilename = compactFilename + "." + ext;
															}
														}
						%>
						<aui:option value="keep"
							label="<%=String.format(\"keep `%s`\", compactFilename)%>"
							selected="true" />
						<aui:option value="replace"
							label="<%=String.format(\"replace `%s` with\", compactFilename)%>" />
						<aui:option value="delete"
							label="<%=String.format(\"delete `%s`\", compactFilename)%>" />
						<%
							}
						%>
					</aui:select>
					<aui:select label="" name="fileUploadAction3">
						<%
							if (Strings.isNullOrEmpty(entity.getUploadFilename3())) {
						%>
						<aui:option value="keep" label="do not upload a file" />
						<aui:option value="replace" label="upload new file:"
							selected="true" />
						<%
							} else {
														String compactFilename = entity.getUploadFilename3();
														int length = compactFilename.length();
														if (length > maxDisplayFileLength) {
															length = maxDisplayFileLength; //truncate
															String ext = Files.getFileExtension(compactFilename);
															String name = Files.getNameWithoutExtension(compactFilename);
															if (!Strings.isNullOrEmpty(ext)) {
																length = length - ext.length(); //mind the dot
																length--; //the dot
															}
															length--; // the ellipsis
															compactFilename = name.substring(0, length) + "&hellip;";
															if (!Strings.isNullOrEmpty(ext)) {
																compactFilename = compactFilename + "." + ext;
															}
														}
						%>
						<aui:option value="keep"
							label="<%=String.format(\"keep `%s`\", compactFilename)%>"
							selected="true" />
						<aui:option value="replace"
							label="<%=String.format(\"replace `%s` with \", compactFilename)%>" />
						<aui:option value="delete"
							label="<%=String.format(\"delete `%s`\", compactFilename)%>" />
						<%
							}
						%>
					</aui:select>
					<aui:select label="" name="fileUploadAction4">
						<%
							if (Strings.isNullOrEmpty(entity.getUploadFilename4())) {
						%>
						<aui:option value="keep" label="do not upload a file" />
						<aui:option value="replace" label="upload new file:"
							selected="true" />
						<%
							} else {
														String compactFilename = entity.getUploadFilename4();
														int length = compactFilename.length();
														if (length > maxDisplayFileLength) {
															length = maxDisplayFileLength; //truncate
															String ext = Files.getFileExtension(compactFilename);
															String name = Files.getNameWithoutExtension(compactFilename);
															if (!Strings.isNullOrEmpty(ext)) {
																length = length - ext.length(); //mind the dot
																length--; //the dot
															}
															length--; // the ellipsis
															compactFilename = name.substring(0, length) + "&hellip;";
															if (!Strings.isNullOrEmpty(ext)) {
																compactFilename = compactFilename + "." + ext;
															}
														}
						%>
						<aui:option value="keep"
							label="<%=String.format(\"keep `%s`\", compactFilename)%>"
							selected="true" />
						<aui:option value="replace"
							label="<%=String.format(\"replace `%s` with\", compactFilename)%>" />
						<aui:option value="delete"
							label="<%=String.format(\"delete `%s`\", compactFilename)%>" />
						<%
							}
						%>
					</aui:select>
				</aui:column>
				<aui:column>
					<aui:input label="" type="file" name="fileUpload1" id="fileUpload1" />
					<aui:input label="" type="file" name="fileUpload2" id="fileUpload2" />
					<aui:input label="" type="file" name="fileUpload3" id="fileUpload3" />
					<aui:input label="" type="file" name="fileUpload4" id="fileUpload4" />
				</aui:column>
			</aui:fieldset>
		</aui:fieldset>
	</aui:fieldset>

	<aui:button-row cssClass="simul-button">
		<aui:button onClick="<%=cancel.toString()%>" value="Cancel"></aui:button>
		<aui:button type="submit" value="Save and Generate Model"></aui:button>
	</aui:button-row>

</aui:form>

