/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsf.services.jaxrs.resource;

import gr.forth.ics.isl.grsf.services.jaxrs.resource.RequestInfo;
import gr.forth.ics.isl.grsf.services.model.CatalogInfoBean;
import gr.forth.ics.isl.grsf.services.model.InfoResponseCreationBean;
import gr.forth.ics.isl.grsf.services.model.RevertRequestBody;
import gr.forth.ics.isl.grsf.services.model.TriplestoreBean;
import gr.forth.ics.isl.grsfservicescore.CatalogScope;
import gr.forth.ics.isl.grsfservicescore.gCubeConnector;
import gr.forth.ics.isl.grsfservicescore.grsfkb.DatabaseSource;
import gr.forth.ics.isl.grsfservicescore.triplestore.TripleStoreUpdater;
import gr.forth.ics.isl.grsfservicescore.triplestore.VirtuosoTripleStoreConnector;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Path(value="/info")
public class RequestInfo {
    private static final Logger log = Logger.getLogger(RequestInfo.class);
    private final TripleStoreUpdater triplestoreUpdater;
    private final DatabaseSource grsfDatabaseSource;
    private final String mergingNamedgraph;

    public RequestInfo() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");
        this.triplestoreUpdater = new TripleStoreUpdater((VirtuosoTripleStoreConnector)context.getBean("virtuosoConnector", VirtuosoTripleStoreConnector.class));
        this.grsfDatabaseSource = (DatabaseSource)context.getBean("DatabaseSource-GRSF", DatabaseSource.class);
        this.mergingNamedgraph = (String)context.getBean("Merging-namedgraph", String.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get")
    public Response postRequest(RevertRequestBody request) {
        log.info((Object)"Received incoming info request");
        InfoResponseCreationBean responseBean = new InfoResponseCreationBean();
        Response.Status status = Response.Status.OK;
        responseBean = this.getServiceInfo(responseBean);
        responseBean = this.getTripleStoreInfo(responseBean);
        responseBean = this.getCatalogInfo(responseBean);
        log.info((Object)("Info Status/Response: " + status + " / " + responseBean));
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    private InfoResponseCreationBean getServiceInfo(InfoResponseCreationBean responseBean) {
        log.debug((Object)"Retrieving information about the service name and vesion");
        responseBean.setName("grsf-services-updater");
        responseBean.setVersion("1.3.0");
        responseBean.setDocumentation("https://app.swaggerhub.com/apis/ymark/grsf-services-updater/1.3.0");
        return responseBean;
    }

    private InfoResponseCreationBean getTripleStoreInfo(InfoResponseCreationBean responseBean) {
        log.debug((Object)"Retrieving information about the triplestore");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");
        VirtuosoTripleStoreConnector tripleStoreConnector = (VirtuosoTripleStoreConnector)context.getBean("virtuosoConnector", VirtuosoTripleStoreConnector.class);
        responseBean.setTriplestore(new TriplestoreBean(tripleStoreConnector.getHost(), tripleStoreConnector.getPort()));
        return responseBean;
    }

    private InfoResponseCreationBean getCatalogInfo(InfoResponseCreationBean responseBean) {
        log.debug((Object)"Retrieving information about the catalog");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");
        CatalogScope scope = (CatalogScope)context.getBean("updateClient_scope_bean", CatalogScope.class);
        switch (1.$SwitchMap$gr$forth$ics$isl$grsfservicescore$CatalogScope[scope.ordinal()]) {
            case 1: {
                gCubeConnector connector = (gCubeConnector)context.getBean("gCubeConnector-Admin", gCubeConnector.class);
                responseBean.setCatalogInfo(new CatalogInfoBean(connector.getServiceEndpoint(), scope));
                break;
            }
            case 2: {
                gCubeConnector connector = (gCubeConnector)context.getBean("gCubeConnector-Public", gCubeConnector.class);
                responseBean.setCatalogInfo(new CatalogInfoBean(connector.getServiceEndpoint(), scope));
                break;
            }
            case 3: {
                gCubeConnector connector = (gCubeConnector)context.getBean("gCubeConnector-Test", gCubeConnector.class);
                responseBean.setCatalogInfo(new CatalogInfoBean(connector.getServiceEndpoint(), scope));
                break;
            }
            case 4: {
                responseBean.setCatalogInfo(new CatalogInfoBean("N/A", scope));
            }
        }
        return responseBean;
    }
}

