/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsf.services.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.JsonObject;
import gr.forth.ics.isl.grsf.services.exceptions.RequestBodyException;
import gr.forth.ics.isl.grsfservicescore.model.ControlledVocabularies;
import org.apache.log4j.Logger;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Connection {
    private static final Logger log = Logger.getLogger(Connection.class);
    @JsonProperty(value="source_knowledge_base_id")
    private String sourceKnowledgeBaseId;
    @JsonProperty(value="dest_knowledge_base_id")
    private String destKnowledgeBaseId;
    @JsonProperty(value="source_domain")
    private ControlledVocabularies.ResourceType sourceDomain;
    @JsonProperty(value="remove")
    private boolean toBeRemoved;

    public void setSourceDomain(String sourceDomain) throws RequestBodyException {
        log.debug((Object)("Defining the type of the source domain with string value: " + sourceDomain));
        if (sourceDomain.equalsIgnoreCase(ControlledVocabularies.ResourceType.STOCK.name())) {
            this.sourceDomain = ControlledVocabularies.ResourceType.STOCK;
        } else if (sourceDomain.equalsIgnoreCase(ControlledVocabularies.ResourceType.FISHERY.name())) {
            this.sourceDomain = ControlledVocabularies.ResourceType.FISHERY;
        } else {
            String msg = "Undefined value for the source domain. Only the following are allowed: [" + ControlledVocabularies.ResourceType.STOCK + ", " + ControlledVocabularies.ResourceType.FISHERY + "]";
            log.error((Object)msg);
            throw new RequestBodyException(msg);
        }
        log.debug((Object)("Source domain is of type: " + this.sourceDomain));
    }

    public void validateRequestBean() throws RequestBodyException {
        if (this.sourceKnowledgeBaseId.isEmpty()) {
            throw new RequestBodyException("Empty value for the field source_knowledge_base_id (found in connections)");
        }
        if (this.destKnowledgeBaseId.isEmpty()) {
            throw new RequestBodyException("Empty value for the field dest_knowledge_base_id (found in connections)");
        }
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("source_knowledge_base_id", this.getSourceKnowledgeBaseId());
        jsonObject.addProperty("dest_knowledge_base_id", this.getDestKnowledgeBaseId());
        jsonObject.addProperty("connect", Boolean.valueOf(this.isToBeRemoved()));
        return jsonObject;
    }

    public String getSourceKnowledgeBaseId() {
        return this.sourceKnowledgeBaseId;
    }

    public String getDestKnowledgeBaseId() {
        return this.destKnowledgeBaseId;
    }

    public ControlledVocabularies.ResourceType getSourceDomain() {
        return this.sourceDomain;
    }

    public boolean isToBeRemoved() {
        return this.toBeRemoved;
    }

    public void setSourceKnowledgeBaseId(String sourceKnowledgeBaseId) {
        this.sourceKnowledgeBaseId = sourceKnowledgeBaseId;
    }

    public void setDestKnowledgeBaseId(String destKnowledgeBaseId) {
        this.destKnowledgeBaseId = destKnowledgeBaseId;
    }

    public void setToBeRemoved(boolean toBeRemoved) {
        this.toBeRemoved = toBeRemoved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$sourceKnowledgeBaseId = this.getSourceKnowledgeBaseId();
        String other$sourceKnowledgeBaseId = other.getSourceKnowledgeBaseId();
        if (this$sourceKnowledgeBaseId == null ? other$sourceKnowledgeBaseId != null : !this$sourceKnowledgeBaseId.equals(other$sourceKnowledgeBaseId)) {
            return false;
        }
        String this$destKnowledgeBaseId = this.getDestKnowledgeBaseId();
        String other$destKnowledgeBaseId = other.getDestKnowledgeBaseId();
        if (this$destKnowledgeBaseId == null ? other$destKnowledgeBaseId != null : !this$destKnowledgeBaseId.equals(other$destKnowledgeBaseId)) {
            return false;
        }
        ControlledVocabularies.ResourceType this$sourceDomain = this.getSourceDomain();
        ControlledVocabularies.ResourceType other$sourceDomain = other.getSourceDomain();
        if (this$sourceDomain == null ? other$sourceDomain != null : !this$sourceDomain.equals(other$sourceDomain)) {
            return false;
        }
        return this.isToBeRemoved() == other.isToBeRemoved();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Connection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourceKnowledgeBaseId = this.getSourceKnowledgeBaseId();
        result = result * 59 + ($sourceKnowledgeBaseId == null ? 43 : $sourceKnowledgeBaseId.hashCode());
        String $destKnowledgeBaseId = this.getDestKnowledgeBaseId();
        result = result * 59 + ($destKnowledgeBaseId == null ? 43 : $destKnowledgeBaseId.hashCode());
        ControlledVocabularies.ResourceType $sourceDomain = this.getSourceDomain();
        result = result * 59 + ($sourceDomain == null ? 43 : $sourceDomain.hashCode());
        result = result * 59 + (this.isToBeRemoved() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Connection(sourceKnowledgeBaseId=" + this.getSourceKnowledgeBaseId() + ", destKnowledgeBaseId=" + this.getDestKnowledgeBaseId() + ", sourceDomain=" + this.getSourceDomain() + ", toBeRemoved=" + this.isToBeRemoved() + ")";
    }
}

