/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsf.services.jaxrs.resource;

import com.google.common.collect.Multimap;
import gr.forth.ics.isl.grsf.services.exceptions.RequestBodyException;
import gr.forth.ics.isl.grsf.services.model.RevertRequestBody;
import gr.forth.ics.isl.grsf.services.model.RevertResponseCreationBean;
import gr.forth.ics.isl.grsfservicescore.CatalogScope;
import gr.forth.ics.isl.grsfservicescore.Common;
import gr.forth.ics.isl.grsfservicescore.clients.SearchClientLight;
import gr.forth.ics.isl.grsfservicescore.clients.UpdateClient;
import gr.forth.ics.isl.grsfservicescore.exception.GrsfPublishingException;
import gr.forth.ics.isl.grsfservicescore.exception.SearchException;
import gr.forth.ics.isl.grsfservicescore.exception.UuidGenerationException;
import gr.forth.ics.isl.grsfservicescore.exception.VirtuosoConnectorException;
import gr.forth.ics.isl.grsfservicescore.grsfkb.DatabaseSource;
import gr.forth.ics.isl.grsfservicescore.model.ControlledVocabularies;
import gr.forth.ics.isl.grsfservicescore.model.Record;
import gr.forth.ics.isl.grsfservicescore.triplestore.TripleStoreUpdater;
import gr.forth.ics.isl.grsfservicescore.triplestore.VirtuosoTripleStoreConnector;
import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.log4j.Logger;
import org.openrdf.repository.RepositoryException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Path(value="/revert")
public class RevertMerge {
    private static final Logger log = Logger.getLogger(RevertMerge.class);
    private final TripleStoreUpdater triplestoreUpdater;
    private final DatabaseSource grsfDatabaseSource;
    private final String mergingNamedgraph;
    private final ApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");

    public RevertMerge() {
        this.triplestoreUpdater = new TripleStoreUpdater((VirtuosoTripleStoreConnector)this.context.getBean("virtuosoConnector", VirtuosoTripleStoreConnector.class));
        this.grsfDatabaseSource = (DatabaseSource)this.context.getBean("DatabaseSource-GRSF", DatabaseSource.class);
        this.mergingNamedgraph = (String)this.context.getBean("Merging-namedgraph", String.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/post")
    public Response postRequest(RevertRequestBody request) {
        log.info((Object)("Received incoming request " + request.toJson()));
        RevertResponseCreationBean responseBean = new RevertResponseCreationBean(request.getKnowledgeBaseId());
        Response.Status status = Response.Status.OK;
        try {
            request.validateRequestBean();
            String recordURI = this.triplestoreUpdater.getRecordUriUsingKnowledgeBaseUUID(request.getKnowledgeBaseId(), this.grsfDatabaseSource);
            log.debug((Object)("Retrieved record URI: " + recordURI));
            Multimap mergingEventURIs = this.triplestoreUpdater.fetchMergeEvents(recordURI, this.mergingNamedgraph);
            if (mergingEventURIs.isEmpty()) {
                log.error((Object)("There are no merging events initiated from the record with <URI, KB UUID>: <" + recordURI + ", " + request.getKnowledgeBaseId() + ">"));
                responseBean.prepareErrorResponse("There are no merging events initiated from the record KB UUID: " + request.getKnowledgeBaseId());
            } else {
                log.debug((Object)("Found merge event URIs: " + mergingEventURIs));
                this.cancelMergingEvents(recordURI, mergingEventURIs);
                responseBean.prepareSuccessResponse();
                this.updateRecords(mergingEventURIs.values());
            }
        }
        catch (RequestBodyException ex) {
            log.error((Object)"An error occured while validating the contens of the incoming request.", (Throwable)ex);
            responseBean.prepareErrorResponse(ex.getMessage());
            status = Response.Status.BAD_REQUEST;
        }
        catch (RepositoryException ex) {
            log.error((Object)"An error occured while connecting to the GRSF Knowledge Base repository.", (Throwable)ex);
            responseBean.prepareErrorResponse(ex.getMessage());
            status = Response.Status.BAD_REQUEST;
        }
        catch (GrsfPublishingException | SearchException | VirtuosoConnectorException ex) {
            log.error((Object)("An error occured while searching/updating the record with Knowledge Base UUID: " + request.getKnowledgeBaseId()), ex);
            responseBean.prepareErrorResponse(ex.getMessage());
            status = Response.Status.BAD_REQUEST;
        }
        catch (UuidGenerationException ex) {
            log.error((Object)("An error occured while republishing records in the resource catalog: " + request.getKnowledgeBaseId()), (Throwable)ex);
            responseBean.prepareErrorResponse(ex.getMessage());
            status = Response.Status.BAD_REQUEST;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    private void cancelMergingEvents(String recordUri, Multimap<String, String> mergingEventUris) throws VirtuosoConnectorException, RepositoryException, SearchException, GrsfPublishingException {
        log.debug((Object)("Remove the following merge events from the GRSF KB: " + mergingEventUris));
        this.triplestoreUpdater.removeMergeEvents((Collection)mergingEventUris.keySet(), this.mergingNamedgraph);
        Collection recordToBeUpdated = new SearchClientLight().fetchRecords(mergingEventUris.values());
        for (String uriToUpdate : mergingEventUris.values()) {
            log.debug((Object)("Update the status of the record with URI " + uriToUpdate + " event to " + ControlledVocabularies.ResourceStatus.PENDING));
            this.triplestoreUpdater.updateRecordStatus(uriToUpdate, this.grsfDatabaseSource, ControlledVocabularies.ResourceStatus.PENDING);
        }
        for (Record recordToUpdate : recordToBeUpdated) {
            log.debug((Object)("Update the cached JSON contents of the record with URI " + recordToUpdate.getRecordUri()));
            recordToUpdate.setResourceStatus(ControlledVocabularies.ResourceStatus.PENDING);
            this.triplestoreUpdater.updateRecordWithPublishedContents(recordToUpdate.getRecordUri(), Common.normalizeJsonString((String)recordToUpdate.toJson()), this.grsfDatabaseSource.getSourceGraphSpace(), true);
        }
    }

    private void updateRecords(Collection<String> recordUris) throws RepositoryException, UuidGenerationException, VirtuosoConnectorException {
        UpdateClient updateClient = new UpdateClient((CatalogScope)this.context.getBean("updateClient_scope_bean", CatalogScope.class), false);
        Collection uuidsAndTypes = this.triplestoreUpdater.fetchKbUuids(recordUris, this.grsfDatabaseSource.getSourceGraphSpace()).values();
        HashSet<Triple> recordsToBeUpdated = new HashSet<Triple>();
        for (Pair pair : uuidsAndTypes) {
            recordsToBeUpdated.add(Triple.of((Object)pair.getLeft(), (Object)pair.getRight(), (Object)ControlledVocabularies.ResourceStatus.PENDING));
        }
        log.info((Object)("There are " + recordsToBeUpdated.size() + " records to be updated"));
        updateClient.updateRecordStatuses(recordsToBeUpdated, this.grsfDatabaseSource);
    }
}

