/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsf.services.jaxrs.resource;

import gr.forth.ics.isl.grsf.services.Resources;
import gr.forth.ics.isl.grsf.services.exceptions.RequestBodyException;
import gr.forth.ics.isl.grsf.services.model.RequestBody;
import gr.forth.ics.isl.grsf.services.model.ResponseCreationBean;
import gr.forth.ics.isl.grsfservicescore.CatalogScope;
import gr.forth.ics.isl.grsfservicescore.Common;
import gr.forth.ics.isl.grsfservicescore.clients.DeletionsClient;
import gr.forth.ics.isl.grsfservicescore.clients.PublisherClient;
import gr.forth.ics.isl.grsfservicescore.clients.SearchClientLight;
import gr.forth.ics.isl.grsfservicescore.clients.UpdateClient;
import gr.forth.ics.isl.grsfservicescore.exception.GcubeServiceRetrieveException;
import gr.forth.ics.isl.grsfservicescore.exception.GrsfPublishingException;
import gr.forth.ics.isl.grsfservicescore.exception.SearchException;
import gr.forth.ics.isl.grsfservicescore.exception.UuidGenerationException;
import gr.forth.ics.isl.grsfservicescore.exception.VirtuosoConnectorException;
import gr.forth.ics.isl.grsfservicescore.grsfkb.DatabaseSource;
import gr.forth.ics.isl.grsfservicescore.model.ControlledVocabularies;
import gr.forth.ics.isl.grsfservicescore.model.FisheryRecord;
import gr.forth.ics.isl.grsfservicescore.model.Record;
import gr.forth.ics.isl.grsfservicescore.model.StockRecord;
import gr.forth.ics.isl.grsfservicescore.triplestore.TripleStoreUpdater;
import gr.forth.ics.isl.grsfservicescore.triplestore.VirtuosoTripleStoreConnector;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.openrdf.repository.RepositoryException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Path(value="/updater")
public class RequestBodyResource {
    private static final Logger log = Logger.getLogger(RequestBodyResource.class);
    private final TripleStoreUpdater triplestoreUpdater;
    private final DatabaseSource grsfDatabaseSource;
    private final String mergingNamedgraph;
    private final ApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");

    public RequestBodyResource() {
        this.triplestoreUpdater = new TripleStoreUpdater((VirtuosoTripleStoreConnector)this.context.getBean("virtuosoConnector", VirtuosoTripleStoreConnector.class));
        this.grsfDatabaseSource = (DatabaseSource)this.context.getBean("DatabaseSource-GRSF", DatabaseSource.class);
        this.mergingNamedgraph = (String)this.context.getBean("Merging-namedgraph", String.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/post")
    public Response postRequest(RequestBody body) {
        log.info((Object)("Received incoming request " + body.toJson()));
        ResponseCreationBean responseBean = new ResponseCreationBean(body.getCatalogId(), body.getKnowledgeBaseId());
        Response.Status status = Response.Status.OK;
        try {
            body.validateRequestBean();
            Record record = new SearchClientLight().fetchRecordUsingUUID(body.getKnowledgeBaseId());
            if (body.getGrsfTypeOld() != null & body.getGrsfTypeNew() != null) {
                body.validateRecordTypes(record.getResourceType());
            } else {
                log.debug((Object)"There is no information about the resource types in the request");
            }
            Map uuidsVsUrls = this.triplestoreUpdater.fetchCatalogUrlsFromUUIDs(body.fetchAllUUIDs());
            log.debug((Object)("Retrieved record: " + record.toJson()));
            boolean updatedRecords = this.updateRecord(record, body, uuidsVsUrls);
            boolean hasMergedRecords = this.mergeRecords(record, body);
            if (updatedRecords || hasMergedRecords) {
                log.info((Object)("The record (" + record.getRecordUri() + ") has updated information"));
                this.rePublishRecord(record);
                responseBean.prepareSuccessResponse(body.getNewStatus().toString(), body.getShortNameNew());
            } else {
                log.info((Object)("No updates for the record (" + record.getRecordUri() + ")"));
                responseBean.prepareNoModificationResponse(body.getNewStatus().toString(), body.getShortNameNew());
            }
        }
        catch (RequestBodyException ex) {
            log.error((Object)"An error occured while validating the contens of the incoming request.", (Throwable)ex);
            responseBean.prepareErrorResponse(ex.getMessage());
            status = Response.Status.BAD_REQUEST;
        }
        catch (RepositoryException ex) {
            log.error((Object)"An error occured while connecting to the GRSF Knowledge Base repository.", (Throwable)ex);
            responseBean.prepareErrorResponse(ex.getMessage());
            status = Response.Status.BAD_REQUEST;
        }
        catch (GrsfPublishingException | SearchException | UuidGenerationException | VirtuosoConnectorException ex) {
            log.error((Object)("An error occured while searching/updating the record with Knowledge Base UUID: " + body.getKnowledgeBaseId()), ex);
            responseBean.prepareErrorResponse(ex.getMessage());
            status = Response.Status.BAD_REQUEST;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    private boolean updateRecord(Record record, RequestBody requestBody, Map<String, String> uuidsVsUrls) throws VirtuosoConnectorException {
        boolean updateRecordStatus = this.updateRecordStatus(record, requestBody);
        log.debug((Object)("Update Record Status flag: " + updateRecordStatus));
        boolean updateRecordType = false;
        if (requestBody.getGrsfTypeOld() != null && requestBody.getGrsfTypeNew() != null) {
            updateRecordType = this.updateRecordType(record, requestBody);
            log.debug((Object)("Update Record Type flag: " + updateRecordType));
        } else {
            log.debug((Object)"There is no information about the resource types in the request");
        }
        boolean updateTraceabilityFlag = this.updateTraceabilityFlag(record, requestBody);
        log.debug((Object)("Update Traceability flag: " + updateTraceabilityFlag));
        boolean updateSdgFlag = this.updateSdgFlag(record, requestBody);
        log.debug((Object)("Update SDG flag: " + updateSdgFlag));
        boolean updateShortName = this.updateShortName(record, requestBody);
        log.debug((Object)("Update Short name flag: " + updateShortName));
        boolean updateAnnotation = this.updateAnnotation(record, requestBody);
        log.debug((Object)("Update Annotation flag: " + updateAnnotation));
        boolean updateConnections = this.updateConnections(record, requestBody, uuidsVsUrls);
        log.debug((Object)("Update Connections flag: " + updateConnections));
        return updateRecordStatus || updateRecordType || updateTraceabilityFlag || updateSdgFlag || updateShortName || updateAnnotation || updateConnections;
    }

    private boolean updateRecordStatus(Record record, RequestBody request) throws VirtuosoConnectorException {
        if (record.getResourceStatus() != request.getNewStatus()) {
            log.info((Object)("Updating the resource status of the record with URI: " + record.getRecordUri() + " from status: " + record.getResourceStatus() + " to status: " + request.getNewStatus()));
            record.setResourceStatus(request.getNewStatus());
            this.triplestoreUpdater.updateRecordStatus(record.getRecordUri(), this.grsfDatabaseSource, request.getNewStatus());
            return true;
        }
        log.debug((Object)("The resource status of the record (" + record.getRecordUri() + ") is NOT changed"));
        return false;
    }

    private boolean updateRecordType(Record record, RequestBody request) throws VirtuosoConnectorException {
        if (record.getResourceType() == ControlledVocabularies.ResourceType.STOCK) {
            StockRecord stockRecord = (StockRecord)record;
            if (stockRecord.getStockType() != ControlledVocabularies.getStockType((String)request.getGrsfTypeNew())) {
                log.info((Object)("Updating the type of the stock record with URI: " + stockRecord.getRecordUri() + " from type: " + stockRecord.getStockType() + " to status: " + ControlledVocabularies.getStockType((String)request.getGrsfTypeNew())));
                stockRecord.setStockType(ControlledVocabularies.getStockType((String)request.getGrsfTypeNew()));
                this.triplestoreUpdater.updateStockType(record.getRecordUri(), this.grsfDatabaseSource, ControlledVocabularies.getStockType((String)request.getGrsfTypeNew()));
                return true;
            }
            log.debug((Object)("The stock type of the record (" + record.getRecordUri() + ") is NOT changed"));
            return false;
        }
        FisheryRecord fisheryRecord = (FisheryRecord)record;
        if (fisheryRecord.getFisheryType() != ControlledVocabularies.getFisheryType((String)request.getGrsfTypeNew())) {
            log.info((Object)("Updating the type of the fishery record with URI: " + fisheryRecord.getRecordUri() + " from type: " + fisheryRecord.getFisheryType() + " to status: " + ControlledVocabularies.getStockType((String)request.getGrsfTypeNew())));
            fisheryRecord.setFisheryType(ControlledVocabularies.getFisheryType((String)request.getGrsfTypeNew()));
            this.triplestoreUpdater.updateFisheryType(record.getRecordUri(), this.grsfDatabaseSource, ControlledVocabularies.getFisheryType((String)request.getGrsfTypeNew()));
            return true;
        }
        log.debug((Object)("The fishery type of the record (" + record.getRecordUri() + ") is NOT changed"));
        return false;
    }

    private boolean updateTraceabilityFlag(Record record, RequestBody request) throws VirtuosoConnectorException {
        if (record.isTracebility() != request.isTraceable()) {
            log.info((Object)("Updating the traceability flag of the record with URI: " + record.getRecordUri() + " from " + record.isTracebility() + " to: " + request.isTraceable()));
            record.setTracebility(request.isTraceable());
            this.triplestoreUpdater.updateRecordTraceabilityFlag(record.getRecordUri(), this.grsfDatabaseSource, request.isTraceable());
            return true;
        }
        log.debug((Object)("The traceability flag of the record (" + record.getRecordUri() + ") is NOT changed"));
        return false;
    }

    private boolean updateSdgFlag(Record record, RequestBody request) throws VirtuosoConnectorException {
        if (record.isSdg() != request.isSdg()) {
            log.info((Object)("Updating the SDG flag of the record with URI: " + record.getRecordUri() + " from " + record.isSdg() + " to: " + request.isSdg()));
            record.setSdg(request.isSdg());
            this.triplestoreUpdater.updateRecordSdgFlag(record.getRecordUri(), this.grsfDatabaseSource, request.isSdg());
            return true;
        }
        log.debug((Object)("The SDG flag of the record (" + record.getRecordUri() + ") is NOT changed"));
        return false;
    }

    private boolean updateShortName(Record record, RequestBody request) throws VirtuosoConnectorException {
        if (!record.getShortName().equalsIgnoreCase(request.getShortNameNew())) {
            log.info((Object)("Updating the short name of the record with URI: " + record.getRecordUri() + " from " + record.getShortName() + " to: " + request.getShortNameNew()));
            record.setShortName(request.getShortNameNew());
            this.triplestoreUpdater.updateShortName(record.getRecordUri(), this.grsfDatabaseSource, request.getShortNameNew());
            return true;
        }
        log.debug((Object)("The short name of the record (" + record.getRecordUri() + ") is NOT changed"));
        log.debug((Object)("Old short name: " + record.getShortName() + " \t New short name: " + request.getShortNameNew()));
        return false;
    }

    private boolean updateAnnotation(Record record, RequestBody request) throws VirtuosoConnectorException {
        if (!request.getAnnotationMessage().isEmpty()) {
            log.info((Object)("Adding an annotation message for the record with URI: " + record.getRecordUri() + " using user " + request.getAdministratorName() + " and message: " + request.getAnnotationMessage()));
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdfDate.setTimeZone(TimeZone.getTimeZone("GMT+1"));
            String strDate = sdfDate.format(new Date()) + " CET";
            record.addAnnotationEvent(request.getAdministratorName(), request.getAnnotationMessage(), strDate);
            this.triplestoreUpdater.updateRecordAnnotationMessage(record.getRecordUri(), this.grsfDatabaseSource, request.getAnnotationMessage(), request.getAdministratorName(), strDate);
            return true;
        }
        log.debug((Object)("Annotation message for the record (" + record.getRecordUri() + ") does NOT exist"));
        return false;
    }

    private boolean updateConnections(Record record, RequestBody request, Map<String, String> uuidsVsUrls) throws VirtuosoConnectorException {
        record.addExploitedResources((Collection)record.getConnections());
        record.removeConnections((Collection)record.getConnections());
        if (request.hasUpdatedConnectionsToBeRemoved()) {
            Collection removeURLs = Resources.getValuesFromMap(uuidsVsUrls, (Collection)request.getConnectionsToBeRemoved());
            log.debug((Object)("Removing the following resources under exploited sources " + removeURLs));
            record.removeExploitedResources(removeURLs);
            this.triplestoreUpdater.removeExploitedResources(record.getRecordUri(), request.getConnectionsToBeRemoved(), this.grsfDatabaseSource.getSourceGraphSpace());
        }
        if (request.hasUpdatedConnectionsToBeConnected()) {
            Collection connectedURLs = Resources.getValuesFromMap(uuidsVsUrls, (Collection)request.getConnectionsToBeConnected());
            log.debug((Object)("Adding the following resources under connections " + connectedURLs));
            record.removeExploitedResources(connectedURLs);
            record.addConnections(connectedURLs);
        }
        return true;
    }

    private boolean mergeRecords(Record record, RequestBody request) throws VirtuosoConnectorException, RepositoryException, SearchException, GrsfPublishingException {
        if (!request.hasMergeEvents()) {
            log.info((Object)"There are NO merge events defined in the request. Nothing to do here.");
            return false;
        }
        log.info((Object)"There are merge events defined in the request.");
        Collection recordUrisToBeMerged = request.getSimilarRecordsToBeMerged();
        Collection recordsToBeMerged = new SearchClientLight().fetchRecordsUsingUUIDs(recordUrisToBeMerged);
        log.debug((Object)("The record with KB UUID: " + record.getUuid() + " will be merged with the following records: " + recordUrisToBeMerged));
        Collection urisToBeMerged = this.triplestoreUpdater.createMergeEvent(record.getRecordUri(), recordUrisToBeMerged, this.mergingNamedgraph);
        for (String recordUriToBeMerged : urisToBeMerged) {
            this.triplestoreUpdater.updateRecordStatus(recordUriToBeMerged, this.grsfDatabaseSource, ControlledVocabularies.ResourceStatus.TO_BE_MERGED);
        }
        for (Record recordToUpdate : recordsToBeMerged) {
            recordToUpdate.setResourceStatus(ControlledVocabularies.ResourceStatus.TO_BE_MERGED);
            this.triplestoreUpdater.updateRecordWithPublishedContents(recordToUpdate.getRecordUri(), Common.normalizeJsonString((String)recordToUpdate.toJson()), this.grsfDatabaseSource.getSourceGraphSpace(), true);
        }
        record.setResourceStatus(ControlledVocabularies.ResourceStatus.TO_BE_MERGED);
        return true;
    }

    private void rePublishRecord(Record record) throws RepositoryException, UuidGenerationException {
        UpdateClient updateClient = new UpdateClient((CatalogScope)this.context.getBean("updateClient_scope_bean", CatalogScope.class), false);
        updateClient.reportConnectionDetails();
        log.debug((Object)("Re-Publishing record " + record.toJson()));
        updateClient.updateRecords(Arrays.asList(record), this.grsfDatabaseSource);
    }

    private void publishRecord(Record record) throws RepositoryException, GcubeServiceRetrieveException, UuidGenerationException {
        PublisherClient publisherClient = new PublisherClient((CatalogScope)this.context.getBean("publishClient_scope_bean", CatalogScope.class));
        publisherClient.reportConnectionDetails();
        log.debug((Object)("Publishing record " + record.toJson()));
        publisherClient.publishRecords(Arrays.asList(record), this.grsfDatabaseSource);
    }

    private void removeRecord(Record record) throws RepositoryException {
        DeletionsClient deletionsClient = new DeletionsClient((CatalogScope)this.context.getBean("publishClient_scope_bean", CatalogScope.class));
        deletionsClient.reportConnectionDetails();
        log.debug((Object)("Removing record with KB UUID " + record.getUuid()));
        deletionsClient.deleteProductsMultiThread(record.getResourceType(), DatabaseSource.GrsfSource.GRSF, true, true);
    }

    private boolean publishInPublicVre(RequestBody request) {
        return request.getNewStatus() == ControlledVocabularies.ResourceStatus.APPROVED;
    }

    private boolean unpublishFromPublicCatalog(RequestBody request) {
        return request.getOldStatus() == ControlledVocabularies.ResourceStatus.APPROVED && request.getNewStatus() != ControlledVocabularies.ResourceStatus.APPROVED;
    }
}

