/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.saml.messages;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gr.cite.repo.auth.saml.messages.SamlMessagesHelpers;
import java.util.List;
import java.util.Map;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.XMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIDPMetadata {
    public static final String AUTH_REQUEST = "urn:mace:shibboleth:1.0:profiles:AuthnRequest";
    private static final Logger logger = LoggerFactory.getLogger(SamlIDPMetadata.class);
    Map<String, String> slsServiceBindings;
    Map<String, String> ssoServiceBindings;
    List<String> nameIdFormats;
    String entityId;

    public SamlIDPMetadata(String metadataXML) throws ConfigurationException, XMLParserException, UnmarshallingException {
        logger.debug("Initializing SamlIDPMetadata...");
        EntityDescriptor ed = this.getResponseObj(metadataXML);
        List slsServices = ed.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleLogoutServices();
        List ssoServices = ed.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleSignOnServices();
        this.slsServiceBindings = Maps.newHashMap();
        this.ssoServiceBindings = Maps.newHashMap();
        for (SingleLogoutService sls : slsServices) {
            this.slsServiceBindings.put(sls.getBinding(), sls.getLocation());
        }
        logger.info("slsServiceBindings : " + this.slsServiceBindings);
        for (SingleSignOnService sso : ssoServices) {
            this.ssoServiceBindings.put(sso.getBinding(), sso.getLocation());
        }
        logger.info("ssoServiceBindings : " + this.ssoServiceBindings);
        List nidF = ed.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getNameIDFormats();
        this.nameIdFormats = Lists.newArrayList();
        for (NameIDFormat nid : nidF) {
            this.nameIdFormats.add(nid.getFormat());
        }
        logger.info("nameIdFormats : " + this.nameIdFormats);
        this.entityId = ed.getEntityID();
        logger.info("entityId : " + this.entityId);
        logger.debug("Initialized SamlIDPMetadata");
    }

    public String getSSOAuthRequestLocation() {
        return this.ssoServiceBindings.get(AUTH_REQUEST);
    }

    public String getSSOHttpPostEndpoint() {
        return this.ssoServiceBindings.get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
    }

    public String getSSOHttpPostSimpleSignEndpoint() {
        return this.ssoServiceBindings.get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign");
    }

    public String getSSOHttpRedirectEndpoint() {
        return this.ssoServiceBindings.get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
    }

    public String getSLSHttpPostEndpoint() {
        return this.slsServiceBindings.get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
    }

    public String getSLSSoapEndpoint() {
        return this.slsServiceBindings.get("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
    }

    public String getSLSHttpRedirectEndpoint() {
        return this.slsServiceBindings.get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
    }

    public List<String> getNameIdFormats() {
        return this.nameIdFormats;
    }

    public String getEntityId() {
        return this.entityId;
    }

    protected EntityDescriptor getResponseObj(String xmlFile) throws ConfigurationException, XMLParserException, UnmarshallingException {
        return (EntityDescriptor)EntityDescriptor.class.cast(SamlMessagesHelpers.getResponseObj(xmlFile));
    }
}

