/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.dropwizard.bundles;

import com.google.inject.Module;
import com.hubspot.dropwizard.guice.GuiceBundle;
import gr.cite.repo.auth.app.SecureAppHelpers;
import gr.cite.repo.auth.app.config.SamlSecurityConfiguration;
import gr.cite.repo.auth.app.config.Security;
import gr.cite.repo.auth.app.entities.SamlResourceFactory;
import gr.cite.repo.auth.app.resources.SAMLResource;
import gr.cite.repo.auth.dropwizard.commands.SecureServerCommand;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewBundle;

public class SAMLBundle<T extends SamlSecurityConfiguration>
implements ConfiguredBundle<T> {
    final Application<T> app;
    final Class<T> clazz;
    final Module module;
    private GuiceBundle<T> guiceBundle;

    public SAMLBundle(Application<T> app, Class<T> clazz, Module module) {
        this.app = app;
        this.clazz = clazz;
        this.module = module;
    }

    public void run(T configuration, Environment environment) throws Exception {
        if (SecureAppHelpers.hasSessionManager(((SamlSecurityConfiguration)((Object)configuration)).getSessionManager())) {
            SamlResourceFactory samlResourceFactory = (SamlResourceFactory)this.guiceBundle.getInjector().getInstance(SamlResourceFactory.class);
            Security conf = ((SamlSecurityConfiguration)((Object)configuration)).getSecurity();
            SAMLResource samlResource = samlResourceFactory.create(conf.getSpHost(), conf.getIdpMetadataLocation(), conf.getPrivateKeyFilename(), conf.getCertificateFilename(), conf.getInvalidateLocalSessionOnSamlError(), conf.getTryRenewSessionOnLogout(), conf.getBulkLogout());
            environment.jersey().register((Object)samlResource);
        }
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.guiceBundle = GuiceBundle.newBuilder().addModule(this.module).setConfigClass(this.clazz).build();
        bootstrap.addBundle(this.guiceBundle);
        bootstrap.addCommand(this.getSecureServerCommand());
        bootstrap.addBundle((Bundle)new ViewBundle());
    }

    protected SecureServerCommand<T> getSecureServerCommand() {
        return new SecureServerCommand<T>(this.app);
    }
}

