/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.coverage.Coverage;
import gr.cite.geoanalytics.dataaccess.entities.coverage.dao.CoverageDao;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Path(value="/RasterManagement")
public class RasterManagementResource {
    private CoverageDao coverageDao;
    private ObjectMapper mapper;
    private static Logger logger = LoggerFactory.getLogger(RasterManagementResource.class);

    @Inject
    public RasterManagementResource(CoverageDao coverageDao) {
        this.coverageDao = coverageDao;
        this.mapper = new ObjectMapper();
    }

    @POST
    @Path(value="coverage/create")
    @Transactional(rollbackFor={Exception.class})
    public Response createCoverageInDatabase(@FormParam(value="coverage") String coverageJson) {
        logger.info("Inserting coverage request");
        Coverage coverage = null;
        try {
            coverage = (Coverage)this.mapper.readValue(coverageJson, Coverage.class);
            Assert.notNull((Object)coverage, (String)"No Coverage object was retrieved");
            Assert.isTrue((coverage.getImage().length > 0 ? 1 : 0) != 0, (String)"No geotiff image was found");
            this.coverageDao.create((Entity)coverage);
        }
        catch (IllegalArgumentException e) {
            return this.errorResponse(Response.Status.BAD_REQUEST, "Could not insert GeoTIFF image in database. " + e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            return this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Could not insert GeoTIFF image in database", e);
        }
        return this.successResponse(Response.Status.CREATED, "GeoTIFF " + coverage.getName() + " has been inserted into database successfully!", null);
    }

    @GET
    @Path(value="coverage/get/{layerId}")
    @Produces(value={"application/json"})
    @Transactional(rollbackFor={Exception.class})
    public Response getCoverageFromDatabase(@PathParam(value="layerId") String layerId) {
        logger.info("Inserting coverage request");
        Coverage coverage = null;
        try {
            Assert.isTrue((layerId != null && layerId.length() > 0 ? 1 : 0) != 0, (String)"Layer ID cannot be empty");
            coverage = this.coverageDao.findCoverageByLayer(UUID.fromString(layerId));
            if (coverage == null) {
                throw new Exception("Coverage of layer with id " + layerId + " was not found in database");
            }
        }
        catch (IllegalArgumentException e) {
            return this.errorResponse(Response.Status.BAD_REQUEST, "Could not retrieve GeoTIFF image in database. " + e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            return this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Could not retrieve GeoTIFF image in database", e);
        }
        return this.successResponse(Response.Status.OK, "Coverage " + layerId + " has been retrieved successfully!", (Object)coverage);
    }

    @DELETE
    @Path(value="coverage/delete/{layerId}")
    @Transactional(rollbackFor={Exception.class})
    public Response deleteGeoTIFFFromDatabase(@PathParam(value="layerId") String layerId) {
        logger.info("Deleting coverage request");
        Coverage coverage = null;
        try {
            Assert.isTrue((layerId != null && layerId.length() > 0 ? 1 : 0) != 0, (String)"Layer ID cannot be empty");
            coverage = this.coverageDao.findCoverageByLayer(UUID.fromString(layerId));
            if (coverage == null) {
                throw new Exception("Coverage of layer with id " + layerId + " was not found in database");
            }
            this.coverageDao.delete((Entity)coverage);
        }
        catch (IllegalArgumentException e) {
            return this.errorResponse(Response.Status.BAD_REQUEST, "Could not retrieve GeoTIFF image in database. " + e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            return this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Could not retrieve GeoTIFF image in database", e);
        }
        return this.successResponse(Response.Status.OK, "Coverage " + layerId + " has been deleted successfully!", null);
    }

    @GET
    @Path(value="ping")
    public String ping() {
        return "pong";
    }

    private Response errorResponse(Response.Status status, String message, Exception e) {
        logger.error(null, (Throwable)e);
        return Response.status((Response.Status)status).entity((Object)message).build();
    }

    private Response successResponse(Response.Status status, String message, Object body) {
        logger.info(message);
        String responseJson = null;
        try {
            responseJson = this.mapper.writeValueAsString(body != null ? body : message);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            responseJson = "Failed to convert response to JSON";
        }
        return Response.status((Response.Status)status).entity((Object)responseJson).build();
    }
}

