/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.OverlapBehavior;
import org.picocontainer.MutablePicoContainer;

public class SLDRasterSymbolizerBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDRasterSymbolizerBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    @Override
    public QName getTarget() {
        return SLD.RASTERSYMBOLIZER;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return RasterSymbolizer.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        RasterSymbolizer rs = this.styleFactory.createRasterSymbolizer();
        if (node.hasChild("Geometry")) {
            Expression geometry = (Expression)node.getChildValue("Geometry");
            if (geometry instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)geometry;
                rs.setGeometryPropertyName(propertyName.getPropertyName());
            } else {
                rs.setGeometry(geometry);
            }
        }
        if (node.hasChild("Opacity")) {
            rs.setOpacity((Expression)node.getChildValue("Opacity"));
        }
        if (node.hasChild("ChannelSelection")) {
            rs.setChannelSelection((ChannelSelection)node.getChildValue("ChannelSelection"));
        }
        if (node.hasChild("OverlapBehavior")) {
            rs.setOverlapBehavior((OverlapBehavior)((Object)node.getChildValue("OverlapBehavior")));
        }
        if (node.hasChild("ColorMap")) {
            rs.setColorMap((ColorMap)node.getChildValue("ColorMap"));
        }
        if (node.hasChild("ContrastEnhancement")) {
            rs.setContrastEnhancement((ContrastEnhancement)node.getChildValue("ContrastEnhancement"));
        }
        if (node.hasChild("ShadedRelief")) {
            rs.setShadedRelief((ShadedRelief)node.getChildValue("ShadedRelief"));
        }
        if (node.hasChild("ImageOutline")) {
            ImageOutline imageOutput = (ImageOutline)node.getChildValue("ImageOutline");
            rs.setImageOutline(imageOutput.getSymbolizer());
        }
        return rs;
    }
}

