/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.legend;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.MathTransform;

public class Drawer {
    private GeometryFactory gf = new GeometryFactory();
    static SimpleFeatureType pointSchema;
    static SimpleFeatureType lineSchema;
    static SimpleFeatureType polygonSchema;
    static SimpleFeatureType multipointSchema;
    static SimpleFeatureType multilineSchema;
    static SimpleFeatureType multipolygonSchema;

    private Drawer() {
    }

    public static Drawer create() {
        return new Drawer();
    }

    public void drawDirect(BufferedImage bi, SimpleFeature feature, Style style) {
        this.drawFeature(bi, feature, style, new AffineTransform());
    }

    public void drawDirect(BufferedImage bi, SimpleFeature feature, Rule rule) {
        AffineTransform worldToScreenTransform = new AffineTransform();
        this.drawFeature(bi, feature, worldToScreenTransform, false, this.getSymbolizers(rule), null);
    }

    public void drawFeature(BufferedImage bi, SimpleFeature feature, AffineTransform worldToScreenTransform, boolean drawVertices, MathTransform mt) {
        if (feature == null) {
            return;
        }
        this.drawFeature(bi, feature, worldToScreenTransform, drawVertices, Drawer.getSymbolizers(feature), mt);
    }

    public void drawFeature(BufferedImage bi, SimpleFeature feature, AffineTransform worldToScreenTransform) {
        if (feature == null) {
            return;
        }
        this.drawFeature(bi, feature, worldToScreenTransform, false, Drawer.getSymbolizers(feature), null);
    }

    public void drawFeature(BufferedImage bi, SimpleFeature feature, AffineTransform worldToScreenTransform, Style style) {
        if (feature == null) {
            return;
        }
        this.drawFeature(bi, feature, worldToScreenTransform, false, this.getSymbolizers(style), null);
    }

    public void drawFeature(BufferedImage bi, SimpleFeature feature, Style style, AffineTransform worldToScreenTransform) {
        if (feature == null) {
            return;
        }
        this.drawFeature(bi, feature, worldToScreenTransform, false, this.getSymbolizers(style), null);
    }

    Symbolizer[] getSymbolizers(Style style) {
        ArrayList<Symbolizer> symbs = new ArrayList<Symbolizer>();
        FeatureTypeStyle[] styles = style.getFeatureTypeStyles();
        for (int i = 0; i < styles.length; ++i) {
            FeatureTypeStyle fstyle = styles[i];
            Rule[] rules = fstyle.getRules();
            for (int j = 0; j < rules.length; ++j) {
                Rule rule = rules[j];
                symbs.addAll(Arrays.asList(rule.getSymbolizers()));
            }
        }
        return symbs.toArray(new Symbolizer[symbs.size()]);
    }

    Symbolizer[] getSymbolizers(Rule rule) {
        ArrayList<Symbolizer> symbs = new ArrayList<Symbolizer>();
        symbs.addAll(Arrays.asList(rule.getSymbolizers()));
        return symbs.toArray(new Symbolizer[symbs.size()]);
    }

    public static Symbolizer[] getSymbolizers(SimpleFeature feature) {
        return Drawer.getSymbolizers(((Geometry)feature.getDefaultGeometry()).getClass(), Color.RED);
    }

    public static Symbolizer[] getSymbolizers(Class<? extends Geometry> type, Color baseColor) {
        return Drawer.getSymbolizers(type, baseColor, true);
    }

    public static Symbolizer[] getSymbolizers(Class<? extends Geometry> type, Color baseColor, boolean useTransparency) {
        StyleBuilder builder = new StyleBuilder();
        Symbolizer[] syms = new Symbolizer[1];
        if (LineString.class.isAssignableFrom(type) || MultiLineString.class.isAssignableFrom(type)) {
            syms[0] = builder.createLineSymbolizer(baseColor, 2.0);
        }
        if (Point.class.isAssignableFrom(type) || MultiPoint.class.isAssignableFrom(type)) {
            PointSymbolizer point = builder.createPointSymbolizer(builder.createGraphic());
            point.getGraphic().setSize(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()).literal(10));
            point.getGraphic().getMarks()[0].setFill(builder.createFill(baseColor));
            syms[0] = point;
        }
        if (Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type)) {
            syms[0] = builder.createPolygonSymbolizer(builder.createStroke(baseColor, 2.0), builder.createFill(baseColor, useTransparency ? 0.6 : 1.0));
        }
        return syms;
    }

    public void drawFeature(BufferedImage bi, SimpleFeature feature, AffineTransform worldToScreenTransform, boolean drawVertices, Symbolizer[] symbs, MathTransform mt) {
        LiteShape shape = new LiteShape(null, worldToScreenTransform, false);
        if (symbs == null) {
            return;
        }
        for (int m = 0; m < symbs.length; ++m) {
            this.drawFeature(bi, feature, worldToScreenTransform, drawVertices, symbs[m], mt, shape);
        }
    }

    public void drawFeature(BufferedImage bi, SimpleFeature feature, AffineTransform worldToScreenTransform, boolean drawVertices, Symbolizer symbolizer, MathTransform mathTransform, LiteShape shape) {
        Graphics graphics = bi.getGraphics();
        if (!(symbolizer instanceof RasterSymbolizer)) {
            Geometry g = this.findGeometry(feature, symbolizer);
            if (g == null) {
                return;
            }
            if (mathTransform != null) {
                try {
                    g = JTS.transform(g, mathTransform);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            shape.setGeometry(g);
            this.paint(bi, feature, shape, symbolizer);
            if (drawVertices) {
                double averageDistance = 0.0;
                Coordinate[] coords = g.getCoordinates();
                java.awt.Point oldP = this.worldToPixel(coords[0], worldToScreenTransform);
                for (int i = 1; i < coords.length; ++i) {
                    Coordinate coord = coords[i];
                    java.awt.Point p = this.worldToPixel(coord, worldToScreenTransform);
                    averageDistance += p.distance(oldP) / (double)i;
                    oldP = p;
                }
                int pixels = 1;
                if (averageDistance > 20.0) {
                    pixels = 3;
                }
                if (averageDistance > 60.0) {
                    pixels = 5;
                }
                if (pixels > 1) {
                    graphics.setColor(Color.RED);
                    for (int i = 0; i < coords.length; ++i) {
                        Coordinate coord = coords[i];
                        java.awt.Point p = this.worldToPixel(coord, worldToScreenTransform);
                        graphics.fillRect(p.x - (pixels - 1) / 2, p.y - (pixels - 1) / 2, pixels, pixels);
                    }
                }
            }
        }
    }

    private void paint(BufferedImage bi, SimpleFeature feature, LiteShape shape, Symbolizer symb) {
        Color c;
        Graphics graphics = bi.getGraphics();
        Graphics2D g = (Graphics2D)graphics;
        if (symb instanceof PolygonSymbolizer) {
            PolygonSymbolizer polySymb = (PolygonSymbolizer)symb;
            Color stroke = SLD.polyColor(polySymb);
            double opacity = SLD.polyFillOpacity(polySymb);
            Color fill = SLD.polyFill(polySymb);
            int width = SLD.width(SLD.stroke(polySymb));
            if (width == -1) {
                width = 1;
            }
            if (Double.isNaN(opacity)) {
                opacity = 1.0;
            }
            if (fill != null) {
                fill = new Color(fill.getRed(), fill.getGreen(), fill.getBlue(), (int)(255.0 * opacity));
                g.setColor(fill);
                g.fill(shape);
            }
            if (stroke != null) {
                g.setColor(stroke);
                BasicStroke str = new BasicStroke(width);
                g.setStroke(str);
                g.draw(shape);
            }
        }
        if (symb instanceof LineSymbolizer) {
            LineSymbolizer lineSymbolizer = (LineSymbolizer)symb;
            c = SLD.color(lineSymbolizer);
            int w = SLD.width(lineSymbolizer);
            if (c != null && w > 0) {
                g.setColor(c);
                BasicStroke str = new BasicStroke(w);
                g.setStroke(str);
                g.draw(shape);
            }
        }
        if (symb instanceof PointSymbolizer) {
            PointSymbolizer pointSymbolizer = (PointSymbolizer)symb;
            c = SLD.pointColor(pointSymbolizer);
            Color fill = SLD.pointFill(pointSymbolizer);
            int width = SLD.width(SLD.stroke(pointSymbolizer));
            if (width == -1) {
                width = 1;
            }
            float[] point = new float[6];
            shape.getPathIterator(null).currentSegment(point);
            SLDStyleFactory styleFactory = new SLDStyleFactory();
            Style2D tmp = styleFactory.createStyle(feature, pointSymbolizer, NumberRange.create(Double.MIN_VALUE, Double.MAX_VALUE));
            if (tmp instanceof MarkStyle2D) {
                MarkStyle2D style = (MarkStyle2D)tmp;
                Shape shape2 = style.getTransformedShape(point[0], point[1]);
                if (c == null && fill == null) {
                    g.setColor(Color.GRAY);
                    g.fill(shape2);
                }
                if (fill != null) {
                    g.setColor(fill);
                    g.fill(shape2);
                } else {
                    g.setColor(Color.GRAY);
                    g.fill(shape2);
                }
                if (c != null) {
                    BasicStroke str = new BasicStroke(width);
                    g.setStroke(str);
                    g.setColor(c);
                    g.draw(shape2);
                } else {
                    BasicStroke str = new BasicStroke(width);
                    g.setStroke(str);
                    g.setColor(Color.DARK_GRAY);
                    g.draw(shape2);
                }
            } else if (tmp instanceof GraphicStyle2D) {
                GraphicStyle2D style = (GraphicStyle2D)tmp;
                float rotation = style.getRotation();
                g.setTransform(AffineTransform.getRotateInstance(rotation));
                BufferedImage image = style.getImage();
                g.drawImage((Image)image, (int)((double)point[0] - (double)image.getWidth() / 2.0), (int)((double)point[1] - (double)image.getHeight() / 2.0), null);
            }
        }
    }

    private Geometry findGeometry(SimpleFeature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        Geometry geom = geomName == null ? (Geometry)f.getDefaultGeometry() : (Geometry)f.getAttribute(geomName);
        if ((s instanceof PointSymbolizer || s instanceof TextSymbolizer) && !(geom instanceof Point)) {
            if (geom instanceof LineString && !(geom instanceof LinearRing)) {
                Coordinate[] coordinates = geom.getCoordinates();
                Coordinate start = coordinates[0];
                Coordinate end = coordinates[1];
                Coordinate mid = new Coordinate((start.x + end.x) / 2.0, (start.y + end.y) / 2.0);
                geom = geom.getFactory().createPoint(mid);
            } else {
                geom = geom.getCentroid();
            }
        }
        return geom;
    }

    private String getGeometryPropertyName(Symbolizer s) {
        String geomName = null;
        if (s instanceof PolygonSymbolizer) {
            geomName = ((PolygonSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof PointSymbolizer) {
            geomName = ((PointSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof LineSymbolizer) {
            geomName = ((LineSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof TextSymbolizer) {
            geomName = ((TextSymbolizer)s).getGeometryPropertyName();
        }
        return geomName;
    }

    public java.awt.Point worldToPixel(Coordinate coord, AffineTransform worldToScreenTransform) {
        Point2D.Double w = new Point2D.Double(coord.x, coord.y);
        AffineTransform at = worldToScreenTransform;
        Point2D p = at.transform(w, new Point2D.Double());
        return new java.awt.Point((int)p.getX(), (int)p.getY());
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Rectangle screenSize) {
        double scaleX = screenSize.getWidth() / mapExtent.getWidth();
        double scaleY = screenSize.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + screenSize.getHeight();
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        return at;
    }

    public SimpleFeatureType schema(String name, String spec) {
        try {
            return DataUtilities.createType(name, spec);
        }
        catch (SchemaException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SimpleFeature feature(Geometry geom) {
        if (geom instanceof Polygon) {
            return this.feature((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return this.feature((MultiPolygon)geom);
        }
        if (geom instanceof Point) {
            return this.feature((Point)geom);
        }
        if (geom instanceof LineString) {
            return this.feature((LineString)geom);
        }
        if (geom instanceof MultiPoint) {
            return this.feature((MultiPoint)geom);
        }
        if (geom instanceof MultiLineString) {
            return this.feature((MultiLineString)geom);
        }
        throw new IllegalArgumentException("Geometry is not supported to create feature");
    }

    public SimpleFeature feature(Point point) {
        if (point == null) {
            throw new NullPointerException("Point required");
        }
        try {
            return SimpleFeatureBuilder.build(pointSchema, new Object[]{point}, null);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException("Could not generate feature for point " + point);
        }
    }

    public SimpleFeature feature(LineString line) {
        if (line == null) {
            throw new NullPointerException("line required");
        }
        try {
            return SimpleFeatureBuilder.build(lineSchema, new Object[]{line}, null);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException("Could not generate feature for point " + line);
        }
    }

    public SimpleFeature feature(Polygon polygon) {
        if (polygon == null) {
            throw new NullPointerException("polygon required");
        }
        try {
            return SimpleFeatureBuilder.build(polygonSchema, new Object[]{polygon}, null);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException("Could not generate feature for point " + polygon);
        }
    }

    public SimpleFeature feature(MultiPoint multipoint) {
        if (multipoint == null) {
            throw new NullPointerException("multipoint required");
        }
        try {
            return SimpleFeatureBuilder.build(multipointSchema, new Object[]{multipoint}, null);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException("Could not generate feature for point " + multipoint);
        }
    }

    public SimpleFeature feature(MultiLineString multilinestring) {
        if (multilinestring == null) {
            throw new NullPointerException("multilinestring required");
        }
        try {
            return SimpleFeatureBuilder.build(multilineSchema, new Object[]{multilinestring}, null);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException("Could not generate feature for point " + multilinestring);
        }
    }

    public SimpleFeature feature(MultiPolygon multipolygon) {
        if (multipolygon == null) {
            throw new NullPointerException("multipolygon required");
        }
        try {
            return SimpleFeatureBuilder.build(multipolygonSchema, new Object[]{multipolygon}, null);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException("Could not generate feature for point " + multipolygon);
        }
    }

    public Point point(int x, int y) {
        return this.gf.createPoint(new Coordinate(x, y));
    }

    public LineString line(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate(xy[i], xy[i + 1]);
        }
        return this.gf.createLineString(coords);
    }

    public MultiLineString lines(int[][] xy) {
        LineString[] lines = new LineString[xy.length];
        for (int i = 0; i < xy.length; ++i) {
            lines[i] = this.line(xy[i]);
        }
        return this.gf.createMultiLineString(lines);
    }

    public Polygon polygon(int[] xy) {
        LinearRing shell = this.ring(xy);
        return this.gf.createPolygon(shell, null);
    }

    public Polygon polygon(int[] xy, int[][] holes) {
        if (holes == null || holes.length == 0) {
            return this.polygon(xy);
        }
        LinearRing shell = this.ring(xy);
        LinearRing[] rings = new LinearRing[holes.length];
        for (int i = 0; i < xy.length; ++i) {
            rings[i] = this.ring(holes[i]);
        }
        return this.gf.createPolygon(shell, rings);
    }

    public LinearRing ring(int[] xy) {
        int length = xy.length / 2;
        if (xy[0] != xy[xy.length - 2] || xy[1] != xy[xy.length - 1]) {
            ++length;
        }
        Coordinate[] coords = new Coordinate[length];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate(xy[i], xy[i + 1]);
        }
        if (xy[0] != xy[xy.length - 2] || xy[1] != xy[xy.length - 1]) {
            coords[length - 1] = coords[0];
        }
        return this.gf.createLinearRing(coords);
    }

    static {
        try {
            pointSchema = DataUtilities.createType("generated:point", "*point:Point");
            lineSchema = DataUtilities.createType("generated:linestring", "*linestring:LineString");
            polygonSchema = DataUtilities.createType("generated:polygon", "*polygon:Polygon");
            multipointSchema = DataUtilities.createType("generated:multipoint", "*multipoint:MultiPoint");
            multilineSchema = DataUtilities.createType("generated:multilinestring", "*multilinestring:MultiLineString");
            multipolygonSchema = DataUtilities.createType("generated:multipolygon", "*multipolygon:MultiPolygon");
        }
        catch (SchemaException unExpected) {
            System.err.println(unExpected);
        }
    }
}

