/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.wfs20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UpdateActionType implements Enumerator
{
    REPLACE(0, "replace", "replace"),
    INSERT_BEFORE(1, "insertBefore", "insertBefore"),
    INSERT_AFTER(2, "insertAfter", "insertAfter"),
    REMOVE(3, "remove", "remove");

    public static final int REPLACE_VALUE = 0;
    public static final int INSERT_BEFORE_VALUE = 1;
    public static final int INSERT_AFTER_VALUE = 2;
    public static final int REMOVE_VALUE = 3;
    private static final UpdateActionType[] VALUES_ARRAY;
    public static final List<UpdateActionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static UpdateActionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            UpdateActionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static UpdateActionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            UpdateActionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static UpdateActionType get(int value) {
        switch (value) {
            case 0: {
                return REPLACE;
            }
            case 1: {
                return INSERT_BEFORE;
            }
            case 2: {
                return INSERT_AFTER;
            }
            case 3: {
                return REMOVE;
            }
        }
        return null;
    }

    private UpdateActionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new UpdateActionType[]{REPLACE, INSERT_BEFORE, INSERT_AFTER, REMOVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

