package gr.cite.geoanalytics.environmental.data.retriever.model;

public class Temperature extends Data {

	public Temperature(Data data) {
		super(data);
	}

	public int getValueAsInt(Unit unit) {
		if (unit != null) {
			return (int) Math.round(unit == Unit.CELCIUS ? getCelciusTemperature() : getKelvinTemperature());
		} else {
			return getValueAsInt();
		}
	}

	private float getKelvinTemperature() {
		return value;
	}

	private float getCelciusTemperature() {
		return value - 273.15f;
	}
}
