/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.logging.Level;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.RasterLayer;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.Style;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GridReaderLayer
extends RasterLayer {
    protected GridCoverage2DReader reader;
    protected GeneralParameterValue[] params;

    public GridReaderLayer(GridCoverage2DReader reader, Style style) {
        this(reader, style, null, null);
    }

    public GridReaderLayer(GridCoverage2DReader reader, Style style, String title) {
        this(reader, style, title, null);
    }

    public GridReaderLayer(GridCoverage2DReader reader, Style style, GeneralParameterValue[] params) {
        this(reader, style, null, params);
    }

    public GridReaderLayer(GridCoverage2DReader reader, Style style, String title, GeneralParameterValue[] params) {
        super(style, title);
        this.reader = reader;
        this.params = params;
    }

    @Override
    public void dispose() {
        this.preDispose();
        if (this.reader != null) {
            try {
                this.reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.style != null) {
            this.style = null;
        }
        if (this.params != null) {
            this.params = null;
        }
        super.dispose();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        if (this.reader != null) {
            CoordinateReferenceSystem crs = this.reader.getCoordinateReferenceSystem();
            GeneralEnvelope envelope = this.reader.getOriginalEnvelope();
            if (envelope != null) {
                return new ReferencedEnvelope(envelope);
            }
            if (crs != null) {
                return new ReferencedEnvelope(crs);
            }
        }
        return null;
    }

    public GridCoverage2DReader getReader() {
        return this.reader;
    }

    public GeneralParameterValue[] getParams() {
        return this.params;
    }

    @Override
    public SimpleFeatureCollection toFeatureCollection() {
        try {
            SimpleFeatureCollection collection = FeatureUtilities.wrapGridCoverageReader(this.reader, this.params);
            return collection;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Coverage could not be converted to FeatureCollection", e);
            return null;
        }
    }
}

