/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseMathOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class Add
extends BaseMathOperationJAI {
    private static final String ALGEBRIC = "algebric";
    private static final String ADD = "Add";
    private static final long serialVersionUID = -4029879745691129215L;

    public Add() {
        super(ADD, Add.getOperationDescriptor(JAIExt.getOperationName(ADD)));
    }

    @Override
    public String getName() {
        return ADD;
    }

    @Override
    protected NumberRange deriveRange(NumberRange[] ranges, OperationJAI.Parameters parameters) {
        if (ranges != null && ranges.length == 2) {
            NumberRange range0 = ranges[0];
            NumberRange range1 = ranges[1];
            double min0 = range0.getMinimum();
            double min1 = range1.getMinimum();
            double max0 = range0.getMaximum();
            double max1 = range1.getMaximum();
            double max = max0 + max1;
            double min = min0 + min1;
            return NumberRange.create(min, max);
        }
        return null;
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        if (JAIExt.isJAIExtOperation(ALGEBRIC)) {
            parameters.set((Object)AlgebraDescriptor.Operator.SUM, 0);
            Collection sources = (Collection)parameters2.parameter("sources").getValue();
            for (GridCoverage2D source : sources) {
                Add.handleROINoDataInternal(parameters, source, ALGEBRIC, 1, 2);
            }
        }
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return Add.handleROINoDataProperties(null, parameters.parameters, sources[0], ALGEBRIC, 1, 2, 3);
    }
}

