/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.LineStringEncoder;
import org.geotools.gml2.simple.LinearRingEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Encoder;
import org.xml.sax.helpers.AttributesImpl;

class MultiLineStringEncoder
extends GeometryEncoder<MultiLineString> {
    static final QualifiedName MULTI_LINE_STRING = new QualifiedName("http://www.opengis.net/gml", "MultiLineString", "gml");
    static final QualifiedName LINE_STRING_MEMBER = new QualifiedName("http://www.opengis.net/gml", "lineStringMember", "gml");
    LineStringEncoder lse;
    LinearRingEncoder lre;
    QualifiedName multiLineString;
    QualifiedName lineStringMember;

    protected MultiLineStringEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.lse = new LineStringEncoder(encoder, gmlPrefix);
        this.lre = new LinearRingEncoder(encoder, gmlPrefix);
        this.multiLineString = MULTI_LINE_STRING.derive(gmlPrefix);
        this.lineStringMember = LINE_STRING_MEMBER.derive(gmlPrefix);
    }

    @Override
    public void encode(MultiLineString geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.multiLineString, atts);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.lineStringMember, null);
            LineString line = (LineString)geometry.getGeometryN(i);
            if (line instanceof LinearRing) {
                this.lre.encode(line, (AttributesImpl)null, handler);
            } else {
                this.lse.encode(line, (AttributesImpl)null, handler);
            }
            handler.endElement(this.lineStringMember);
        }
        handler.endElement(this.multiLineString);
    }
}

