/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.kernel;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import javax.media.jai.KernelJAI;
import org.jaitools.CollectionFactory;
import org.jaitools.media.jai.kernel.KernelFactoryHelper;
import org.jaitools.media.jai.kernel.KernelUtil;
import org.jaitools.numeric.CompareOp;

public class KernelFactory {
    private static final double C_GAUSS = 1.0 / Math.sqrt(Math.PI * 2);
    private static final double C_QUARTIC = 0.9375;
    private static final double C_TRIWEIGHT = 1.09375;
    private static final double PI_ON_2 = 1.5707963267948966;
    private static final double PI_ON_4 = 0.7853981633974483;

    public static KernelJAI createCircle(int radius) {
        return KernelFactory.createConstantCircle(radius, 1.0f);
    }

    public static KernelJAI createConstantCircle(int radius, float value) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Invalid radius (" + radius + "); must be > 0");
        }
        KernelFactoryHelper helper = new KernelFactoryHelper();
        float[] weights = helper.makeCircle(radius);
        int w = 2 * radius + 1;
        helper.rowFill(weights, w, w, value);
        return new KernelJAI(w, w, weights);
    }

    public static KernelJAI createCircle(int radius, ValueType type, float centreValue) {
        KernelJAI kernel = KernelFactory.createCircle(radius, type);
        return KernelUtil.setElement(kernel, radius, radius, centreValue);
    }

    public static KernelJAI createCircle(int radius, ValueType type) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Invalid radius (" + radius + "); must be > 0");
        }
        int width = 2 * radius + 1;
        float[] weights = new float[width * width];
        float r2 = radius * radius;
        int k0 = 0;
        int k1 = weights.length - 1;
        double dist2 = 0.0;
        float value = 0.0f;
        for (int y = radius; y > 0; --y) {
            int y2 = y * y;
            int x = -radius;
            while (x <= radius) {
                dist2 = x * x + y2;
                if (CompareOp.acompare((double)r2, dist2) >= 0) {
                    switch (type) {
                        case BINARY: {
                            value = 1.0f;
                            break;
                        }
                        case COSINE: {
                            value = (float)(0.7853981633974483 * Math.cos(1.5707963267948966 * Math.sqrt(dist2) / (double)radius));
                            break;
                        }
                        case DISTANCE: {
                            value = (float)Math.sqrt(dist2);
                            break;
                        }
                        case EPANECHNIKOV: {
                            value = (float)(3.0 * (1.0 - dist2 / (double)r2) / 4.0);
                            break;
                        }
                        case GAUSSIAN: {
                            value = (float)(C_GAUSS * Math.exp(-0.5 * dist2 / (double)r2));
                            break;
                        }
                        case INVERSE_DISTANCE: {
                            value = (float)(1.0 / Math.sqrt(dist2));
                            break;
                        }
                        case QUARTIC: {
                            double termq = 1.0 - dist2 / (double)r2;
                            value = (float)(0.9375 * termq * termq);
                            break;
                        }
                        case TRIANGULAR: {
                            value = (float)(1.0 - Math.sqrt(dist2) / (double)radius);
                            break;
                        }
                        case TRIWEIGHT: {
                            double termt = 1.0 - dist2 / (double)r2;
                            value = (float)(1.09375 * termt * termt * termt);
                        }
                    }
                    weights[k0] = weights[k1] = value;
                }
                ++x;
                ++k0;
                --k1;
            }
        }
        int x = -radius;
        while (x <= radius) {
            if (x == 0 && type == ValueType.INVERSE_DISTANCE) {
                value = 1.0f;
            } else {
                switch (type) {
                    case BINARY: {
                        value = 1.0f;
                        break;
                    }
                    case COSINE: {
                        value = (float)(0.7853981633974483 * Math.cos(1.5707963267948966 * (double)x / (double)radius));
                        break;
                    }
                    case DISTANCE: {
                        value = Math.abs(x);
                        break;
                    }
                    case EPANECHNIKOV: {
                        value = (float)(3.0 * (1.0 - (double)x * (double)x / (double)r2) / 4.0);
                        break;
                    }
                    case GAUSSIAN: {
                        value = (float)(C_GAUSS * Math.exp(-0.5 * (double)x * (double)x / (double)r2));
                        break;
                    }
                    case INVERSE_DISTANCE: {
                        value = (float)(1.0 / (double)Math.abs(x));
                        break;
                    }
                    case QUARTIC: {
                        double termq = 1.0 - (double)x * (double)x / (double)r2;
                        value = (float)(0.9375 * termq * termq);
                        break;
                    }
                    case TRIANGULAR: {
                        value = (float)(1.0 - (double)Math.abs(x) / (double)radius);
                        break;
                    }
                    case TRIWEIGHT: {
                        double termt = 1.0 - (double)x * (double)x / (double)r2;
                        value = (float)(1.09375 * termt * termt * termt);
                    }
                }
            }
            weights[k0] = value;
            ++x;
            ++k0;
        }
        return new KernelJAI(width, width, weights);
    }

    public static KernelJAI createAnnulus(int outerRadius, int innerRadius, ValueType type, float centreValue) {
        KernelJAI kernel = KernelFactory.createAnnulus(outerRadius, innerRadius, type);
        return KernelUtil.setElement(kernel, outerRadius, outerRadius, centreValue);
    }

    public static KernelJAI createConstantAnnulus(int outerRadius, int innerRadius, float value) {
        if (outerRadius <= 0) {
            throw new IllegalArgumentException("outerRadius must be > 0");
        }
        if (innerRadius >= outerRadius) {
            throw new IllegalArgumentException("innerRadius must be less than outerRadius");
        }
        int w = 2 * outerRadius + 1;
        float[] data = new float[w * w];
        double outer2 = outerRadius * outerRadius;
        double inner2 = innerRadius * innerRadius;
        int k = 0;
        for (int y = 0; y < w; ++y) {
            double y2 = y * y;
            for (int x = 0; x < w; ++x) {
                double d2 = y2 + (double)(x * x);
                data[k] = CompareOp.acompare(d2, outer2) <= 0 && CompareOp.acompare(d2, inner2) > 0 ? value : 0.0f;
            }
        }
        return new KernelJAI(w, w, data);
    }

    public static KernelJAI createAnnulus(int outerRadius, int innerRadius, ValueType type) {
        if (innerRadius < 0) {
            throw new IllegalArgumentException("Invalid innerRadius (" + innerRadius + "); must be >= 0");
        }
        if (outerRadius <= innerRadius) {
            throw new IllegalArgumentException("outerRadius must be greater than innerRadius");
        }
        if (innerRadius == 0) {
            return KernelFactory.createCircle(outerRadius, type);
        }
        int width = 2 * outerRadius + 1;
        float[] weights = new float[width * width];
        double outer2 = outerRadius * outerRadius;
        double inner2 = innerRadius * innerRadius;
        double dist2 = 0.0;
        float value = 0.0f;
        int k0 = 0;
        int k1 = weights.length - 1;
        for (int y = outerRadius; y > 0; --y) {
            int y2 = y * y;
            int x = -outerRadius;
            while (x <= outerRadius) {
                dist2 = x * x + y2;
                if (CompareOp.acompare(dist2, outer2) <= 0 && CompareOp.acompare(dist2, inner2) > 0) {
                    switch (type) {
                        case BINARY: {
                            value = 1.0f;
                            break;
                        }
                        case COSINE: {
                            value = (float)(0.7853981633974483 * Math.cos(1.5707963267948966 * Math.sqrt(dist2) / (double)outerRadius));
                            break;
                        }
                        case DISTANCE: {
                            value = (float)Math.sqrt(dist2);
                            break;
                        }
                        case EPANECHNIKOV: {
                            value = (float)(3.0 * (1.0 - dist2 / outer2) / 4.0);
                            break;
                        }
                        case GAUSSIAN: {
                            value = (float)(C_GAUSS * Math.exp(-0.5 * dist2 / outer2));
                            break;
                        }
                        case INVERSE_DISTANCE: {
                            value = (float)(1.0 / Math.sqrt(dist2));
                            break;
                        }
                        case QUARTIC: {
                            double termq = 1.0 - dist2 / outer2;
                            value = (float)(0.9375 * termq * termq);
                            break;
                        }
                        case TRIANGULAR: {
                            value = (float)(1.0 - Math.sqrt(dist2) / (double)outerRadius);
                            break;
                        }
                        case TRIWEIGHT: {
                            double termt = 1.0 - dist2 / outer2;
                            value = (float)(1.09375 * termt * termt * termt);
                        }
                    }
                    weights[k0] = weights[k1] = value;
                }
                ++x;
                ++k0;
                --k1;
            }
        }
        int x = -outerRadius;
        while (x <= outerRadius) {
            if (x < -innerRadius || x > innerRadius) {
                switch (type) {
                    case BINARY: {
                        value = 1.0f;
                        break;
                    }
                    case COSINE: {
                        value = (float)(0.7853981633974483 * Math.cos(1.5707963267948966 * (double)x / (double)outerRadius));
                        break;
                    }
                    case DISTANCE: {
                        value = Math.abs(x);
                        break;
                    }
                    case EPANECHNIKOV: {
                        value = (float)(3.0 * (1.0 - (double)x * (double)x / outer2) / 4.0);
                        break;
                    }
                    case GAUSSIAN: {
                        value = (float)(C_GAUSS * Math.exp(-0.5 * (double)x * (double)x / outer2));
                        break;
                    }
                    case INVERSE_DISTANCE: {
                        value = (float)(1.0 / (double)Math.abs(x));
                        break;
                    }
                    case QUARTIC: {
                        double termq = 1.0 - (double)x * (double)x / outer2;
                        value = (float)(0.9375 * termq * termq);
                        break;
                    }
                    case TRIANGULAR: {
                        value = (float)(1.0 - (double)Math.abs(x) / (double)outerRadius);
                        break;
                    }
                    case TRIWEIGHT: {
                        double termt = 1.0 - (double)x * (double)x / outer2;
                        value = (float)(1.09375 * termt * termt * termt);
                    }
                }
                weights[k0] = value;
            }
            ++x;
            ++k0;
        }
        return new KernelJAI(width, width, weights);
    }

    public static KernelJAI createRectangle(int width, int height) {
        return KernelFactory.createConstantRectangle(width, height, 1.0f);
    }

    public static KernelJAI createConstantRectangle(int width, int height, float value) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width and height must both be >= 1");
        }
        float[] weights = new KernelFactoryHelper().makeRect(width, height, value);
        return new KernelJAI(width, height, weights);
    }

    public static KernelJAI createConstantRectangle(int width, int height, int keyX, int keyY, float value) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width and height must both be >= 1");
        }
        if (keyX < 0 || keyX >= width || keyY < 0 || keyY >= height) {
            throw new IllegalArgumentException("key element must be within the rectangle");
        }
        float[] weights = new KernelFactoryHelper().makeRect(width, height, value);
        return new KernelJAI(width, height, keyX, keyY, weights);
    }

    public static KernelJAI createRectangle(int width, int height, ValueType type, int keyX, int keyY, float keyValue) {
        KernelJAI kernel = KernelFactory.createRectangle(width, height, type, keyX, keyY);
        return KernelUtil.setElement(kernel, keyX, keyY, keyValue);
    }

    public static KernelJAI createRectangle(int width, int height, ValueType type, int keyX, int keyY) {
        if (width < 1) {
            throw new IllegalArgumentException("width must be >= 1");
        }
        if (height < 1) {
            throw new IllegalArgumentException("height must be >= 1");
        }
        if (keyX < 0 || keyX >= width || keyY < 0 || keyY >= height) {
            throw new IllegalArgumentException("key element position " + keyX + "," + keyY + " is outside rectangle bounds");
        }
        KernelFactoryHelper kh = new KernelFactoryHelper();
        if (type == ValueType.BINARY) {
            float[] weights = kh.makeRect(width, height, 1.0f);
            return new KernelJAI(width, height, keyX, keyY, weights);
        }
        float[] weights = new float[width * height];
        int k = 0;
        int dx = Math.max(keyX, width - 1 - keyX);
        int dy = Math.max(keyY, height - 1 - keyY);
        double dmax2 = dx * dx + dy * dy;
        double dmax = Math.sqrt(dmax2);
        Point p = new Point(keyX, keyY);
        double dist2 = 0.0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                dist2 = (float)p.distanceSq(x, y);
                switch (type) {
                    case COSINE: {
                        weights[k] = (float)(0.7853981633974483 * Math.cos(1.5707963267948966 * Math.sqrt(dist2) / dmax));
                        break;
                    }
                    case DISTANCE: {
                        weights[k] = (float)Math.sqrt(dist2);
                        break;
                    }
                    case EPANECHNIKOV: {
                        weights[k] = (float)(3.0 * (1.0 - dist2 / dmax2) / 4.0);
                        break;
                    }
                    case GAUSSIAN: {
                        weights[k] = (float)(C_GAUSS * Math.exp(-0.5 * dist2 / dmax2));
                        break;
                    }
                    case INVERSE_DISTANCE: {
                        if (dist2 < 1.0) {
                            weights[k] = 1.0f;
                            break;
                        }
                        weights[k] = (float)(1.0 / Math.sqrt(dist2));
                        break;
                    }
                    case QUARTIC: {
                        double termq = 1.0 - dist2 / dmax2;
                        weights[k] = (float)(0.9375 * termq * termq);
                        break;
                    }
                    case TRIANGULAR: {
                        weights[k] = (float)(1.0 - Math.sqrt(dist2) / dmax);
                        break;
                    }
                    case TRIWEIGHT: {
                        double termt = 1.0 - dist2 / dmax2;
                        weights[k] = (float)(1.09375 * termt * termt * termt);
                    }
                }
                ++x;
                ++k;
            }
        }
        return new KernelJAI(width, height, keyX, keyY, weights);
    }

    public static KernelJAI createFromShape(Shape shape, AffineTransform transform, ValueType type, int keyX, int keyY, float keyValue) {
        PathIterator iter = shape.getPathIterator(transform, 0.05);
        float[] buf = new float[6];
        List<Coordinate> coords = CollectionFactory.list();
        while (!iter.isDone()) {
            iter.currentSegment(buf);
            coords.add(new Coordinate(buf[0], buf[1]));
            iter.next();
        }
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coordsAr = coords.toArray(new Coordinate[coords.size()]);
        Polygon poly = gf.createPolygon(gf.createLinearRing(coordsAr), null);
        Envelope env = poly.getEnvelopeInternal();
        int left = (int)Math.floor(env.getMinX());
        int right = (int)Math.ceil(env.getMaxX());
        int top = (int)Math.ceil(env.getMaxY());
        int bottom = (int)Math.floor(env.getMinY());
        int width = right - left + 1;
        int height = top - bottom + 1;
        float[] weights = new float[width * height];
        int[] offset = new int[height];
        int i = 0;
        int o = 0;
        while (i < offset.length) {
            offset[i] = o;
            ++i;
            o += width;
        }
        coords.clear();
        double y = top;
        for (int iy = 0; iy < height; ++iy) {
            double x = left;
            for (int ix = 0; ix < width; ++ix) {
                coords.add(new Coordinate(x, y));
                x += 1.0;
            }
            y -= 1.0;
        }
        MultiPoint mp = gf.createMultiPoint(coords.toArray(new Coordinate[coords.size()]));
        Geometry inside = mp.intersection(poly.buffer(0.05, Math.max(width / 2, 10)));
        int n = inside.getNumGeometries();
        double dmax = 0.0;
        double dmax2 = 0.0;
        switch (type) {
            case COSINE: 
            case EPANECHNIKOV: 
            case GAUSSIAN: 
            case QUARTIC: 
            case TRIANGULAR: 
            case TRIWEIGHT: {
                for (int i2 = 0; i2 < n; ++i2) {
                    Geometry g = inside.getGeometryN(i2);
                    Coordinate c = g.getCoordinate();
                    double d2 = Point2D.distanceSq(keyX, keyY, (int)c.x, (int)c.y);
                    if (!(d2 > dmax2)) continue;
                    dmax2 = d2;
                }
                dmax = Math.sqrt(dmax2);
            }
        }
        double dist2 = 0.0;
        block19: for (int i3 = 0; i3 < n; ++i3) {
            Geometry g = inside.getGeometryN(i3);
            Coordinate c = g.getCoordinate();
            int index = (int)c.x - left + offset[(int)c.y - bottom];
            if (type != ValueType.BINARY) {
                dist2 = Point2D.distanceSq(keyX, keyY, (int)c.x, (int)c.y);
            }
            switch (type) {
                case BINARY: {
                    weights[index] = 1.0f;
                    continue block19;
                }
                case COSINE: {
                    weights[index] = (float)(0.7853981633974483 * Math.cos(1.5707963267948966 * Math.sqrt(dist2) / dmax));
                    continue block19;
                }
                case DISTANCE: {
                    weights[index] = (float)Math.sqrt(dist2);
                    continue block19;
                }
                case EPANECHNIKOV: {
                    weights[index] = (float)(3.0 * (1.0 - dist2 / dmax2) / 4.0);
                    continue block19;
                }
                case GAUSSIAN: {
                    weights[index] = (float)(C_GAUSS * Math.exp(-0.5 * dist2 / dmax2));
                    continue block19;
                }
                case INVERSE_DISTANCE: {
                    weights[index] = (float)(1.0 / Math.sqrt(dist2));
                    continue block19;
                }
                case QUARTIC: {
                    double termq = 1.0 - dist2 / dmax2;
                    weights[index] = (float)(0.9375 * termq * termq);
                    continue block19;
                }
                case TRIANGULAR: {
                    weights[index] = (float)(1.0 - Math.sqrt(dist2) / dmax);
                    continue block19;
                }
                case TRIWEIGHT: {
                    double termt = 1.0 - dist2 / dmax2;
                    weights[index] = (float)(1.09375 * termt * termt * termt);
                }
            }
        }
        weights[keyX + offset[keyY]] = keyValue;
        return new KernelJAI(width, height, keyX, keyY, weights);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        BINARY,
        COSINE,
        DISTANCE,
        EPANECHNIKOV,
        GAUSSIAN,
        INVERSE_DISTANCE,
        QUARTIC,
        TRIANGULAR,
        TRIWEIGHT;

    }
}

