/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import org.geotools.swing.control.PopupMenuProvider;
import org.geotools.swing.control.StatusBarItem;

public class JMenuStatusBarItem
extends StatusBarItem {
    public JMenuStatusBarItem(String name, ImageIcon icon, String toolTip, final JPopupMenu menu) {
        this(name, icon, toolTip, new PopupMenuProvider(){
            {
                if (menu == null) {
                    throw new IllegalArgumentException("menu must not be null");
                }
            }

            @Override
            public JPopupMenu getMenu() {
                return menu;
            }
        });
    }

    public JMenuStatusBarItem(String name, ImageIcon icon, String toolTip, final PopupMenuProvider menuProvider) {
        super(name, false);
        if (icon == null) {
            throw new IllegalArgumentException("icon must not be null");
        }
        if (menuProvider == null) {
            throw new IllegalArgumentException("menuProvider must not be null");
        }
        final JButton btn = new JButton(icon);
        btn.setBorderPainted(false);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                menuProvider.getMenu().show(btn, 0, 0);
            }
        });
        if (toolTip != null && toolTip.trim().length() > 0) {
            btn.setToolTipText(toolTip);
        }
        this.add(btn);
    }
}

