/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.media.jai.OperationDescriptor;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.Utilities;

final class ImagingParameterDescription
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = -325584046563057577L;
    private static final String[] argumentKeys = new String[12];
    private final OperationDescriptor operation;
    private final String key;
    private final String prefixKey;

    public ImagingParameterDescription(OperationDescriptor operation, int arg) {
        String candidate;
        this.operation = operation;
        this.prefixKey = null;
        if (arg < argumentKeys.length && (candidate = argumentKeys[arg]) != null) {
            this.key = candidate;
            return;
        }
        this.key = "arg" + arg + "Desc";
        if (arg < argumentKeys.length) {
            ImagingParameterDescription.argumentKeys[arg] = this.key;
        }
    }

    public ImagingParameterDescription(OperationDescriptor operation, String key, String prefixKey) {
        this.operation = operation;
        this.key = key;
        this.prefixKey = prefixKey;
    }

    public boolean exists() {
        try {
            return this.toString().length() != 0;
        }
        catch (MissingResourceException exception) {
            return false;
        }
    }

    @Override
    public String toString(Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resources = this.operation.getResourceBundle(locale);
        String name = resources.getString(this.key);
        if (this.prefixKey != null) {
            name = ImagingParameterDescription.trimPrefix(name, resources.getString(this.prefixKey));
        }
        return name;
    }

    static String trimPrefix(String name, String prefix) {
        int length;
        int offset;
        name = name.trim();
        if (prefix != null && (offset = (prefix = prefix.trim()).length()) != 0 && name.startsWith(prefix) && offset < (length = name.length()) && name.charAt(offset) == '.') {
            name = name.substring(offset + 1);
        }
        return name;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            ImagingParameterDescription that = (ImagingParameterDescription)object;
            return Utilities.equals(this.key, that.key) && Utilities.equals(this.prefixKey, that.prefixKey) && Utilities.equals(this.operation, that.operation);
        }
        return false;
    }

    public int hashCode() {
        return 0xE0132057 ^ this.key.hashCode() ^ this.operation.hashCode();
    }
}

