/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.error;

import java.lang.reflect.Field;
import org.hsqldb.HsqlException;
import org.hsqldb.error.ErrorCode;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.resources.ResourceBundleHandler;
import org.hsqldb.result.Result;

public class Error {
    public static boolean TRACE = false;
    public static boolean TRACESYSTEMOUT = false;
    private static final String errPropsName = "sql-state-messages";
    private static final int bundleHandle = ResourceBundleHandler.getBundleHandle("sql-state-messages", null);
    private static final String MESSAGE_TAG = "$$";
    private static final int SQL_STATE_DIGITS = 5;
    private static final int SQL_CODE_DIGITS = 4;
    private static final int ERROR_CODE_BASE = 11;

    public static RuntimeException runtimeError(int n, String string) {
        HsqlException hsqlException = Error.error(n, string);
        return new RuntimeException(hsqlException.getMessage());
    }

    public static HsqlException error(int n, String string) {
        return Error.error(null, n, string);
    }

    public static HsqlException error(Throwable throwable, int n, String string) {
        String string2 = Error.getMessage(n);
        if (string != null) {
            string2 = string2 + ": " + string.toString();
        }
        return new HsqlException(throwable, string2.substring(6), string2.substring(0, 5), -n);
    }

    public static HsqlException parseError(int n, String string, int n2) {
        String string2 = Error.getMessage(n);
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        if (n2 > 1) {
            string = Error.getMessage(24);
            string2 = string2 + " :" + string + String.valueOf(n2);
        }
        return new HsqlException(null, string2.substring(6), string2.substring(0, 5), -n);
    }

    public static HsqlException error(int n) {
        return Error.error(null, n, 0, null);
    }

    public static HsqlException error(int n, Throwable throwable) {
        String string = Error.getMessage(n, 0, null);
        return new HsqlException(throwable, string.substring(0, 5), -n);
    }

    public static HsqlException error(Throwable throwable, int n, int n2, Object[] objectArray) {
        String string = Error.getMessage(n, n2, objectArray);
        int n3 = n2 < 11 ? n : n2;
        return new HsqlException(throwable, string.substring(6), string.substring(0, 5), -n3);
    }

    public static HsqlException parseError(int n, int n2, int n3, Object[] objectArray) {
        String string = Error.getMessage(n, n2, objectArray);
        if (n3 > 1) {
            String string2 = Error.getMessage(24);
            string = string + " :" + string2 + String.valueOf(n3);
        }
        int n4 = n2 < 11 ? n : n2;
        return new HsqlException(null, string.substring(6), string.substring(0, 5), -n4);
    }

    public static HsqlException error(int n, int n2) {
        return Error.error(n, Error.getMessage(n2));
    }

    public static HsqlException error(String string, String string2) {
        int n = Error.getCode(string2);
        if (n < 1000) {
            n = 5800;
        }
        if (string == null) {
            string = Error.getMessage(n);
        }
        return new HsqlException(null, string, string2, n);
    }

    private static String insertStrings(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < objectArray.length && (n2 = string.indexOf(MESSAGE_TAG, n)) != -1; ++i) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(objectArray[i] == null ? "null exception message" : objectArray[i].toString());
            n = n2 + MESSAGE_TAG.length();
        }
        n2 = string.length();
        stringBuffer.append(string.substring(n, n2));
        return stringBuffer.toString();
    }

    public static String getMessage(int n) {
        return Error.getResourceString(n);
    }

    public static String getStateString(int n) {
        return Error.getMessage(n, 0, null).substring(0, 5);
    }

    public static String getMessage(int n, int n2, Object[] objectArray) {
        String string = Error.getResourceString(n);
        if (n2 != 0) {
            string = string + Error.getResourceString(n2);
        }
        if (objectArray != null) {
            string = Error.insertStrings(string, objectArray);
        }
        return string;
    }

    private static String getResourceString(int n) {
        String string = StringUtil.toZeroPaddedString(n, 4, 4);
        return ResourceBundleHandler.getString(bundleHandle, string);
    }

    public static HsqlException error(Result result) {
        return new HsqlException(result);
    }

    public static void printSystemOut(String string) {
        if (TRACESYSTEMOUT) {
            System.out.println(string);
        }
    }

    public static int getCode(String string) {
        try {
            Field[] fieldArray = ErrorCode.class.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                String string2 = fieldArray[i].getName();
                if (string2.length() != 7 || !string2.endsWith(string)) continue;
                return fieldArray[i].getInt(ErrorCode.class);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }
}

