/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0.bindings;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.ows11.KeywordsType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wfs20.FeatureTypeType;
import net.opengis.wfs20.OutputFormatListType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xml.AbstractComplexEMFBinding;

public class FeatureTypeTypeBinding
extends AbstractComplexEMFBinding {
    private Wfs20Factory factory;

    public FeatureTypeTypeBinding(Wfs20Factory factory) {
        super(factory);
        this.factory = factory;
    }

    @Override
    public QName getTarget() {
        return WFS.FeatureTypeType;
    }

    @Override
    public Class getType() {
        return FeatureTypeType.class;
    }

    @Override
    protected void setProperty(EObject object, String property, Object value, boolean lax) {
        if ("OtherCRS".equals(property)) {
            String stringValue = null;
            if (value instanceof String) {
                stringValue = (String)((Object)value);
            } else if (value instanceof URI) {
                stringValue = ((URI)((Object)value)).toString();
            }
            if (stringValue != null) {
                ((FeatureTypeType)object).getOtherCRS().add(stringValue);
                return;
            }
        } else if ("OtherSRS".equals(property)) {
            if (value instanceof Collection) {
                Collection formatListAsUris = value;
                ArrayList<String> formatListAsString = new ArrayList<String>();
                for (URI uri : formatListAsUris) {
                    formatListAsString.add(uri.toString());
                }
                value = formatListAsString;
            } else if (value instanceof URI) {
                value = ((URI)((Object)value)).toString();
            }
        } else if ("Keywords".equals(property)) {
            if (value instanceof String) {
                String[] split = ((String)((Object)value)).split(",");
                KeywordsType kwd = Ows11Factory.eINSTANCE.createKeywordsType();
                for (int i = 0; i < split.length; ++i) {
                    String kw = split[i].trim();
                    kwd.getKeyword().add(kw);
                }
                ((FeatureTypeType)object).getKeywords().add(kwd);
                return;
            }
        } else if ("OutputFormats".equals(property) && value != null) {
            OutputFormatListType oflt = ((FeatureTypeType)object).getOutputFormats();
            if (oflt == null) {
                oflt = this.factory.createOutputFormatListType();
            }
            if (value instanceof Map) {
                oflt.getFormat().addAll((Collection)((Map)((Object)value)).get("Format"));
            } else {
                oflt.getFormat().add(((Object)value).toString());
            }
            ((FeatureTypeType)object).setOutputFormats(oflt);
            return;
        }
        super.setProperty(object, property, value, lax);
    }
}

