/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.wizard;

import javax.swing.JComponent;
import javax.swing.JTextField;
import org.geotools.data.Parameter;
import org.geotools.swing.wizard.JWizard;
import org.geotools.swing.wizard.ParamField;

public class JDoubleField
extends ParamField {
    private JTextField text;

    public JDoubleField(Parameter<?> parameter) {
        super(parameter);
    }

    @Override
    public JComponent doLayout() {
        this.text = new JTextField(16);
        return this.text;
    }

    @Override
    public Object getValue() {
        String val = this.text.getText();
        if (val == null || val.equals("")) {
            return new Double(0.0);
        }
        try {
            return new Double(val);
        }
        catch (NumberFormatException e) {
            return new Double(0.0);
        }
    }

    @Override
    public void addListener(JWizard.Controller controller) {
        this.text.addKeyListener(controller);
    }

    @Override
    public void removeListener(JWizard.Controller controller) {
        this.text.addKeyListener(controller);
    }

    @Override
    public void setValue(Object value) {
        this.text.setText(((Double)value).toString());
    }

    @Override
    public boolean validate() {
        String val = this.text.getText();
        try {
            Double d = Double.parseDouble(val);
            return d != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

