/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.standard;

import java.util.Iterator;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.basic.SourceGraphIterator;
import org.geotools.graph.util.FIFOQueue;
import org.geotools.graph.util.Queue;

public class BreadthFirstIterator
extends SourceGraphIterator {
    private Queue m_active;

    @Override
    public void setSource(Graphable source) {
        super.setSource(source);
        if (this.m_active == null) {
            this.m_active = this.buildQueue(this.getGraph());
        } else if (this.m_active.isEmpty()) {
            this.m_active.clear();
        }
        this.m_active.enq(this.getSource());
    }

    @Override
    public void init(Graph graph, GraphTraversal traversal) {
    }

    @Override
    public Graphable next(GraphTraversal traversal) {
        while (!this.m_active.isEmpty()) {
            Graphable next = (Graphable)this.m_active.deq();
            if (traversal.isVisited(next)) continue;
            return next;
        }
        return null;
    }

    @Override
    public void cont(Graphable current, GraphTraversal traversal) {
        Iterator itr = current.getRelated();
        while (itr.hasNext()) {
            Graphable related = (Graphable)itr.next();
            if (traversal.isVisited(related)) continue;
            this.m_active.enq(related);
        }
    }

    @Override
    public void killBranch(Graphable current, GraphTraversal traversal) {
    }

    protected Queue buildQueue(Graph graph) {
        return new FIFOQueue(graph.getNodes().size());
    }

    protected Queue getQueue() {
        return this.m_active;
    }
}

