/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;

public class FilteredIterator<F extends Feature>
implements Iterator<F>,
FeatureIterator<F> {
    private Iterator<F> delegate;
    private Filter filter;
    private F next;

    public FilteredIterator(Iterator<F> iterator, Filter filter) {
        this.delegate = iterator;
        this.filter = filter;
    }

    public FilteredIterator(Collection<F> collection, Filter filter) {
        this.delegate = collection.iterator();
        this.filter = filter;
        this.next = this.getNext();
    }

    @Override
    public void close() {
        if (this.delegate instanceof FeatureIterator) {
            ((FeatureIterator)((Object)this.delegate)).close();
        }
        this.delegate = null;
        this.filter = null;
        this.next = null;
    }

    private F getNext() {
        Feature item = null;
        while (this.delegate.hasNext()) {
            item = (Feature)this.delegate.next();
            if (!this.filter.evaluate(item)) continue;
            return (F)item;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public F next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        F current = this.next;
        this.next = this.getNext();
        return current;
    }

    @Override
    public void remove() {
        if (this.delegate == null) {
            throw new IllegalStateException();
        }
        this.delegate.remove();
    }
}

