/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.graph.util.Queue;

public class FIFOQueue
implements Collection,
Queue {
    private static final int DEFAULT_SIZE = 10;
    private Object[] m_values;
    private int m_in;
    private int m_out;
    private boolean m_full;
    private boolean m_empty;

    public FIFOQueue() {
        this(10);
        this.m_full = false;
    }

    public FIFOQueue(int size) {
        this.m_values = new Object[size];
        this.clear();
    }

    @Override
    public void enq(Object element) {
        if (this.m_full) {
            throw new IllegalStateException("Queue full.");
        }
        this.m_empty = false;
        this.m_values[this.m_in++] = element;
        if (this.m_in == this.m_values.length) {
            this.m_in = 0;
        }
        this.m_full = this.m_in == this.m_out;
    }

    @Override
    public Object deq() {
        if (this.m_empty) {
            throw new NoSuchElementException("Heap empty.");
        }
        this.m_full = false;
        Object o = this.m_values[this.m_out];
        this.m_values[this.m_out++] = null;
        if (this.m_out == this.m_values.length) {
            this.m_out = 0;
        }
        this.m_empty = this.m_in == this.m_out;
        return o;
    }

    @Override
    public int size() {
        if (this.m_empty) {
            return 0;
        }
        if (this.m_full) {
            return this.m_values.length;
        }
        int size = 0;
        int i = this.m_out;
        while (i < this.m_values.length) {
            if (i == this.m_in) {
                return size;
            }
            ++i;
            ++size;
        }
        i = 0;
        while (i < this.m_in) {
            ++i;
            ++size;
        }
        return size;
    }

    @Override
    public void clear() {
        this.m_in = 0;
        this.m_out = 0;
        this.m_full = false;
        this.m_empty = true;
    }

    @Override
    public boolean isEmpty() {
        return this.m_empty;
    }

    public boolean isFull() {
        return this.m_full;
    }

    @Override
    public Object[] toArray() {
        return this.m_values;
    }

    public boolean add(Object o) {
        this.enq(o);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.m_values.length; ++i) {
            if (this.m_values[i] == null || !this.m_values[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove(Object)");
    }

    public boolean addAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            this.enq(itr.next());
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("removeAll(Collection)");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("retainAll(Collection)");
    }

    @Override
    public Iterator iterator() {
        return new QueueIterator();
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int j = 0;
        int i = this.m_out;
        while (i < this.m_values.length) {
            if (i == this.m_in) {
                if (j < a.length) {
                    a[j] = null;
                }
                return a;
            }
            a[j] = this.m_values[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < this.m_out) {
            a[j] = this.m_values[i];
            ++i;
            ++j;
        }
        if (j < a.length) {
            a[j] = null;
        }
        return a;
    }

    int in() {
        return this.m_in;
    }

    int out() {
        return this.m_out;
    }

    Object[] values() {
        return this.m_values;
    }

    public class QueueIterator
    implements Iterator {
        int m_index;

        private QueueIterator() {
            this.m_index = FIFOQueue.this.m_out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }

        @Override
        public boolean hasNext() {
            return this.m_index != FIFOQueue.this.m_in;
        }

        public Object next() {
            Object o = FIFOQueue.this.m_values[this.m_index++];
            if (this.m_index == FIFOQueue.this.m_values.length) {
                this.m_index = 0;
            }
            return o;
        }
    }
}

