/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.workflow;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.workflow.Workflow;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"WorkflowTask\"")
public class WorkflowTask
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"WFT_ID\"", nullable=false)
    private UUID id = null;
    @ManyToOne
    @JoinColumn(name="\"WFT_Workflow\"", nullable=false)
    private Workflow workflow = null;
    @Column(name="\"WFT_Name\"", nullable=false, length=250)
    private String name = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WFT_StartDate\"", nullable=true)
    private Date startDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WFT_EndDate\"", nullable=true)
    private Date endDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WFT_ReminderDate\"", nullable=true)
    private Date reminderDate = null;
    @Column(name="\"WFT_Status\"", nullable=false)
    private short status = WorkflowTaskStatus.ACTIVE.statusCode();
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="\"WFT_ExtraData\"", nullable=true, columnDefinition="xml")
    private String extraData = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WFT_StatusDate\"", nullable=false)
    private Date statusDate = null;
    @Column(name="\"WFT_Critical\"", nullable=false)
    private short critical = Criticality.NONBLOCKING.criticalityCode();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WFT_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"WFT_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"WFT_Creator\"", nullable=false)
    private Principal creator = null;
    @ManyToOne
    @JoinColumn(name="\"WFT_Principal\"", nullable=true)
    private Principal principal = null;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getReminderDate() {
        return this.reminderDate;
    }

    public void setReminderDate(Date reminderDate) {
        this.reminderDate = reminderDate;
    }

    public WorkflowTaskStatus getStatus() {
        return WorkflowTaskStatus.fromStatusCode(this.status);
    }

    public void setStatus(WorkflowTaskStatus status) {
        this.status = status.statusCode();
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    public Criticality getCritical() {
        return Criticality.fromCriticalityCode(this.critical);
    }

    public void setCritical(Criticality critical) {
        this.critical = critical.criticalityCode();
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal user) {
        this.principal = user;
    }

    public String toString() {
        return "WorkflowTask(id=" + this.getId() + " name=" + this.getName() + " workflow=" + (this.workflow != null ? this.workflow.getId() : null) + " startDate=" + this.getStartDate() + " endDate=" + this.getEndDate() + " status=" + (Object)((Object)this.getStatus()) + " statusDate=" + this.getStatusDate() + "criticality=" + (Object)((Object)this.getCritical()) + " extraData=" + this.getExtraData() + " creation=" + this.getCreationDate() + " lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null) + " user=" + (this.principal != null ? this.principal.getId() : null);
    }

    public static enum Criticality {
        NONBLOCKING(0),
        BLOCKING(1),
        CRITICAL(2);

        private final short criticalityCode;
        private static final Map<Short, Criticality> lookup;

        private Criticality(short criticalityCode) {
            this.criticalityCode = criticalityCode;
        }

        public short criticalityCode() {
            return this.criticalityCode;
        }

        public static Criticality fromCriticalityCode(short criticalityCode) {
            return lookup.get(criticalityCode);
        }

        static {
            lookup = new HashMap<Short, Criticality>();
            for (Criticality s : EnumSet.allOf(Criticality.class)) {
                lookup.put(s.criticalityCode(), s);
            }
        }
    }

    public static enum WorkflowTaskStatus {
        INACTIVE(0),
        ACTIVE(1),
        COMPLETED(2),
        CANCELLED(3),
        TRANSFERRED(4);

        private final short statusCode;
        private static final Map<Short, WorkflowTaskStatus> lookup;

        private WorkflowTaskStatus(short statusCode) {
            this.statusCode = statusCode;
        }

        public short statusCode() {
            return this.statusCode;
        }

        public static WorkflowTaskStatus fromStatusCode(short statusCode) {
            return lookup.get(statusCode);
        }

        static {
            lookup = new HashMap<Short, WorkflowTaskStatus>();
            for (WorkflowTaskStatus s : EnumSet.allOf(WorkflowTaskStatus.class)) {
                lookup.put(s.statusCode(), s);
            }
        }
    }
}

