/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.geocode.dao;

import gr.cite.geoanalytics.dataaccess.dao.Dao;
import gr.cite.geoanalytics.dataaccess.entities.geocode.Geocode;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public interface GeocodeDao
extends Dao<Geocode, UUID> {
    public List<Geocode> findAutoCreatedWithParent(GeocodeSystem var1);

    public List<Geocode> findByGeocodeSystem(GeocodeSystem var1);

    public List<Geocode> findByName(String var1);

    public List<Geocode> findByNameAndGeocodeSystem(String var1, GeocodeSystem var2);

    public List<Geocode> findByNameAndTaxonomies(String var1, List<GeocodeSystem> var2);

    public List<Geocode> findAllTermsByTaxonomies(List<GeocodeSystem> var1);

    public List<Geocode> getSiblings(Geocode var1);

    public List<Geocode> getChildren(Geocode var1);

    public List<Geocode> getClassSiblings(Geocode var1);

    public List<Geocode> getClassDescendants(Geocode var1);

    public Shape getShape(Geocode var1) throws Exception;

    public List<Shape> getShapes(Geocode var1) throws Exception;

    public List<Geocode> getGeocodesByShapes(Collection<Shape> var1);

    public boolean isGeocodeSystemLoaded(Geocode var1);

    public boolean isParentLoaded(Geocode var1);

    public boolean isGeocodeClassLoaded(Geocode var1);

    public boolean isCreatorLoaded(Geocode var1);

    public boolean isDataLoaded(Geocode var1);

    public void deleteById(Geocode var1);

    public List<String> listNames();

    public List<String> listNamesOfActive();
}

