/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.shape.dao;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.WKTReader;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeDao;
import gr.cite.geoanalytics.dataaccess.typedefinition.DataType;
import gr.cite.geoanalytics.dataaccess.typedefinition.DatabaseColumnType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ShapeDaoImpl
extends JpaDao<Shape, UUID>
implements ShapeDao {
    private DatabaseColumnType dtc;
    public static ObjectMapper mapper = new ObjectMapper();
    public static Logger log = LoggerFactory.getLogger(ShapeDaoImpl.class);

    @Inject
    public void setDtc(DatabaseColumnType dtc) {
        this.dtc = dtc;
    }

    @Override
    public List<Shape> findShapesByClass(short shp_class) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from Shape where shapeClass = :code", Shape.class);
        query.setParameter("code", (Object)shp_class);
        result = query.getResultList();
        log.debug("Find shapes with class: " + shp_class);
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Shape sh : result) {
                log.debug("Shape (" + sh.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Shape> searchShapesByName(String term) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("from Shape s");
        queryB.append(" where ");
        queryB.append("lower(s.name) like :term");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Shape.class);
        query.setParameter("term", (Object)("%" + term.toLowerCase() + "%"));
        result = query.getResultList();
        log.debug("Shapes by name pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Shape s : result) {
                log.debug("Shape (" + s.getId() + ":" + s.getName() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Shape> searchShapes(List<String> terms) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("from Shape s");
        if (!terms.isEmpty()) {
            queryB.append(" where ");
        }
        int j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            queryB.append("lower(s.name) like :term" + j);
            ++j;
            if (i >= terms.size() - 1) continue;
            queryB.append(" or ");
        }
        queryB.append(")");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Shape.class);
        j = 0;
        for (int i = 0; i < terms.size(); ++i) {
            String lower = terms.get(i).toLowerCase();
            query.setParameter("term" + i, (Object)("%" + lower + "%"));
        }
        result = query.getResultList();
        log.debug("Shapes by name/description/extra data pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Shape p : result) {
                log.debug("Project (" + p.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Shape> searchShapesWithin(List<String> terms, Shape container) {
        List result = null;
        StringBuilder queryB = new StringBuilder();
        queryB.append("select * from \"Shape\" s");
        queryB.append(" where ST_Within(cast (s.\"SHP_Geography\" as geometry),ST_GeometryFromText(?1,4326))=true");
        if (!terms.isEmpty()) {
            queryB.append(" and ");
        }
        int j = 1;
        for (int i = 0; i < terms.size(); ++i) {
            queryB.append("lower(s.\"SHP_Name\") like ?" + j);
            queryB.append(" or lower(s.\"SHP_Description\") like ?" + ++j);
            queryB.append(" or lower(s.\"SHP_ExtraData\") like ?" + ++j);
            ++j;
            if (i >= terms.size() - 1) continue;
            queryB.append(" or ");
        }
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery(queryB.toString());
        query.setParameter(1, (Object)container.getGeography().toText());
        j = 1;
        for (int i = 0; i < terms.size(); ++i) {
            String lower = terms.get(i).toLowerCase();
            query.setParameter("term" + i, (Object)("%" + lower + "%"));
        }
        result = query.getResultList();
        log.debug("Shapes by name/description/extra data pattern matching:");
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Shape p : result) {
                log.debug("Project (" + p.getId() + ")");
            }
        }
        return result;
    }

    @Override
    public long countShapes(UUID si) {
        TypedQuery query = this.entityManager.createQuery("select count(s) from Shape s where s.id = :id", Long.class);
        query.setParameter("id", (Object)si);
        return (Long)query.getSingleResult();
    }

    private String getDBColumnTypeForXmlAttribute(ShapeAttributeDataType dt) throws Exception {
        switch (dt) {
            case SHORT: {
                return this.dtc.getType(DataType.SHORT);
            }
            case INTEGER: {
                return this.dtc.getType(DataType.INTEGER);
            }
            case LONG: {
                return this.dtc.getType(DataType.LONG);
            }
            case FLOAT: {
                return this.dtc.getType(DataType.FLOAT);
            }
            case DOUBLE: {
                return this.dtc.getType(DataType.DOUBLE);
            }
            case DATE: {
                return this.dtc.getType(DataType.DATE);
            }
            case STRING: {
                return this.dtc.getType(DataType.STRING);
            }
            case LONGSTRING: {
                return this.dtc.getType(DataType.TEXT);
            }
        }
        throw new Exception("Unrecognized data type " + dt);
    }

    public boolean isDBTypeTextual(String type) {
        return type.equals("text") || type.contains("character varying");
    }

    @Override
    public List<Shape> searchShapesWithinByAttributes(Map<String, Shape.Attribute> attrs, Shape container) {
        try {
            ArrayList<Shape> result = null;
            StringBuilder queryB = new StringBuilder();
            queryB.append("select s.\"SHP_ID\\:\\:character varying(36) from \"Shape\" s");
            queryB.append(" where ST_Within(cast (s.\"SHP_Geography\" as geometry),ST_GeometryFromText('" + container.getGeography().toText() + "',4326))=true");
            if (!attrs.isEmpty()) {
                queryB.append(" and ");
            }
            Iterator<Map.Entry<String, Shape.Attribute>> attrsIt = attrs.entrySet().iterator();
            while (attrsIt.hasNext()) {
                Map.Entry<String, Shape.Attribute> attr = attrsIt.next();
                queryB.append("(xpath('//extraData/*[@taxonomy=\"");
                queryB.append(attr.getValue().getTaxonomy());
                queryB.append("\"]/text()'\\:\\:text, s.shp_extradata))[1]\\:\\:text");
                String type = this.getDBColumnTypeForXmlAttribute(ShapeAttributeDataType.valueOf((String)attr.getValue().getType()));
                if (this.isDBTypeTextual(type)) {
                    queryB.append(" like ");
                } else {
                    queryB.append(" = ");
                }
                queryB.append("'" + attr.getValue().getValue() + "'");
                if (!attrsIt.hasNext()) continue;
                queryB.append(" and ");
            }
            this.entityManager.flush();
            Query query = this.entityManager.createNativeQuery(queryB.toString());
            result = new ArrayList<Shape>();
            List ids = query.getResultList();
            for (String id : ids) {
                result.add((Shape)this.read(UUID.fromString(id)));
            }
            log.debug("Shapes by shape/extra data matching:");
            log.debug((result != null ? result.size() : 0) + " results");
            if (log.isDebugEnabled() && result != null) {
                for (Shape p : result) {
                    log.debug("Project (" + p.getId() + ")");
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error("An error has occurred while searching for shapes", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public long countShapesOfLayer(UUID layerID) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select count(s) from Shape s where s.layerID = :layerID", Long.class);
        query.setParameter("layerID", (Object)layerID);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<String> getAllLayerIDs() {
        log.debug("Finding all layerIDs (distinct) within Shape table ");
        List<String> result = null;
        TypedQuery query = this.entityManager.createQuery("select distinct(s.layerID) from Shape s", UUID.class);
        result = query.getResultList().parallelStream().map(uuid -> uuid.toString()).collect(Collectors.toList());
        log.debug("Found " + (result != null ? result.size() : 0) + " results");
        return result;
    }

    @Override
    public List<Shape> findShapesOfLayerSimple(UUID layerID) {
        log.debug("Finding shapes of layer (layerID): " + layerID);
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select s from Shape s where s.layerID = :layerID", Shape.class);
        query.setParameter("layerID", (Object)layerID);
        result = query.getResultList();
        log.debug("Found " + (result != null ? result.size() : 0) + " results");
        return result;
    }

    @Override
    public List<Shape> findShapesOfLayer(UUID layerID) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select s from Shape s where s.layerID = :layerID", Shape.class);
        query.setParameter("layerID", (Object)layerID);
        result = query.getResultList();
        return result;
    }

    @Override
    public ScrollableResults findShapesOfLayerScrollable(UUID layerID) {
        Session session = (Session)this.entityManager.unwrap(Session.class);
        return session.createQuery("select s from Shape s where s.layerID = :layerID").setParameter("layerID", (Object)layerID).setReadOnly(true).setCacheable(false).scroll(ScrollMode.FORWARD_ONLY);
    }

    @Override
    public Set<String> getAttributeValuesOfShapesByLayer(UUID layerID, Shape.Attribute attribute) {
        try {
            List result = null;
            String type = this.getDBColumnTypeForXmlAttribute(ShapeAttributeDataType.valueOf((String)attribute.getType()));
            StringBuilder queryB = new StringBuilder();
            queryB.append("select distinct");
            queryB.append("(xpath('//extraData/*[@taxonomy=\"");
            queryB.append(attribute.getTaxonomy());
            queryB.append("\"]/text()'\\:\\:text, s.\"SHP_ExtraData\"))[1]\\:\\:text ");
            queryB.append("from \"Shape\" s, \"ShapeTerm\" st");
            queryB.append(" where st.\"SHPT_Term\" = '");
            queryB.append(layerID.toString());
            queryB.append("' and st.\"SHPT_Shape\" = s.shp_id");
            this.entityManager.flush();
            Query query = this.entityManager.createNativeQuery(queryB.toString());
            result = query.getResultList();
            log.debug("Shape attribute values for term " + layerID + " and attribute " + attribute.getName() + "(tax:" + attribute.getTaxonomy() + "):");
            log.debug((result != null ? result.size() : 0) + " results");
            if (log.isDebugEnabled() && result != null) {
                for (String p : result) {
                    log.debug(p);
                }
            }
            return new HashSet<String>(result);
        }
        catch (Exception e) {
            log.error("An error has occurred while searching for shapes", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteShapesOfLayer(UUID layerID) {
        Query query = this.entityManager.createQuery("delete from Shape s where s.layerID = :layerID)");
        query.setParameter("layerID", (Object)layerID);
        int num = query.executeUpdate();
        log.debug("Deleted all shapes of layer " + layerID.toString() + " -> " + num + " shapes deleted");
    }

    @Override
    public void deleteByShapeID(UUID shapeID) {
        Query query = this.entityManager.createQuery("delete from Shape s where s.id = :shapeID)");
        query.setParameter("shapeID", (Object)shapeID);
        int num = query.executeUpdate();
        log.debug("Deleted " + num + " shapes");
    }

    @Override
    public boolean existShapesOfLayer(UUID layerID) {
        TypedQuery query = this.entityManager.createQuery("select count(s) from Shape s where s.layerID = :layerID", Long.class);
        query.setParameter("layerID", (Object)layerID);
        return (Long)query.getSingleResult() > 0L;
    }

    @Override
    public UUID findLayerIDOfShape(Shape s) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select s.layerID from Shape s where s.id = :s", UUID.class);
        query.setParameter("s", (Object)s.getId());
        List res = query.getResultList();
        if (res.size() > 1) {
            throw new Exception("More than one layers found for shape (that's bad)" + s.getId());
        }
        if (res.isEmpty()) {
            return null;
        }
        return (UUID)res.get(0);
    }

    @Override
    public List<Document> findDocumentsOfShape(Shape s) {
        TypedQuery query = this.entityManager.createQuery("select sd.document from ShapeDocument sd where sd.shape = :s", Document.class);
        query.setParameter("s", (Object)s);
        return query.getResultList();
    }

    @Override
    public Document findDocumentOfShape(Shape s, GeocodeSystem t) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select sd.document from ShapeDocument sd, Geocode tt, GeocodeSystem t, Document d  where tts.taxonomy = :t and tts.shape = s and sd.document = d and sd.shape = :s", Document.class);
        query.setParameter("s", (Object)s);
        query.setParameter("t", (Object)t);
        List res = query.getResultList();
        if (res.size() > 1) {
            throw new Exception("More than one documents found for shape " + s.getId() + " and taxonomy " + t.getId());
        }
        if (res.isEmpty()) {
            return null;
        }
        return (Document)res.get(0);
    }

    @Override
    public Shape envelope(Shape s) throws Exception {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select ST_AsText(ST_Envelope(cast (s.\"SHP_Geography\" as geometry))) from \"Shape\" s where s.\"SHP_ID\"=cast (?1 as uuid)");
        query.setParameter(1, (Object)s.getId().toString());
        String e = (String)query.getSingleResult();
        WKTReader reader = new WKTReader();
        Geometry envelope = reader.read(e);
        envelope.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s.getCode());
        res.setCreatorID(s.getCreatorID());
        res.setGeography(envelope);
        res.setName(s.getName() + "_envelope");
        res.setShapeClass(s.getShapeClass());
        return res;
    }

    @Override
    public Shape boundary(Shape s) throws Exception {
        this.entityManager.flush();
        Query sel = this.entityManager.createNativeQuery("select cast(s.shp_id as text) from \"Shape\" s where s.\"SHP_ID\"=cast (?1 as uuid)");
        sel.setParameter(1, (Object)s.getId().toString());
        List selRes = sel.getResultList();
        Query query = this.entityManager.createNativeQuery("select ST_AsText(ST_Boundary(cast (s.\"SHP_Geography\" as geometry))) from \"Shape\" s where s.\"SHP_ID\"=cast (?1 as uuid)");
        query.setParameter(1, (Object)s.getId().toString());
        String b = (String)query.getSingleResult();
        WKTReader reader = new WKTReader();
        Geometry boundary = reader.read(b);
        boundary.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s.getCode());
        res.setCreatorID(s.getCreatorID());
        res.setGeography(boundary);
        res.setName(s.getName() + "_boundary");
        res.setShapeClass(s.getShapeClass());
        return res;
    }

    @Override
    public List<Shape> findEqualsGeom(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select * from \"Shape\" s where s.\"SHP_ID\" != cast (?1 as uuid) and ST_Equals(ST_GeometryFromText(?2,4326), cast (s.\"SHP_Geography\" as geometry))=true", Shape.class);
        query.setParameter(1, (Object)s.getId().toString());
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean equalsGeom(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        queryString = s1.getId() != null ? "select ST_Equals(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)" : "select ST_Equals(ST_GeometryFromText(?1,4326), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s2 where s2.\"SHP_ID\"=cast (?2 as uuid)";
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s1.getId() != null) {
            query.setParameter(1, (Object)s1.getId().toString());
        } else {
            query.setParameter(1, (Object)s1.getGeography().toText());
        }
        query.setParameter(2, (Object)s2.getId().toString());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findDisjoint(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select * from \"Shape\" s where s.\"SHP_ID\" != cast (?1 as uuid) and ST_Disjoint(ST_GeometryFromText(?2,4326),cast (s.\"SHP_Geography\" as geometry))=true", Shape.class);
        query.setParameter(1, (Object)s.getId().toString());
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean disjoint(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        queryString = s1.getId() != null ? "select ST_Disjoint(cast (s1.SHP_Geography as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)" : "select ST_Disjoint(ST_GeometryFromText(?1,4326), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s2 where s2.\"SHP_ID\"=cast (?2 as uuid)";
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s1.getId() != null) {
            query.setParameter(1, (Object)s1.getId().toString());
        } else {
            query.setParameter(1, (Object)s1.getGeography().toText());
        }
        query.setParameter(2, (Object)s2.getId().toString());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findIntersects(Shape s) {
        TypedQuery query = this.entityManager.createQuery("from Shape s where s.id != :s and intersects(s.geography, :g)", Shape.class);
        query.setParameter("s", (Object)s.getId());
        query.setParameter("g", (Object)s.getGeography());
        return query.getResultList();
    }

    @Override
    public boolean intersects(Shape s1, Shape s2) {
        String queryString = null;
        queryString = s1.getId() != null ? "select intersects(s1.geography, s2.geography) from Shape s1, s2 where s1.id=:s1 and s2.id=:s2" : "select intersects(:g1, s2.geography) from Shape s2 where s2.id=:s2";
        TypedQuery query = this.entityManager.createQuery(queryString, Boolean.class);
        if (s1.getId() != null) {
            query.setParameter("s1", (Object)s1.getId());
        } else {
            query.setParameter("g1", (Object)s1.getGeography());
        }
        query.setParameter("s2", (Object)s2.getId());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findTouches(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select * from \"Shape\" s where s.\"SHP_ID\" != cast (?1 as uuid) and ST_Touches(ST_GeometryFromText(?2,4326),cast (s.\"SHP_Geography\" as geometry))=true", Shape.class);
        query.setParameter(1, (Object)s.getId().toString());
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean touches(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        queryString = s1.getId() != null ? "select ST_Touches(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)" : "select ST_Touches(ST_GeometryFromText(?1,4326), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s2 where s2.\"SHP_ID\"=cast (?2 as uuid)";
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s1.getId() != null) {
            query.setParameter(1, (Object)s1.getId().toString());
        } else {
            query.setParameter(1, (Object)s1.getGeography().toText());
        }
        query.setParameter(2, (Object)s2.getId().toString());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findCrosses(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select * from \"Shape\" s where s.\"SHP_ID\" != cast(?1 as uuid) and ST_Crosses(ST_GeometryFromText(?2,4326),cast (s.\"SHP_Geography\" as geometry))=true", Shape.class);
        query.setParameter(1, (Object)s.getId().toString());
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean crosses(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        queryString = s1.getId() != null ? "select ST_Crosses(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast(?1 as uuid) and s2.\"SHP_ID\"=cast(?2 as uuid)" : "select ST_Crosses(ST_GeometryFromText(?1,4326), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s2 where s2.\"SHP_ID\"=cast(?2 as uuid)";
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s1.getId() != null) {
            query.setParameter(1, (Object)s1.getId().toString());
        } else {
            query.setParameter(1, (Object)s1.getGeography().toText());
        }
        query.setParameter(2, (Object)s2.getId().toString());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findWithin(Shape s) {
        this.entityManager.flush();
        StringBuilder queryString = new StringBuilder("select * from \"Shape\" s");
        queryString.append(" where ");
        if (s.getId() != null) {
            queryString.append("(s.\"SHP_ID\" != cast(?1 as uuid)) and ");
        }
        queryString.append("ST_Within(ST_GeometryFromText(?2,4326),cast (s.\"SHP_Geography\" as geometry))=true");
        Query query = this.entityManager.createNativeQuery(queryString.toString(), Shape.class);
        if (s.getId() != null) {
            query.setParameter(1, (Object)s.getId().toString());
        }
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean within(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        if (s1.getId() != null && s2.getId() != null) {
            queryString = "select ST_Within(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)";
        } else if (s1.getId() != null && s2.getId() == null) {
            queryString = "select ST_Within(cast (s1.\"SHP_Geography\" as geometry), ST_GeometryFromText(?1,4326)) from \"Shape\" s1 where s1.\"SHP_ID\"=cast (?2 as uuid)";
        } else if (s1.getId() == null && s2.getId() != null) {
            queryString = "select ST_Within(ST_GeometryFromText(?1,4326), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s2 where s2.\"SHP_ID\"=cast (?2 as uuid)";
        }
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s1.getId() != null && s2.getId() != null) {
            query.setParameter(1, (Object)s1.getId().toString());
            query.setParameter(2, (Object)s2.getId().toString());
        } else if (s1.getId() != null && s2.getId() == null) {
            query.setParameter(1, (Object)s2.getGeography().toText());
            query.setParameter(2, (Object)s1.getId().toString());
        } else if (s1.getId() == null && s2.getId() != null) {
            query.setParameter(1, (Object)s1.getGeography().toText());
            query.setParameter(2, (Object)s2.getId().toString());
        }
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findCovers(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select * from \"Shape\" s where s.\"SHP_ID\" != cast(?1 as uuid) and ST_Covers(cast(s.\"SHP_Geography\" as geometry), ST_GeometryFromText(?2,4326))=true", Shape.class);
        query.setParameter(1, (Object)s.getId().toString());
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean covers(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        queryString = s2.getId() != null ? (s2.getGeography() instanceof Point ? "select ST_Covers(s1.\"SHP_Geography\", s2.\"SHP_Geography\") from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)" : "select ST_Covers(cast(s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)") : (s2.getGeography() instanceof Point ? "select ST_Covers(s2.\"SHP_Geography\", ST_GeographyFromText(?2)) from \"Shape\" s2 where s2.\"SHP_ID\"=cast (?1 as uuid)" : "select ST_Covers(cast (s2.\"SHP_Geography\" as geometry), ST_GeometryFromText(?2,4326)) from \"Shape\" s2 where s2.\"SHP_ID\"=cast (?1 as uuid)");
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s2.getId() != null) {
            query.setParameter(2, (Object)s2.getId().toString());
        } else {
            query.setParameter(2, (Object)s2.getGeography().toText());
        }
        query.setParameter(1, (Object)s1.getId().toString());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findContains(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select * from \"Shape\" s where s.\"SHP_ID\" != cast (?1 as uuid) and ST_Contains(ST_GeometryFromText(?2,4326),cast (s.\"SHP_Geography\" as geometry))=true", Shape.class);
        query.setParameter(1, (Object)s.getId().toString());
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean contains(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        queryString = s1.getId() != null ? "select ST_Contains(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)" : "select ST_Contains(ST_GeometryFromText(?1,4326), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s2 where s2.\"SHP_ID\" =cast (?2 as uuid)";
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s1.getId() != null) {
            query.setParameter(1, (Object)s1.getId().toString());
        } else {
            query.setParameter(1, (Object)s1.getGeography().toText());
        }
        query.setParameter(2, (Object)s2.getId().toString());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findOverlaps(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select * from \"Shape\" s where s.\"SHP_ID\" != cast (?1 as uuid) and ST_Overlaps(ST_GeometryFromText(?2,4326),cast (s.\"SHP_Geography\" as geometry))=true", Shape.class);
        query.setParameter(1, (Object)s.getId().toString());
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean overlaps(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        queryString = s1.getId() != null ? "select ST_Overlaps(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)" : "select ST_Overlaps(ST_GeometryFromText(?1,4326), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s2 where s2.\"SHP_ID\" =cast (?2 as uuid)";
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s1.getId() != null) {
            query.setParameter(1, (Object)s1.getId().toString());
        } else {
            query.setParameter(1, (Object)s1.getGeography().toText());
        }
        query.setParameter(2, (Object)s2.getId().toString());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findRelate(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select * from \"Shape\" s where s.\"SHP_ID\" != cast(?1 as uuid) and ST_Relate(ST_GeometryFromText(?2,4326),cast (s.\"SHP_Geography\" as geometry))=true", Shape.class);
        query.setParameter(1, (Object)s.getId().toString());
        query.setParameter(2, (Object)s.getGeography().toText());
        return query.getResultList();
    }

    @Override
    public boolean relate(Shape s1, Shape s2) {
        this.entityManager.flush();
        String queryString = null;
        queryString = s1.getId() != null ? "select ST_Relate(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\" =cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)" : "select ST_Relate(ST_GeometryFromText(?1,4326), cast (s2.\"SHP_Geography\" as geometry)) from \"Shape\" s2 where s2.\"SHP_ID\" =cast (?2 as uuid)";
        Query query = this.entityManager.createNativeQuery(queryString);
        if (s1.getId() != null) {
            query.setParameter(1, (Object)s1.getId().toString());
        } else {
            query.setParameter(1, (Object)s1.getGeography().toText());
        }
        query.setParameter(2, (Object)s2.getId().toString());
        return (Boolean)query.getSingleResult();
    }

    @Override
    public List<Shape> findDistanceEqual(Shape s, double d) {
        TypedQuery query = this.entityManager.createQuery("from Shape s where s.id != :s and distance(s.geography, :g) = :d", Shape.class);
        query.setParameter("s", (Object)s.getId());
        query.setParameter("g", (Object)s.getGeography());
        query.setParameter("d", (Object)d);
        return query.getResultList();
    }

    @Override
    public List<Shape> findDistanceGreater(Shape s, double d) {
        TypedQuery query = this.entityManager.createQuery("from Shape s where s.id != :s and distance(s.geography, :g) > :d", Shape.class);
        query.setParameter("s", (Object)s.getId());
        query.setParameter("g", (Object)s.getGeography());
        query.setParameter("d", (Object)d);
        return query.getResultList();
    }

    @Override
    public List<Shape> findDistanceGreaterOrEqual(Shape s, double d) {
        TypedQuery query = this.entityManager.createQuery("from Shape s where s.id != :s and distance(s.geography, :g) >= :d", Shape.class);
        query.setParameter("s", (Object)s.getId());
        query.setParameter("g", (Object)s.getGeography());
        query.setParameter("d", (Object)d);
        return query.getResultList();
    }

    @Override
    public List<Shape> findDistanceLess(Shape s, double d) {
        TypedQuery query = this.entityManager.createQuery("from Shape s where s.id != :s and distance(s.geography, :g) < :d", Shape.class);
        query.setParameter("s", (Object)s.getId());
        query.setParameter("g", (Object)s.getGeography());
        query.setParameter("d", (Object)d);
        return query.getResultList();
    }

    @Override
    public List<Shape> findDistanceLessOrEqual(Shape s, double d) {
        TypedQuery query = this.entityManager.createQuery("from Shape s where s.id != :s and distance(s.geography, :g) <= :d", Shape.class);
        query.setParameter("s", (Object)s.getId());
        query.setParameter("g", (Object)s.getGeography());
        query.setParameter("d", (Object)d);
        return query.getResultList();
    }

    @Override
    public double distance(Shape s1, Shape s2) {
        TypedQuery query = this.entityManager.createQuery("select distance(s1.geography, s2.geography) from Shape s1, s2 where s1.id=:s1 and s2.id=:s2", Double.class);
        query.setParameter("s1", (Object)s1.getId());
        query.setParameter("s2", (Object)s2.getId());
        return (Double)query.getSingleResult();
    }

    @Override
    public double area(Shape s) {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select cast(ST_Area(s.\"SHP_Geography\") as text) from \"Shape\" s where s.\"SHP_ID\"=cast (?1 as uuid)");
        query.setParameter(1, (Object)s.getId().toString());
        String res = (String)query.getSingleResult();
        return Double.parseDouble(res);
    }

    @Override
    public Shape buffer(Shape s, float d) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select buffer(s.geography,:d) from Shape s where s.id = :s", Geometry.class);
        query.setParameter("s", (Object)s.getId());
        query.setParameter("d", (Object)Float.valueOf(d));
        Geometry buffer = (Geometry)query.getSingleResult();
        buffer.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s.getCode());
        res.setCreatorID(s.getCreatorID());
        res.setGeography(buffer);
        res.setName(s.getName() + "_buffer");
        res.setShapeClass(s.getShapeClass());
        return res;
    }

    @Override
    public Shape convexHull(Shape s) throws Exception {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select ST_AsText(ST_ConvexHull(cast (s.\"SHP_Geography\" as geometry))) from \"Shape\" s where s.\"SHP_ID\"=cast (?1 as uuid)");
        query.setParameter(1, (Object)s.getId().toString());
        String ch = (String)query.getSingleResult();
        WKTReader reader = new WKTReader();
        Geometry convexHull = reader.read(ch);
        convexHull.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s.getCode());
        res.setCreatorID(s.getCreatorID());
        res.setGeography(convexHull);
        res.setName(s.getName() + "_convexHull");
        res.setShapeClass(s.getShapeClass());
        return res;
    }

    @Override
    public Shape intersection(Shape s1, Shape s2) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select intersection(s1.geography, s2.geography) from Shape s1, s2 where s1.id = :s1 and s2.id = :s2", Geometry.class);
        query.setParameter("s1", (Object)s1.getId());
        query.setParameter("s2", (Object)s2.getId());
        Geometry intersection = (Geometry)query.getSingleResult();
        intersection.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s1.getCode());
        res.setCreatorID(s1.getCreatorID());
        res.setGeography(intersection);
        res.setName(s1.getName());
        res.setShapeClass(s1.getShapeClass());
        return res;
    }

    @Override
    public Shape union(Shape s1, Shape s2) throws Exception {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select ST_AsText(ST_Union(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry))) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)");
        query.setParameter(1, (Object)s1.getId().toString());
        query.setParameter(2, (Object)s2.getId().toString());
        Object u1 = query.getSingleResult();
        String u = (String)query.getSingleResult();
        WKTReader reader = new WKTReader();
        Geometry union = reader.read(u);
        union.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s1.getCode());
        res.setCreatorID(s1.getCreatorID());
        res.setGeography(union);
        res.setName(s1.getName());
        res.setShapeClass(s1.getShapeClass());
        return res;
    }

    @Override
    public Shape difference(Shape s1, Shape s2) throws Exception {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select ST_AsText(ST_Difference(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry))) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)");
        query.setParameter(1, (Object)s1.getId().toString());
        query.setParameter(2, (Object)s2.getId().toString());
        String d = (String)query.getSingleResult();
        WKTReader reader = new WKTReader();
        Geometry difference = reader.read(d);
        difference.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s1.getCode());
        res.setCreatorID(s1.getCreatorID());
        res.setGeography(difference);
        res.setName(s1.getName());
        res.setShapeClass(s1.getShapeClass());
        return res;
    }

    @Override
    public Shape symDifference(Shape s1, Shape s2) throws Exception {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select ST_AsText(ST_SymDifference(cast (s1.\"SHP_Geography\" as geometry), cast (s2.\"SHP_Geography\" as geometry))) from \"Shape\" s1, \"Shape\" s2 where s1.\"SHP_ID\"=cast (?1 as uuid) and s2.\"SHP_ID\"=cast (?2 as uuid)");
        query.setParameter(1, (Object)s1.getId().toString());
        query.setParameter(2, (Object)s2.getId().toString());
        String d = (String)query.getSingleResult();
        WKTReader reader = new WKTReader();
        Geometry difference = reader.read(d);
        difference.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s1.getCode());
        res.setCreatorID(s1.getCreatorID());
        res.setGeography(difference);
        res.setName(s1.getName());
        res.setShapeClass(s1.getShapeClass());
        return res;
    }

    @Override
    public Shape transform(Shape s, int srid) throws Exception {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select ST_AsText(ST_Transform(cast (s.\"SHP_Geography\" as geometry)),?1) from \"Shape\" s where s.\"SHP_ID\"=cast (?2 as uuid)");
        query.setParameter(1, (Object)srid);
        query.setParameter(2, (Object)s.getId().toString());
        String t = (String)query.getSingleResult();
        WKTReader reader = new WKTReader();
        Geometry transformed = reader.read(t);
        transformed.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s.getCode());
        res.setCreatorID(s.getCreatorID());
        res.setGeography(transformed);
        res.setName(s.getName());
        res.setShapeClass(s.getShapeClass());
        return res;
    }

    @Override
    public Shape extent(Shape s) throws Exception {
        this.entityManager.flush();
        Query query = this.entityManager.createNativeQuery("select ST_AsText(ST_Extent(cast (s.\"SHP_Geography\" as geometry))) from \"Shape\" s where s.\"SHP_ID\"=cast (?1 as uuid)");
        query.setParameter(1, (Object)s.getId().toString());
        String e = (String)query.getSingleResult();
        WKTReader reader = new WKTReader();
        Geometry extent = reader.read(e);
        extent.setSRID(4326);
        Shape res = new Shape();
        res.setCode(s.getCode());
        res.setCreatorID(s.getCreatorID());
        res.setGeography(extent);
        res.setName(s.getName() + "_extent");
        res.setShapeClass(s.getShapeClass());
        return res;
    }

    @Override
    public Shape loadDetails(Shape s) {
        return s;
    }
}

