/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.shape.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.shape.ShapeDocument;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeDocumentDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermShape;
import java.util.List;
import java.util.UUID;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository
public class ShapeDocumentDaoImpl
extends JpaDao<ShapeDocument, UUID>
implements ShapeDocumentDao {
    @Override
    public ShapeDocument find(TaxonomyTermShape tts, Document d) {
        TypedQuery query = this.entityManager.createQuery("from ShapeDocument sd where sd.taxonomyTermShape = :tts and sd.document = :d", ShapeDocument.class);
        query.setParameter("tts", (Object)tts);
        query.setParameter("d", (Object)d);
        try {
            return (ShapeDocument)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<ShapeDocument> findByDocument(Document d) {
        TypedQuery query = this.entityManager.createQuery("from ShapeDocument sd  where sd.document = :d", ShapeDocument.class);
        query.setParameter("d", (Object)d);
        return query.getResultList();
    }

    @Override
    public List<Document> findDocumentsByTaxonomyTermShape(TaxonomyTermShape tts) {
        TypedQuery query = this.entityManager.createQuery("select sd.document from ShapeDocument sd  where sd.taxonomyTermShape = :tts", Document.class);
        query.setParameter("tts", (Object)tts);
        return query.getResultList();
    }

    @Override
    public List<ShapeDocument> findByTaxonomyTermShape(TaxonomyTermShape tts) {
        TypedQuery query = this.entityManager.createQuery("from ShapeDocument sd  where sd.taxonomyTermShape = :tts", ShapeDocument.class);
        query.setParameter("tts", (Object)tts);
        return query.getResultList();
    }

    @Override
    public Document findUniqueByTaxonomyTermShape(TaxonomyTermShape tts) {
        TypedQuery query = this.entityManager.createQuery("select sd.document from ShapeDocument sd  where sd.taxonomyTermShape = :tts", Document.class);
        query.setParameter("tts", (Object)tts);
        try {
            return (Document)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public void deleteByTaxonomyTermShape(TaxonomyTermShape tts) {
        Query query = this.entityManager.createQuery("delete ShapeDocument sd where sd.taxonomyTermShape = :tts");
        query.setParameter("tts", (Object)tts);
        query.executeUpdate();
    }

    @Override
    public void deleteByDocument(Document d) {
        Query query = this.entityManager.createQuery("delete ShapeDocument sd where sd.document = :d");
        query.setParameter("d", (Object)d);
        query.executeUpdate();
    }

    @Override
    public ShapeDocument loadDetails(ShapeDocument sd) {
        sd.getTaxonomyTermShape().getId();
        sd.getCreator().getName();
        sd.getDocument().getId();
        return sd;
    }
}

