/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.util.DefaultInternationalString;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.util.InternationalString;

public class Parsers {
    public static List<String> parseList(String property) {
        String[] values = property.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values) {
            list.add(value);
        }
        return list;
    }

    public static List<TopicCategory> parseTopicCategoryList(String property) {
        String[] values = property.split(",");
        ArrayList<TopicCategory> list = new ArrayList<TopicCategory>();
        for (String value : values) {
            list.add(TopicCategory.valueOf((String)value));
        }
        return list;
    }

    public static DefaultExtent parseExtentList(String property) {
        String[] values = property.split(",");
        double[] array = new double[4];
        int index = 0;
        DefaultExtent extent = new DefaultExtent();
        for (String value : values) {
            if (value.equals("WORLD")) {
                array[0] = -180.0;
                array[1] = 180.0;
                array[2] = -90.0;
                array[3] = 90.0;
                break;
            }
            array[index] = Double.parseDouble(value);
            ++index;
        }
        extent.setGeographicElements(Collections.singleton(new DefaultGeographicBoundingBox(array[0], array[1], array[2], array[3])));
        extent.setDescription((InternationalString)new DefaultInternationalString("Bounding box"));
        return extent;
    }
}

