package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.elements;

import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Layer;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.elements.Contact.Role;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils.BuildWmsUrl;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils.Parsers;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils.ReadMetadataProperties;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.util.DefaultInternationalString;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.TopologyLevel;

public class MetaDataForm {
	
	public static enum Language {
		ENGLISH, 
		FRENCH, GERMAN, 
		ITALIAN,JAPANESE, 
		KOREAN, CHINESE, 
		SIMPLIFIED_CHINESE,TRADITIONAL_CHINESE
	}
	
	private String user;
	private String title;
	private Date date;
	private String abstractField;
	private String purpose;
	private PresentationForm presentationForm;
	private List<String> credits;
	private List<String> keywords;
	private List<TopicCategory> topicCategory;
	private DefaultExtent extent;
	private GeometricObjectType geometricObjectType;
	private TopologyLevel topologyLevel;
	private int geometrycount;
	private double resolution;
	private String graphicOverview;
	
	private String projectName;
	
	private Contact provider;
	private Contact distributor;
	
	
	private String userLimitation;
	
	private Language language;

	public MetaDataForm(String user, String title, Date date) {
		
		Properties properties = ReadMetadataProperties.getInstance().getProperties();
		
		this.provider = new Contact();
		this.distributor = new Contact();
		
		this.provider.setRole(Role.RESOURCE_PROVIDER);
		this.distributor.setRole(Role.DISTRIBUTOR);
		
		this.user = user;
		this.title = title;
		this.date = date;
		this.abstractField = properties.getProperty("abstract");
		this.purpose = properties.getProperty("purpose");
		this.presentationForm = PresentationForm.valueOf(properties.getProperty("presentationForm"));
		this.credits = Parsers.parseList(properties.getProperty("credits"));
		this.keywords = Parsers.parseList(properties.getProperty("keywords"));
		this.topicCategory = Parsers.parseTopicCategoryList(properties.getProperty("topicCategory"));
		this.extent = (DefaultExtent) Parsers.parseExtentList(properties.getProperty("extent"));
		this.geometricObjectType = GeometricObjectType.valueOf(properties.getProperty("geometricObjectType"));
		this.topologyLevel = TopologyLevel.valueOf(properties.getProperty("topologyLevel"));
		this.geometrycount = Integer.parseInt(properties.getProperty("geometryCount"));
		this.resolution = Double.parseDouble(properties.getProperty("resolution"));
		this.graphicOverview = properties.getProperty("graphicOverview");
		this.projectName = properties.getProperty("projectName");
		this.language = Language.ENGLISH;
		
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getAbstractField() {
		return abstractField;
	}

	public void setAbstractField(String abstractField) {
		this.abstractField = abstractField;
	}

	public String getPurpose() {
		return purpose;
	}

	public void setPurpose(String purpose) {
		this.purpose = purpose;
	}

	public PresentationForm getPresentationForm() {
		return presentationForm;
	}

	public void setPresentationForm(PresentationForm presentationForm) {
		this.presentationForm = presentationForm;
	}

	public List<String> getCredits() {
		return credits;
	}

	public void setCredits(List<String> credits) {
		this.credits = credits;
	}

	public List<String> getKeywords() {
		return keywords;
	}

	public void setKeywords(List<String> keywords) {
		this.keywords = keywords;
	}

	public List<TopicCategory> getTopicCategory() {
		return topicCategory;
	}

	public void setTopicCategory(List<TopicCategory> topicCategory) {
		this.topicCategory = topicCategory;
	}

	public DefaultExtent getExtent() {
		return extent;
	}

	public void setExtent(double west,double east,double south,double north) {
		DefaultExtent extent = new DefaultExtent();
		extent.setGeographicElements(Collections.singleton(new DefaultGeographicBoundingBox(west, east, south, north)));
		extent.setDescription(new DefaultInternationalString("Bounding box"));
		this.extent = extent;
	}

	public GeometricObjectType getGeometricObjectType() {
		return geometricObjectType;
	}

	public void setGeometricObjectType(GeometricObjectType geometricObjectType) {
		this.geometricObjectType = geometricObjectType;
	}

	public TopologyLevel getTopologyLevel() {
		return topologyLevel;
	}

	public void setTopologyLevel(TopologyLevel topologyLevel) {
		this.topologyLevel = topologyLevel;
	}

	public int getGeometrycount() {
		return geometrycount;
	}

	public void setGeometrycount(int geometrycount) {
		this.geometrycount = geometrycount;
	}

	public double getResolution() {
		return resolution;
	}

	public void setResolution(double resolution) {
		this.resolution = resolution;
	}

	public String getGraphicOverview() {
		return graphicOverview;
	}

	public void setGraphicOverviewExternal(String graphicOverview) {
		this.graphicOverview = graphicOverview;
	}
	
	public void setGraphicOverviewFromLayer(Layer layer,FeatureType featureType,String geoserverUrl) {
		
		Bounds bBox = featureType.getLatLonBoundingBox();
		String bBoxString = bBox.getMinx()+","+bBox.getMiny()+","+bBox.getMaxx()+","+bBox.getMaxy();
		BuildWmsUrl wmsUrl = new BuildWmsUrl(geoserverUrl, layer.getWorkspace(), layer.getName(), "400",  "600",bBoxString , featureType.getSrs());
		
		this.graphicOverview = wmsUrl.getFinalWmsUrl();
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public Contact getProvider() {
		return provider;
	}
	
	public void setProviderIndividualName(String name) {
		this.provider.setIndividualName(name);
	}
	
	public void setProviderOrganisationName(String organisationName) {
		this.provider.setOrganisationName(organisationName);
	}
	
	public void setProviderSite(String site) {
		this.provider.setSite(site);
	}

	public Contact getDistributor() {
		return distributor;
	}

	public void setDistributorIndividualName(String name) {
		this.distributor.setIndividualName(name);
	}
	
	public void setDistributorOrganisationName(String organisationName) {
		this.distributor.setOrganisationName(organisationName);
	}
	
	public void setDistributorSite(String site) {
		this.distributor.setSite(site);
	}

	public String getUserLimitation() {
		return userLimitation;
	}

	public void setUserLimitation(String userLimitation) {
		this.userLimitation = userLimitation;
	}

	public Language getLanguage() {
		return language;
	}

	public void setLanguage(Language language) {
		this.language = language;
	}	
}
