package gr.cite.geoanalytics.dataaccess.geoserverbridge.elements;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataStore implements Serializable {
	private static final long serialVersionUID = -7040585582432145861L;

	private String dataStoreName = "";
	private String workspace = "";
	private String type = "";
	private String dbType = "";
	private String description = "";
	private String user = "";
	private String password = "";
	private String database = "";
	private String host = "";
	private int port;

	private boolean enabled = false;

	private Map<String, String> connectionParameters = new HashMap<String, String>();

	public String getDataStoreName() {
		return dataStoreName;
	}

	public void setDataStoreName(String dataStoreName) {
		this.dataStoreName = dataStoreName;
	}

	public String getWorkspace() {
		return workspace;
	}

	public void setWorkspace(String workspace) {
		this.workspace = workspace;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getDbType() {
		return dbType;
	}

	public void setDbType(String dbType) {
		this.dbType = dbType;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public boolean isEnabled() {
		return enabled;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	public Map<String, String> getConnectionParameters() {
		return connectionParameters;
	}

	public void setConnectionParameters(Map<String, String> connectionParameters) {
		this.connectionParameters = connectionParameters;
	}

	public void setConnectionParameter(String key, String value) {
		this.connectionParameters.put(key, value);
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getDatabase() {
		return database;
	}

	public void setDatabase(String database) {
		this.database = database;
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}
}
