/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.elements;

import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.elements.MetaDataForm;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.spatial.data.geonetwork.iso.EnvironmentConfiguration;
import org.gcube.spatial.data.geonetwork.iso.GcubeISOMetadata;
import org.gcube.spatial.data.geonetwork.iso.MissingInformationException;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.util.DefaultInternationalString;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.TopologyLevel;
import org.opengis.util.InternationalString;

public class MetaData {
    private GcubeISOMetadata gcubeMetadata;
    private EnvironmentConfiguration configuration;
    private Locale Language;

    public MetaData(String tenantName) throws Exception {
        ScopeProvider.instance.set(tenantName);
        this.gcubeMetadata = new GcubeISOMetadata();
        this.configuration = this.gcubeMetadata.getConfig();
        this.configuration.setHttpProtocolDeclaration(null);
        this.configuration.setProviderEMail(null);
        this.configuration.setDistributorEMail(null);
        this.Language = Locale.ENGLISH;
    }

    public Metadata getMetadata() throws URISyntaxException, MissingInformationException {
        DefaultMetadata meta = (DefaultMetadata)this.gcubeMetadata.getMetadata();
        meta.setLanguage(this.Language);
        return meta;
    }

    public void setProjectName(String projectName) {
        this.configuration.setProjectName(projectName);
    }

    public String getProjectName() {
        return this.configuration.getProjectName();
    }

    public Locale getLanguage() {
        return this.Language;
    }

    public void setLanguage(MetaDataForm.Language lang) {
        switch (lang) {
            case ENGLISH: {
                this.Language = Locale.ENGLISH;
                break;
            }
            case FRENCH: {
                this.Language = Locale.FRENCH;
                break;
            }
            case GERMAN: {
                this.Language = Locale.GERMAN;
                break;
            }
            case ITALIAN: {
                this.Language = Locale.ITALIAN;
                break;
            }
            case JAPANESE: {
                this.Language = Locale.JAPANESE;
                break;
            }
            case KOREAN: {
                this.Language = Locale.KOREAN;
                break;
            }
            case CHINESE: {
                this.Language = Locale.CHINESE;
                break;
            }
            case SIMPLIFIED_CHINESE: {
                this.Language = Locale.SIMPLIFIED_CHINESE;
                break;
            }
            case TRADITIONAL_CHINESE: {
                this.Language = Locale.TRADITIONAL_CHINESE;
                break;
            }
            default: {
                this.Language = Locale.ENGLISH;
            }
        }
    }

    public String getProviderSite() {
        return this.configuration.getProviderSite();
    }

    public void setProviderSite(String providerSite) {
        if (providerSite != null) {
            this.configuration.setProviderSite(providerSite);
        }
    }

    public String getProviderOrganisationName() {
        return this.configuration.getProviderOrganisationName();
    }

    public void setProviderOrganisationName(String providerOrganisationName) {
        if (providerOrganisationName != null) {
            this.configuration.setProviderOrganisationName(providerOrganisationName);
        }
    }

    public String getProviderIndividualName() {
        return this.configuration.getProviderIndividualName();
    }

    public void setProviderIndividualName(String providerIndividualName) {
        if (providerIndividualName != null) {
            this.configuration.setProviderIndividualName(providerIndividualName);
        }
    }

    public String getUserLimitation() {
        return this.configuration.getLicense();
    }

    public void setUserLimitation(String licence) {
        this.configuration.setLicense(licence);
    }

    public String getDistributorSite() {
        return this.configuration.getDistributorSite();
    }

    public void setDistributorSite(String distributorSite) {
        if (distributorSite != null) {
            this.configuration.setDistributorSite(distributorSite);
        }
    }

    public String getDistributorOrganisationName() {
        return this.configuration.getDistributorOrganisationName();
    }

    public void setDistributorOrganisationName(String distributorOrganisationName) {
        if (distributorOrganisationName != null) {
            this.configuration.setDistributorOrganisationName(distributorOrganisationName);
        }
    }

    public String getDistributorIndividualName() {
        return this.configuration.getDistributorIndividualName();
    }

    public void setDistributorIndividualName(String distributorIndividualName) {
        if (distributorIndividualName != null) {
            this.configuration.setDistributorIndividualName(distributorIndividualName);
        }
    }

    public String getUser() {
        return this.gcubeMetadata.getUser();
    }

    public void setUser(String user) {
        this.gcubeMetadata.setUser(user);
    }

    public String getTitle() {
        return this.gcubeMetadata.getTitle();
    }

    public void setTitle(String title) {
        this.gcubeMetadata.setTitle(title);
    }

    public Date getDate() {
        return this.gcubeMetadata.getCreationDate();
    }

    public void setDate(Date date) {
        this.gcubeMetadata.setCreationDate(date);
    }

    public PresentationForm getPresentationForm() {
        return this.gcubeMetadata.getPresentationForm();
    }

    public void setPresentationForm(PresentationForm presentationForm) {
        this.gcubeMetadata.setPresentationForm(presentationForm);
    }

    public String getMetadataAbstract() {
        return this.gcubeMetadata.getAbstractField();
    }

    public void setMetadataAbstract(String metadataAbstract) {
        this.gcubeMetadata.setAbstractField(metadataAbstract);
    }

    public String getMetadataPurpose() {
        return this.gcubeMetadata.getPurpose();
    }

    public void setMetadataPurpose(String metadataPurpose) {
        this.gcubeMetadata.setPurpose(metadataPurpose);
    }

    public List<String> getCredits() {
        return this.gcubeMetadata.getCredits();
    }

    public void setCredits(List<String> credits) {
        for (String credit : credits) {
            this.gcubeMetadata.addCredits(credit);
        }
    }

    public void addCredit(String credit) {
        this.gcubeMetadata.addCredits(credit);
    }

    public HashMap<Thesaurus, HashSet<String>> getKeywords() {
        return this.gcubeMetadata.getDescriptiveKeywords();
    }

    public void setKeywords(List<String> keywords) {
        for (String keyword : keywords) {
            this.gcubeMetadata.addKeyword(keyword, (Thesaurus)this.gcubeMetadata.getConfig().getThesauri().get("General"));
        }
    }

    public void addKeyword(String keyword) {
        this.gcubeMetadata.addKeyword(keyword, (Thesaurus)this.gcubeMetadata.getConfig().getThesauri().get("General"));
    }

    public List<TopicCategory> getTopicCategory() {
        return this.gcubeMetadata.getTopicCategories();
    }

    public void setTopicCategory(List<TopicCategory> topicCategory) {
        for (TopicCategory topic : topicCategory) {
            this.gcubeMetadata.addTopicCategory(topic);
        }
    }

    public void addTopicCategory(TopicCategory topicCategory) {
        this.gcubeMetadata.addTopicCategory(topicCategory);
    }

    public DefaultExtent getExtent() {
        return this.gcubeMetadata.getExtent();
    }

    public void setExtent(double west, double east, double south, double north) {
        DefaultExtent extent = new DefaultExtent();
        extent.setGeographicElements(Collections.singleton(new DefaultGeographicBoundingBox(west, east, south, north)));
        extent.setDescription((InternationalString)new DefaultInternationalString("Bounding box"));
    }

    public void setExtent(DefaultExtent extent) {
        this.gcubeMetadata.setExtent(extent);
    }

    public GeometricObjectType getGeometricObjectType() {
        return this.gcubeMetadata.getGeometricObjectType();
    }

    public void setGeometricObjectType(GeometricObjectType geometricObjectType) {
        this.gcubeMetadata.setGeometricObjectType(geometricObjectType);
    }

    public TopologyLevel getTopologyLevel() {
        return this.gcubeMetadata.getTopologyLevel();
    }

    public void setTopologyLevel(TopologyLevel topologyLevel) {
        this.gcubeMetadata.setTopologyLevel(topologyLevel);
    }

    public int getGeometryCount() {
        return this.gcubeMetadata.getGeometryCount();
    }

    public void setGeometryCount(int geometryCount) {
        this.gcubeMetadata.setGeometryCount(geometryCount);
    }

    public double getResolution() {
        return this.gcubeMetadata.getResolution();
    }

    public void setResolution(double resolution) {
        this.gcubeMetadata.setResolution(resolution);
    }

    public String getGraphicOverview() {
        return (String)this.gcubeMetadata.getGraphicOverviewsURI().get(0);
    }

    public void setGraphicOverview(String graphicOverview) {
        this.gcubeMetadata.addGraphicOverview(graphicOverview);
    }
}

