/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.commons.util.datarepository.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import gr.cite.commons.util.datarepository.api.DataRepositoryClient;
import gr.cite.commons.util.datarepository.elements.RepositoryFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDataRepositoryClient
implements DataRepositoryClient {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemDataRepositoryClient.class);
    private static String INSERTBASE64_PATH = "insertBase64";
    private static String INSERTINPUTSTREAM_PATH = "insertInputStream";
    private static String GETBASE64URI_PATH = "getBase64URI";
    private static String GETFILE_PATH = "getFile";
    private static String REMOVEFILE_PATH = "removeFile";
    private static final String TEMP_FOLDER_PREFIX = "dataRepositoryClientTempFolder";
    private static final String TEMP_FILEPREFIX = "";
    private static final String TEMP_FILESUFFIX = "";
    private WebResource resource;
    private String hostname;

    protected static Client defaultClientFactory() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(ObjectMapperProvider.class);
        return Client.create((ClientConfig)clientConfig);
    }

    public FileSystemDataRepositoryClient() {
    }

    public FileSystemDataRepositoryClient(String hostname) {
        this(FileSystemDataRepositoryClient.defaultClientFactory(), hostname);
    }

    public FileSystemDataRepositoryClient(Client client, String hostname) {
        this.hostname = hostname;
        this.resource = client.resource(hostname);
    }

    @Resource(name="remoteFileRepositoryHostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
        Client cl = FileSystemDataRepositoryClient.defaultClientFactory();
        this.resource = cl.resource(hostname);
    }

    @Override
    public String insertBase64File(String base64uri) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.resource.path(INSERTBASE64_PATH).entity((Object)base64uri, "multipart/form-data").accept(new String[]{"application/xml"})).post(ClientResponse.class);
        RepositoryFile file = (RepositoryFile)response.getEntity(RepositoryFile.class);
        return UriBuilder.fromPath((String)this.hostname).path(GETFILE_PATH).path(file.getId()).build(new Object[0]).toString();
    }

    @Override
    public String insertBytes(byte[] inputBytes, String dataType) {
        RepositoryFile file = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(inputBytes);){
            ClientResponse response = (ClientResponse)((WebResource.Builder)this.resource.path(INSERTINPUTSTREAM_PATH).queryParam("datatype", dataType).entity((Object)inputStream, "application/octet-stream").accept(new String[]{"application/xml"})).post(ClientResponse.class);
            file = (RepositoryFile)response.getEntity(RepositoryFile.class);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return UriBuilder.fromPath((String)this.hostname).path(GETFILE_PATH).path(file.getId()).build(new Object[0]).toString();
    }

    @Override
    public String insertFileFromUrl(String fileUrl) {
        URL url = null;
        try {
            url = new URL(fileUrl);
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String dataType = null;
        InputStream stream = null;
        try {
            URLConnection con = url.openConnection();
            dataType = con.getContentType();
            stream = con.getInputStream();
        }
        catch (IOException | IllegalArgumentException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
        String dataRepositoryUrl = null;
        try {
            dataRepositoryUrl = this.insertBytes(IOUtils.toByteArray((InputStream)stream), dataType);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return dataRepositoryUrl;
    }

    @Override
    public String getFileInBase64URI(String fileId) {
        ClientResponse response = (ClientResponse)this.resource.path(GETBASE64URI_PATH).path(fileId).get(ClientResponse.class);
        return (String)response.getEntity(String.class);
    }

    @Override
    public String getFileUrl(String fileId) {
        return UriBuilder.fromPath((String)this.hostname).path(GETFILE_PATH).path(fileId).build(new Object[0]).toString();
    }

    @Override
    public void removeFile(String fileId) {
        this.resource.path(REMOVEFILE_PATH).path(fileId).post(ClientResponse.class);
    }

    public String persist(RepositoryFile file) throws Exception {
        String str = (String)((WebResource.Builder)this.resource.path("persist").entity((Object)file, "application/json").accept(new String[]{"application/json"})).post(String.class);
        RepositoryFile rf = (RepositoryFile)new ObjectMapper().readValue((Reader)new StringReader(str), RepositoryFile.class);
        file.setLocalImage(rf.getLocalImage());
        if (rf.getState() == RepositoryFile.State.PERSISTED) {
            file.markPersisted();
        }
        file.setId(rf.getId());
        return rf.getId();
    }

    public String update(RepositoryFile file) throws Exception {
        return (String)this.resource.path("update").entity((Object)file, "application/json").post(String.class);
    }

    public RepositoryFile retrieve(String id) throws Exception {
        String str = (String)this.resource.path("retrieve").path(id).accept(new String[]{"application/json"}).get(String.class);
        return (RepositoryFile)new ObjectMapper().readValue((Reader)new StringReader(str), RepositoryFile.class);
    }

    public void delete(String id) throws Exception {
        this.resource.path("delete").path(id).post();
    }

    public List<String> listIds() throws Exception {
        return (List)this.resource.path("listIds").get((GenericType)new GenericType<List<String>>(){});
    }

    public String persistToFolder(List<RepositoryFile> files) throws Exception {
        return (String)this.resource.path("persistToFolder").entity(files, "application/json").post(String.class);
    }

    public String updateToFolder(RepositoryFile file, String folderId) throws Exception {
        return (String)this.resource.path("updateToFolder").path(folderId).entity((Object)file, "application/json").post(String.class);
    }

    public String updateToFolder(List<RepositoryFile> files, String folderId) throws Exception {
        return (String)this.resource.path("updateToFolder").path(folderId).entity(files, "application/json").post(String.class);
    }

    public String addToFolder(RepositoryFile file, String folderId) throws Exception {
        return (String)this.resource.path("addToFolder").path(folderId).entity((Object)file, "application/json").post(String.class);
    }

    public String addToFolder(List<RepositoryFile> files, String folderId) throws Exception {
        return (String)this.resource.path("addToFolderMultipleFiles").path(folderId).entity(files, "application/json").post(String.class);
    }

    public File retrieveFolder(String folderId) throws Exception {
        List<String> fileIds = this.listFolder(folderId);
        Path folder = Files.createTempDirectory(TEMP_FOLDER_PREFIX, new FileAttribute[0]);
        for (String fileId : fileIds) {
            RepositoryFile rf = this.retrieve(fileId);
            Path f = Files.createFile(folder.resolve(rf.getOriginalName()), new FileAttribute[0]);
            FileOutputStream out = new FileOutputStream(f.toFile());
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)rf.getInputStream(), (OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
        return folder.toFile();
    }

    public List<String> listFolder(String folderId) throws Exception {
        return (List)this.resource.path("listFolder").path(folderId).get((GenericType)new GenericType<List<String>>(){});
    }

    public long getTotalSize() {
        return Long.parseLong((String)((ClientResponse)this.resource.path("getTotalSize").get(ClientResponse.class)).getEntity(String.class));
    }

    public Long getLastSweep() {
        ClientResponse response = (ClientResponse)this.resource.path("getLastSweep").get(ClientResponse.class);
        return response.getStatus() == Response.Status.OK.getStatusCode() ? Long.valueOf(Long.parseLong((String)response.getEntity(String.class))) : null;
    }

    public Long getSweepSizeReduction() {
        ClientResponse response = (ClientResponse)this.resource.path("getSweepSizeReduction").get(ClientResponse.class);
        return response.getStatus() == Response.Status.OK.getStatusCode() ? Long.valueOf(Long.parseLong((String)response.getEntity(String.class))) : null;
    }

    public Long close(RepositoryFile file) throws Exception {
        return -1L;
    }

    public static void main(String[] args) {
        FileSystemDataRepositoryClient client = new FileSystemDataRepositoryClient("http://localhost:8080/data-repository-application/datarepository");
        RepositoryFile file = new RepositoryFile();
        file.setId(UUID.randomUUID().toString());
        file.setDataType("datatype");
        file.setInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2}));
        file.setTimestamp(System.currentTimeMillis());
        RepositoryFile file1 = new RepositoryFile();
        file1.setId(UUID.randomUUID().toString());
        file1.setDataType("datatype");
        file1.setInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2}));
        file1.setTimestamp(System.currentTimeMillis());
        try {
            System.out.println(client.listFolder("b537702f-9087-4358-aa9c-85f7d481407c"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Provider
    public static class ObjectMapperProvider
    implements ContextResolver<ObjectMapper> {
        final ObjectMapper defaultObjectMapper = ObjectMapperProvider.createDefaultMapper();

        public ObjectMapper getContext(Class<?> type) {
            return this.defaultObjectMapper;
        }

        private static ObjectMapper createDefaultMapper() {
            ObjectMapper mapper = new ObjectMapper();
            return mapper;
        }
    }
}

