/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.UUID;
import org.apache.commons.validator.EmailValidator;
import org.springframework.stereotype.Component;

@Component
public class Utilities {
    public String readFile(String fileName) throws IOException {
        String line;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder friendRequestTemplate = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            friendRequestTemplate.append(line);
        }
        reader.close();
        return friendRequestTemplate.toString();
    }

    public String getBody(String firstName, String domainName, String generatedUUID) throws IOException {
        String template = this.readFile("FriendRequestTemplate.html");
        String link = domainName + "/c" + "/portal/email_addresses/verify_email" + "?code=" + generatedUUID;
        String body = MessageFormat.format(template, firstName, link);
        return body;
    }

    public String getSubject(String domainName) {
        String subject = domainName + ", " + "Verify your email address";
        return subject;
    }

    public boolean validateEmail(String email) {
        EmailValidator emailValidator = EmailValidator.getInstance();
        return emailValidator.isValid(email);
    }

    public UUID generateUUID() {
        return UUID.randomUUID();
    }
}

