/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.additionalemailaddresses;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import gr.cite.additionalemailaddresses.authorize.Authorize;
import gr.cite.additionalemailaddresses.models.AdditionalEmailAddresses;
import gr.cite.additionalemailaddresses.models.IsEmailAddressAlreadyUsedResponse;
import gr.cite.additionalemailaddresses.models.ResponseMessage;
import gr.cite.additionalemailaddresses.service.AdditionalEmailAddressesService;
import gr.cite.additionalemailaddresses.utils.Json;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class HomeController {
    private static Log log = LogFactoryUtil.getLog(HomeController.class);
    private AdditionalEmailAddressesService additionalEmailAddressesService;
    private Authorize autorize;

    @Autowired
    public void setAdditionalEmailAddressesManager(AdditionalEmailAddressesService additionalEmailAddressesService) {
        this.additionalEmailAddressesService = additionalEmailAddressesService;
    }

    @Autowired
    public void setAutorize(Authorize autorize) {
        this.autorize = autorize;
    }

    @RenderMapping
    public String viewHomePage(RenderRequest renderRequest, RenderResponse renderResponse) {
        Boolean hasPerirmision = this.autorize.hasPermisions((PortletRequest)renderRequest);
        return hasPerirmision != false ? "home" : "hide";
    }

    @ResourceMapping(value="sendEmailVerification")
    public void sendEmailVerification(@RequestParam(value="emailAddress") String emailAddress, ResourceRequest request, ResourceResponse response) throws IOException {
        ResponseMessage responseMessage = null;
        try {
            this.additionalEmailAddressesService.sendEmailVerification(request, response, emailAddress);
            AdditionalEmailAddresses additionalEmailAddresses = this.additionalEmailAddressesService.getEmailAddresses(request);
            responseMessage = new ResponseMessage((Object)additionalEmailAddresses, null, Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            responseMessage = new ResponseMessage(null, e.getMessage(), Boolean.valueOf(false));
        }
        Json.returnDeepJson((ResourceResponse)response, (Object)responseMessage);
    }

    @ResourceMapping(value="listAdditionalEmailAddresses")
    public void listAdditionalEmailAddresses(ResourceRequest request, ResourceResponse response) throws IOException {
        ResponseMessage responseMessage = null;
        try {
            AdditionalEmailAddresses additionalEmailAddresses = this.additionalEmailAddressesService.getEmailAddresses(request);
            responseMessage = new ResponseMessage((Object)additionalEmailAddresses, null, Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            responseMessage = new ResponseMessage(null, e.getMessage(), Boolean.valueOf(false));
        }
        Json.returnDeepJson((ResourceResponse)response, (Object)responseMessage);
    }

    @ResourceMapping(value="isEmailAddressAlreadyUsed")
    public void isEmailAddressAlreadyUsed(@RequestParam(value="emailAddress") String emailAddress, ResourceRequest request, ResourceResponse response) throws IOException {
        ResponseMessage responseMessage = null;
        try {
            IsEmailAddressAlreadyUsedResponse additionalEmailAddresses = this.additionalEmailAddressesService.isEmailAddressAlreadyUsed(request, emailAddress);
            responseMessage = new ResponseMessage((Object)additionalEmailAddresses, null, Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            responseMessage = new ResponseMessage(null, e.getMessage(), Boolean.valueOf(false));
        }
        Json.returnDeepJson((ResourceResponse)response, (Object)responseMessage);
    }

    @ResourceMapping(value="removeAdditionalEmail")
    public void removeAdditionalEmail(@RequestParam(value="emailAddressId") long emailAddressId, ResourceRequest request, ResourceResponse response) throws IOException {
        ResponseMessage responseMessage = null;
        try {
            this.additionalEmailAddressesService.removeAdditionalEmail(request, emailAddressId);
            AdditionalEmailAddresses additionalEmailAddresses = this.additionalEmailAddressesService.getEmailAddresses(request);
            responseMessage = new ResponseMessage((Object)additionalEmailAddresses, null, Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            responseMessage = new ResponseMessage(null, e.getMessage(), Boolean.valueOf(false));
        }
        Json.returnDeepJson((ResourceResponse)response, (Object)responseMessage);
    }

    @ResourceMapping(value="resendVerificationEmail")
    public void resendVerificationEmail(@RequestParam(value="emailAddressId") long emailAddressId, ResourceRequest request, ResourceResponse response) throws IOException {
        ResponseMessage responseMessage = null;
        try {
            this.additionalEmailAddressesService.resendVerificationEmail(request, emailAddressId);
            AdditionalEmailAddresses additionalEmailAddresses = this.additionalEmailAddressesService.getEmailAddresses(request);
            responseMessage = new ResponseMessage((Object)additionalEmailAddresses, null, Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            responseMessage = new ResponseMessage(null, e.getMessage(), Boolean.valueOf(false));
        }
        Json.returnDeepJson((ResourceResponse)response, (Object)responseMessage);
    }
}

