/*
 * Decompiled with CFR 0.152.
 */
package org.grade.test;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import org.apache.catalina.startup.Tomcat;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.grade.test.Bootstrap;
import org.grade.test.TestRuntime;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class EmbeddedGrade {
    private final String entrypoint;
    private final Tomcat tomcat;
    String location = "target";

    public EmbeddedGrade() {
        this("");
    }

    public EmbeddedGrade(String entrypoint) {
        this.entrypoint = entrypoint;
        this.tomcat = new Tomcat();
        this.tomcat.setPort(0);
        this.tomcat.setBaseDir(this.location);
        File webapps = new File(this.location, "webapps");
        webapps.mkdirs();
        ((ExplodedExporter)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test")).addClass(Bootstrap.class)).as(ExplodedExporter.class)).exportExploded(webapps);
        try {
            this.tomcat.addWebapp("/service", new File(webapps, "test").getAbsolutePath());
            this.tomcat.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Client client() {
        return (Client)((Client)((Client)ClientBuilder.newClient().register(MultiPartFeature.class)).register(GZipEncoder.class)).register((Object)new LoggingFilter(Logger.getLogger(LoggingFilter.class.getName()), true));
    }

    public <T> T resource(Class<T> type) {
        return (T)TestRuntime.locator().getService(type, new Annotation[0]);
    }

    public Invocation.Builder request() {
        return this.requestAt("");
    }

    public Invocation.Builder requestAt(String path) {
        return this.client().target(this.address(path)).request();
    }

    public Invocation.Builder at(String ... parts) {
        return this.requestAt(this.pathof(parts));
    }

    public String pathof(String ... compos) {
        String built = "";
        for (String compo : compos) {
            built = built + (built.isEmpty() || built.endsWith("/") || compo.startsWith("/") ? "" : "/") + compo;
        }
        return built;
    }

    private String address(String path) {
        return "http://localhost:" + this.tomcat.getConnector().getLocalPort() + "/service" + this.clean(path);
    }

    private String clean(String path) {
        return this.entrypoint + (path.isEmpty() ? path : (path.startsWith("/") ? path : "/" + path));
    }
}

