/*
 * Decompiled with CFR 0.152.
 */
package org.grade.service.aux;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.grade.common.GradeUtils;
import org.grade.service.RestAPI;
import org.grade.service.aux.ModelWriter;

@ApplicationScoped
@Provider
@Produces(value={"application/n-triples", "application/sparql-results+json", "application/sparql-results+xml", "text/csv", "text/tab-separated-values", "application/xml", "application/rdf+xml", "text/xml", "application/json", "application/ld+json", "application/x-turtle", "text/turtle"})
public class ResultSetWriter
implements MessageBodyWriter<ResultSet> {
    @Inject
    ModelWriter modelwriter;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultSet.class.isAssignableFrom(type);
    }

    public long getSize(ResultSet set, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    public void writeTo(ResultSet set, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        block7: {
            try {
                if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE) || mediaType.equals((Object)RestAPI.APPLICATION_SPARQL_RESULTS_JSON_TYPE)) {
                    ResultSetFormatter.outputAsJSON((OutputStream)entityStream, (ResultSet)set);
                    break block7;
                }
                if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE) || mediaType.equals((Object)RestAPI.APPLICATION_SPARQL_RESULTS_XML_TYPE)) {
                    ResultSetFormatter.outputAsXML((OutputStream)entityStream, (ResultSet)set);
                    break block7;
                }
                if (mediaType.equals((Object)RestAPI.TEXT_CSV_TYPE)) {
                    ResultSetFormatter.outputAsCSV((OutputStream)entityStream, (ResultSet)set);
                    break block7;
                }
                if (mediaType.equals((Object)RestAPI.TEXT_TSV_TYPE)) {
                    ResultSetFormatter.outputAsTSV((OutputStream)entityStream, (ResultSet)set);
                    break block7;
                }
                if (Arrays.asList(MediaType.APPLICATION_JSON_TYPE, RestAPI.APPLICATION_JSONLD_TYPE, RestAPI.APPLICATION_RDF_XML_TYPE, RestAPI.APPLICATION_TURTLE_TYPE, RestAPI.TEXT_TURTLE_TYPE, RestAPI.APPLICATION_NTRIPLES_TYPE).contains(mediaType)) {
                    this.modelwriter.writeTo(ResultSetFormatter.toModel((ResultSet)set), type, genericType, annotations, mediaType, httpHeaders, entityStream);
                    break block7;
                }
                throw new AssertionError((Object)("error: " + mediaType + " dispatched but not handled"));
            }
            catch (Exception e) {
                throw GradeUtils.unchecked((String)"cannot serialise resultset (see cause) ", (Throwable)e);
            }
        }
    }
}

