/*
 * Decompiled with CFR 0.152.
 */
package org.grade.service.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.grade.configuration.Configuration;
import org.grade.configuration.EndpointConfiguration;
import org.grade.configuration.GraphConfiguration;
import org.grade.configuration.QueryConfiguration;
import org.grade.configuration.RepositoryConfiguration;
import org.grade.repo.Endpoint;
import org.grade.repo.Repository;
import org.grade.service.RestAPI;
import org.grade.service.tos.CopyMoveGraphConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryResource<R extends Repository<?>> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryResource.class);
    R repo;
    Configuration cfg;
    RepositoryConfiguration rcfg;
    Event<Configuration> events;
    @Inject
    ObjectMapper mapper;

    RepositoryResource() {
    }

    public RepositoryResource(R repo, Configuration cfg, RepositoryConfiguration rcfg, Event<Configuration> events) {
        this.repo = repo;
        this.cfg = cfg;
        this.rcfg = rcfg;
        this.events = events;
    }

    @GET
    @Path(value="/endpoints")
    @Produces(value={"application/json"})
    public List<EndpointConfiguration> endpoints() {
        return this.rcfg.endpoints();
    }

    @POST
    @Path(value="/endpoints")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public EndpointConfiguration register(EndpointConfiguration ecfg) {
        Endpoint ep = this.repo.endpoints().register(ecfg);
        ep.sync();
        this.events.fire((Object)this.cfg);
        return ecfg;
    }

    @DELETE
    @Path(value="/endpoint/{key}")
    public void unregisterEndpoint(@PathParam(value="key") String key) {
        this.repo.endpoints().unregister(key);
        this.events.fire((Object)this.cfg);
    }

    @GET
    @Path(value="/endpoint/{key}")
    @Produces(value={"application/json"})
    public EndpointConfiguration endpoint(@PathParam(value="key") String key) {
        Endpoint ep = this.repo.endpoints().resolve(key);
        if (ep.sync()) {
            this.events.fire((Object)this.cfg);
        }
        return ep.configuration();
    }

    @GET
    @Path(value="/endpoint/{key}/resolve")
    @Produces(value={"application/n-triples", "application/json", "application/ld+json", "application/xml", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/sparql-results+json", "application/sparql-results+xml", "text/csv", "text/tab-separated-values"})
    public Object resolve(@PathParam(value="key") String key, @HeaderParam(value="Accept") List<String> types, @QueryParam(value="uri") @NonNull String uri, @QueryParam(value="backwards") boolean backwards) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        String expression = backwards ? String.format("construct {?s ?p <%1$s>} where {?s ?p <%1$s>}", uri) : String.format("describe <%s>", uri);
        QueryConfiguration describe = QueryConfiguration.query((String)"resolve-query", (String)key, (String)expression);
        Object results = this.repo.execute(describe, Collections.emptyMap());
        Response.ResponseBuilder response = Response.ok().entity(results);
        if (!this.thereIsASupportedMediaTypeAmong(types)) {
            response = response.type(RestAPI.default_type_for(results));
        }
        return response.build();
    }

    @POST
    @Path(value="/endpoint/{target}/graphs")
    @Consumes(value={"application/json"})
    public void addGraph(@PathParam(value="target") @NonNull String target, String stream) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        Supplier<GraphConfiguration> body = () -> {
            try {
                return (GraphConfiguration)this.mapper.readValue(stream, GraphConfiguration.class);
            }
            catch (Exception tryother) {
                try {
                    return (GraphConfiguration)this.mapper.readValue(stream, CopyMoveGraphConfiguration.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("malformed request: cannot recognize directives", e);
                }
            }
        };
        GraphConfiguration graph = body.get();
        if (graph instanceof CopyMoveGraphConfiguration) {
            CopyMoveGraphConfiguration directives = (CopyMoveGraphConfiguration)graph;
            Endpoint sourceEndpoint = this.repo.endpoints().resolve(directives.source());
            Endpoint targetEndpoint = this.repo.endpoints().resolve(target);
            if (targetEndpoint.exists(directives.uri())) {
                throw new IllegalArgumentException(String.format("cannot copy/move to endpoint %s: graph %s already exists.", targetEndpoint.configuration().name(), directives.uri()));
            }
            Model model = sourceEndpoint.get(directives.sourceGraph());
            model.removeAll(model.createResource(directives.sourceGraph()), null, null);
            targetEndpoint.create((GraphConfiguration)directives, model);
            if (directives.move() && sourceEndpoint.configuration().canDelete()) {
                try {
                    sourceEndpoint.remove(directives.sourceGraph());
                }
                catch (Exception wontfailforthis) {
                    log.error("could not remove graph " + directives.sourceGraph() + " on move", (Throwable)wontfailforthis);
                }
            }
        } else {
            Endpoint ep = this.repo.endpoints().resolve(target);
            ep.create(graph);
        }
        this.events.fire((Object)this.cfg);
    }

    @PUT
    @Path(value="/endpoint/{key}/graphs")
    @Consumes(value={"application/json"})
    public void updateGraph(@PathParam(value="key") @NonNull String key, GraphConfiguration graph) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        Endpoint ep = this.repo.endpoints().resolve(key);
        ep.edit(graph);
        this.events.fire((Object)this.cfg);
    }

    @DELETE
    @Path(value="/endpoint/{key}/graphs")
    public void deleteGraph(@PathParam(value="key") @NonNull String key, @QueryParam(value="uri") @NonNull String uri) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        Endpoint ep = this.repo.endpoints().resolve(key);
        ep.remove(uri);
        this.events.fire((Object)this.cfg);
    }

    @GET
    @Path(value="/queries")
    @Produces(value={"application/json"})
    public List<QueryConfiguration> queries() {
        return this.rcfg.queries();
    }

    @POST
    @Path(value="/queries")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public QueryConfiguration register(QueryConfiguration qcfg) {
        this.repo.queries().register(qcfg);
        this.events.fire((Object)this.cfg);
        return qcfg;
    }

    @DELETE
    @Path(value="/query/{name}")
    @Consumes(value={"application/json"})
    public void unregisterQuery(@PathParam(value="name") String name) {
        this.repo.queries().unregister(name);
        this.events.fire((Object)this.cfg);
    }

    @GET
    @Path(value="/query/{name}/results")
    @Produces(value={"application/n-triples", "application/json", "application/ld+json", "application/xml", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/sparql-results+json", "application/sparql-results+xml", "text/csv", "text/tab-separated-values"})
    public Object execute(@PathParam(value="name") String name, @Context UriInfo info, @HeaderParam(value="Accept") List<String> types) {
        Object results = this.repo.execute(name, this.paramsfrom(info));
        Response.ResponseBuilder response = Response.ok().entity(results);
        if (!this.thereIsASupportedMediaTypeAmong(types)) {
            response = response.type(RestAPI.default_type_for(results));
        }
        return response.build();
    }

    @POST
    @Path(value="/submit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/n-triples", "application/json", "application/ld+json", "application/xml", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/sparql-results+json", "application/sparql-results+xml", "text/csv", "text/tab-separated-values"})
    public Response submit(QueryConfiguration qcfg, @Context UriInfo info, @HeaderParam(value="Accept") List<String> types, @QueryParam(value="grade_limit") @DefaultValue(value="100") String limit) {
        Map<String, String> params = this.paramsfrom(info);
        if (limit != null) {
            params.put("grade_limit", limit);
        }
        Object results = this.repo.execute(qcfg, params);
        Response.ResponseBuilder response = Response.ok().entity(results);
        if (!this.thereIsASupportedMediaTypeAmong(types)) {
            response = response.type(RestAPI.default_type_for(results));
        }
        return response.build();
    }

    Map<String, String> paramsfrom(UriInfo info) {
        HashMap<String, String> flattened = new HashMap<String, String>();
        for (Map.Entry entry : info.getQueryParameters().entrySet()) {
            flattened.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        return flattened;
    }

    private boolean thereIsASupportedMediaTypeAmong(List<String> types) {
        if (types != null) {
            for (String type : types) {
                if (!RestAPI.supported_types.contains(type)) continue;
                return true;
            }
        }
        return false;
    }
}

