/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.grade.common.GradeUtils;
import org.grade.repo.utils.RepositoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    public static final String task_namespace = "http://data.gradesystem.eu/entity/task/";
    public static final String graph_namespace = "http://data.gradesystem.eu/graphs/catalogue/task/";
    public static final String task_operation = "operation";
    public static final String task_note = "note";
    public static final String task_source_endpoint = "source endpoint";
    public static final String task_source_graph = "source graph";
    public static final String task_target_endpoint = "target endpoint";
    public static final String task_target_graph = "target graph";
    public static final String task_transform_query = "transform";
    public static final String task_diff_query = "difference";
    public static final String task_creator = "author";
    private static Model voc = ModelFactory.createDefaultModel();
    public static final String task_vocab = "http://data.gradesystem.eu/onto/task.owl";
    private static final String skoschema = "http://www.w3.org/2004/02/skos/core";
    public static final String task_root = "http://data.gradesystem.eu/onto/task.owl#Task";
    public static final String task_publish_operation = "http://data.gradesystem.eu/onto/task.owl#publish";
    public static final String task_add_operation = "http://data.gradesystem.eu/onto/task.owl#add";
    public static final String task_remove_operation = "http://data.gradesystem.eu/onto/task.owl#remove";
    public static final Property type_prop = RDF.type;
    public static final Property label_prop = RDFS.label;
    public static final Property note_prop = voc.createProperty("http://www.w3.org/2004/02/skos/core#editorialNote");
    public static final Property operation_prop = voc.createProperty("http://data.gradesystem.eu/onto/task.owl#operation");
    public static final Property source_endpoint_prop = voc.createProperty("http://data.gradesystem.eu/onto/task.owl#source_endpoint");
    public static final Property source_graph_prop = voc.createProperty("http://data.gradesystem.eu/onto/task.owl#source_graph");
    public static final Property target_endpoint_prop = voc.createProperty("http://data.gradesystem.eu/onto/task.owl#target_endpoint");
    public static final Property target_graph_prop = voc.createProperty("http://data.gradesystem.eu/onto/task.owl#target_graph");
    public static final Property transform_query_prop = voc.createProperty("http://data.gradesystem.eu/onto/task.owl#transform");
    public static final Property diff_query_prop = voc.createProperty("http://data.gradesystem.eu/onto/task.owl#difference");
    public static final Property creator_prop = DCTerms.creator;
    @JsonProperty(value="uri")
    private String uri = Task.generated();
    @JsonProperty(value="label")
    @NonNull
    private String label;
    @JsonProperty(value="operation")
    @NonNull
    private Operation operation;
    @JsonProperty(value="source endpoint")
    private String sourceEndpoint;
    @JsonProperty(value="source graph")
    private Set<String> sourceGraphs = new HashSet<String>();
    @JsonProperty(value="target endpoint")
    private String targetEndpoint;
    @JsonProperty(value="target graph")
    private String targetGraph;
    @JsonProperty(value="note")
    private String note;
    @JsonProperty(value="transform")
    @NonNull
    private String transformQuery;
    @JsonProperty(value="difference")
    private String diffQuery;
    @JsonProperty(value="author")
    private String creator;

    private static final String generated() {
        return task_namespace + UUID.randomUUID();
    }

    public static final String toGraphUri(String taskuri) {
        String local = taskuri.substring(taskuri.lastIndexOf("/") + 1);
        return graph_namespace + local;
    }

    public Task(Resource resource) {
        this.from(resource);
    }

    public Task uri(String taskUri) {
        if (taskUri != null) {
            GradeUtils.validUri((String)"task uri", (String)taskUri);
        }
        this.uri = taskUri;
        return this;
    }

    public String graphUri() {
        return Task.toGraphUri(this.uri);
    }

    public void generateUri() {
        this.uri(Task.generated());
    }

    public Task creator(@NonNull String creator) {
        if (creator == null) {
            throw new IllegalArgumentException("creator is null");
        }
        GradeUtils.validUri((String)"task creator", (String)creator);
        this.creator = creator;
        return this;
    }

    public Task sourceEndpoint(@NonNull String sourceEndpoint) {
        if (sourceEndpoint == null) {
            throw new IllegalArgumentException("sourceEndpoint is null");
        }
        this.sourceEndpoint = sourceEndpoint;
        return this;
    }

    public Task sourceGraphs(Set<String> uris) {
        GradeUtils.validUris((String)task_source_graph, uris);
        this.sourceGraphs = uris;
        return this;
    }

    public Task targetEndpoint(@NonNull String targetEndpoint) {
        if (targetEndpoint == null) {
            throw new IllegalArgumentException("targetEndpoint is null");
        }
        this.targetEndpoint = targetEndpoint;
        return this;
    }

    public Task targetGraph(@NonNull String targetGraph) {
        if (targetGraph == null) {
            throw new IllegalArgumentException("targetGraph is null");
        }
        GradeUtils.validUri((String)task_target_graph, (String)targetGraph);
        this.targetGraph = targetGraph;
        return this;
    }

    public Task transformQuery(@NonNull String transform) {
        if (transform == null) {
            throw new IllegalArgumentException("transform is null");
        }
        try {
            if (RepositoryUtils.parse(transform).isSelectType()) {
                throw new IllegalArgumentException("transforms cannot be SELECT queries");
            }
            this.transformQuery = transform;
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid transformation query", e);
        }
    }

    public Task diffQuery(@NonNull String difference) {
        if (difference == null) {
            throw new IllegalArgumentException("difference is null");
        }
        try {
            if (RepositoryUtils.parse(difference).isSelectType()) {
                throw new IllegalArgumentException("differences cannot be SELECT queries");
            }
            this.diffQuery = QueryFactory.create((String)difference).toString();
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid difference query", e);
        }
    }

    public void validate() throws IllegalStateException {
        try {
            Task check = new Task().uri(this.uri).label(this.label).sourceEndpoint(this.sourceEndpoint).sourceGraphs(this.sourceGraphs).targetEndpoint(this.targetEndpoint).targetGraph(this.targetGraph).operation(this.operation).transformQuery(this.transformQuery).creator(this.creator);
            if (this.operation != Operation.publish && this.diffQuery == null) {
                throw new IllegalStateException("not a publish task, yet no diff query either.");
            }
            if (this.diffQuery != null) {
                if (this.operation == Operation.publish) {
                    throw new IllegalStateException("publish tasks have no diff queries.");
                }
                check.diffQuery(this.diffQuery);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Resource resource() throws IllegalStateException {
        this.validate();
        Model model = ModelFactory.createDefaultModel();
        Resource task = model.createResource(this.uri);
        task.addProperty(type_prop, (RDFNode)model.createResource(task_root)).addProperty(label_prop, this.label).addProperty(operation_prop, (RDFNode)model.createResource(this.operation.uri())).addProperty(source_endpoint_prop, this.sourceEndpoint).addProperty(target_endpoint_prop, this.targetEndpoint).addProperty(transform_query_prop, this.transformQuery).addProperty(creator_prop, (RDFNode)model.createResource(this.creator));
        for (String graph : this.sourceGraphs) {
            task.addProperty(source_graph_prop, (RDFNode)model.createResource(graph));
        }
        if (this.targetGraph != null) {
            task.addProperty(target_graph_prop, (RDFNode)model.createResource(this.targetGraph));
        }
        if (this.note != null) {
            task.addProperty(note_prop, this.note);
        }
        if (this.diffQuery != null) {
            task.addProperty(diff_query_prop, this.diffQuery);
        }
        return task;
    }

    private void from(Resource resource) throws IllegalArgumentException {
        this.uri = resource.getURI();
        try {
            this.label = this.value(resource, label_prop);
            this.operation = Operation.operation(this.value(resource, operation_prop));
            this.sourceEndpoint = this.value(resource, source_endpoint_prop);
            this.creator = this.value(resource, creator_prop);
            this.sourceGraphs = this.values(resource, source_graph_prop);
            this.targetEndpoint = this.value(resource, target_endpoint_prop);
            this.targetGraph = this.value(resource, target_graph_prop);
            this.transformQuery = this.value(resource, transform_query_prop);
            this.diffQuery = this.value(resource, diff_query_prop);
            this.note = this.value(resource, note_prop);
        }
        catch (Exception e) {
            log.error("could not parse task {}: {}", (Object)this.uri, e.getMessage() == null ? e : e.getMessage());
            throw new IllegalArgumentException("invalid task model", e);
        }
    }

    private String value(Resource r, Property p) {
        return this.valueOf(r.getProperty(p));
    }

    private Set<String> values(Resource r, Property p) {
        HashSet<String> values = new HashSet<String>();
        StmtIterator it = r.listProperties(p);
        while (it.hasNext()) {
            values.add(this.valueOf((Statement)it.next()));
        }
        return values;
    }

    String valueOf(Statement stmt) {
        return stmt == null ? null : (stmt.getObject().isLiteral() ? stmt.getString() : stmt.getResource().getURI());
    }

    public String uri() {
        return this.uri;
    }

    @NonNull
    public String label() {
        return this.label;
    }

    @NonNull
    public Operation operation() {
        return this.operation;
    }

    public String sourceEndpoint() {
        return this.sourceEndpoint;
    }

    public Set<String> sourceGraphs() {
        return this.sourceGraphs;
    }

    public String targetEndpoint() {
        return this.targetEndpoint;
    }

    public String targetGraph() {
        return this.targetGraph;
    }

    public String note() {
        return this.note;
    }

    @NonNull
    public String transformQuery() {
        return this.transformQuery;
    }

    public String diffQuery() {
        return this.diffQuery;
    }

    public String creator() {
        return this.creator;
    }

    public Task label(@NonNull String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public Task operation(@NonNull Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation is null");
        }
        this.operation = operation;
        return this;
    }

    public Task note(String note) {
        this.note = note;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.uri();
        String other$uri = other.uri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$label = this.label();
        String other$label = other.label();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Operation this$operation = this.operation();
        Operation other$operation = other.operation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        String this$sourceEndpoint = this.sourceEndpoint();
        String other$sourceEndpoint = other.sourceEndpoint();
        if (this$sourceEndpoint == null ? other$sourceEndpoint != null : !this$sourceEndpoint.equals(other$sourceEndpoint)) {
            return false;
        }
        Set<String> this$sourceGraphs = this.sourceGraphs();
        Set<String> other$sourceGraphs = other.sourceGraphs();
        if (this$sourceGraphs == null ? other$sourceGraphs != null : !((Object)this$sourceGraphs).equals(other$sourceGraphs)) {
            return false;
        }
        String this$targetEndpoint = this.targetEndpoint();
        String other$targetEndpoint = other.targetEndpoint();
        if (this$targetEndpoint == null ? other$targetEndpoint != null : !this$targetEndpoint.equals(other$targetEndpoint)) {
            return false;
        }
        String this$targetGraph = this.targetGraph();
        String other$targetGraph = other.targetGraph();
        if (this$targetGraph == null ? other$targetGraph != null : !this$targetGraph.equals(other$targetGraph)) {
            return false;
        }
        String this$note = this.note();
        String other$note = other.note();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        String this$transformQuery = this.transformQuery();
        String other$transformQuery = other.transformQuery();
        if (this$transformQuery == null ? other$transformQuery != null : !this$transformQuery.equals(other$transformQuery)) {
            return false;
        }
        String this$diffQuery = this.diffQuery();
        String other$diffQuery = other.diffQuery();
        if (this$diffQuery == null ? other$diffQuery != null : !this$diffQuery.equals(other$diffQuery)) {
            return false;
        }
        String this$creator = this.creator();
        String other$creator = other.creator();
        return !(this$creator == null ? other$creator != null : !this$creator.equals(other$creator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.uri();
        result = result * 59 + ($uri == null ? 0 : $uri.hashCode());
        String $label = this.label();
        result = result * 59 + ($label == null ? 0 : $label.hashCode());
        Operation $operation = this.operation();
        result = result * 59 + ($operation == null ? 0 : ((Object)((Object)$operation)).hashCode());
        String $sourceEndpoint = this.sourceEndpoint();
        result = result * 59 + ($sourceEndpoint == null ? 0 : $sourceEndpoint.hashCode());
        Set<String> $sourceGraphs = this.sourceGraphs();
        result = result * 59 + ($sourceGraphs == null ? 0 : ((Object)$sourceGraphs).hashCode());
        String $targetEndpoint = this.targetEndpoint();
        result = result * 59 + ($targetEndpoint == null ? 0 : $targetEndpoint.hashCode());
        String $targetGraph = this.targetGraph();
        result = result * 59 + ($targetGraph == null ? 0 : $targetGraph.hashCode());
        String $note = this.note();
        result = result * 59 + ($note == null ? 0 : $note.hashCode());
        String $transformQuery = this.transformQuery();
        result = result * 59 + ($transformQuery == null ? 0 : $transformQuery.hashCode());
        String $diffQuery = this.diffQuery();
        result = result * 59 + ($diffQuery == null ? 0 : $diffQuery.hashCode());
        String $creator = this.creator();
        result = result * 59 + ($creator == null ? 0 : $creator.hashCode());
        return result;
    }

    public String toString() {
        return "Task(uri=" + this.uri() + ", label=" + this.label() + ", operation=" + (Object)((Object)this.operation()) + ", sourceEndpoint=" + this.sourceEndpoint() + ", sourceGraphs=" + this.sourceGraphs() + ", targetEndpoint=" + this.targetEndpoint() + ", targetGraph=" + this.targetGraph() + ", note=" + this.note() + ", transformQuery=" + this.transformQuery() + ", diffQuery=" + this.diffQuery() + ", creator=" + this.creator() + ")";
    }

    private Task() {
    }

    public static Task task() {
        return new Task();
    }

    public static enum Operation {
        add("http://data.gradesystem.eu/onto/task.owl#add"),
        remove("http://data.gradesystem.eu/onto/task.owl#remove"),
        publish("http://data.gradesystem.eu/onto/task.owl#publish");

        private String uri;

        private Operation(String uri) {
            this.uri = uri;
        }

        @JsonValue
        public String uri() {
            return this.uri;
        }

        public static Operation operation(String uri) {
            if (uri == null) {
                throw new IllegalStateException("missing operation on task");
            }
            switch (uri) {
                case "http://data.gradesystem.eu/onto/task.owl#add": {
                    return add;
                }
                case "http://data.gradesystem.eu/onto/task.owl#remove": {
                    return remove;
                }
                case "http://data.gradesystem.eu/onto/task.owl#publish": {
                    return publish;
                }
            }
            throw new IllegalArgumentException("unknown operation " + uri);
        }
    }
}

