/*
 * Decompiled with CFR 0.152.
 */
package org.grade.io;

import com.hp.hpl.jena.rdf.model.Model;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.grade.common.annotation.Qualifiers;
import org.grade.configuration.GraphConfiguration;
import org.grade.io.SourceInfo;
import org.grade.io.Transformer;
import org.grade.repo.Endpoint;
import org.grade.repo.GenericRepository;

@ApplicationScoped
public class DropinService {
    private static final String staging_graph_ns = "http://data.gradesystem.eu/graphs/upload/";
    @Inject
    @Qualifiers.Staging
    private GenericRepository repo;
    @Inject
    private Transformer transformer;

    public void dropin(SourceInfo info, Object contents) {
        Model model = this.transformer.transform(contents);
        Endpoint ep = this.repo.endpoints().resolve(info.endpoint());
        if (ep.configuration().locked()) {
            throw new IllegalArgumentException("cannot upload to " + ep.configuration().name() + ", as it is protected");
        }
        String uri = staging_graph_ns + info.label();
        String label = info.label();
        GraphConfiguration graph = GraphConfiguration.graph((String)uri).label(label);
        ep.create(graph, model);
    }
}

